/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle_spawning;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.config.type.BrushParticleBehaviour;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.option.ArcEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.option.DripParticleOption;
import games.enchanted.eg_particle_interactions.common.particle.option.RandomDistributionEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.option.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverrides;
import games.enchanted.eg_particle_interactions.common.particle_override.FluidPlacementParticle;
import games.enchanted.eg_particle_interactions.common.particle_spawning.ParticleCategory;
import games.enchanted.eg_particle_interactions.common.particle_spawning.ParticlePositionHelpers;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticlesUtil;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.registry.TagUtil;
import games.enchanted.eg_particle_interactions.common.util.FluidHelpers;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3713;
import net.minecraft.class_3865;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SpawnParticles {
    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos) {
        class_2680 placedBlockState = level.method_8320(blockPos);
        SpawnParticles.spawnBlockPlaceParticle(level, blockPos, placedBlockState);
    }

    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos, class_2680 placedBlockState) {
        int overrideOrigin;
        BlockParticleOverride particleOverride;
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, blockPos)) {
            return;
        }
        if (ConfigHandler.underwaterBubbles_onPlace) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onPlace, (class_1937)level, blockPos);
        }
        if ((particleOverride = BlockParticleOverride.getOverrideForBlockState(placedBlockState, overrideOrigin = 1)) == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerEdge = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, true);
        if (maxParticlesPerEdge <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!placedBlockState.method_26215() && placedBlockState.method_45475()) {
            class_265 blockShape = placedBlockState.method_26218((class_1922)level, blockPos);
            if (blockShape.method_1110()) {
                return;
            }
            class_243 blockCenter = blockShape.method_1107().method_1005();
            double verticalAxisOffset = level.method_8320(blockPos.method_10069(0, -1, 0)).method_51367() ? 0.01 : 0.0;
            blockShape.method_1104((x1, y1, z1, x2, y2, z2) -> {
                class_2350.class_2351 biggestEdge;
                double edgeLength;
                double width = Math.abs(x1 - x2);
                double height = Math.abs(y1 - y2);
                double depth = Math.abs(z1 - z2);
                if (width > height && width > depth) {
                    edgeLength = width;
                    biggestEdge = class_2350.class_2351.field_11048;
                } else if (height > width && height > depth) {
                    edgeLength = height;
                    biggestEdge = class_2350.class_2351.field_11052;
                } else {
                    edgeLength = depth;
                    biggestEdge = class_2350.class_2351.field_11051;
                }
                int amountOfParticlesAlongEdge = class_3532.method_15384((double)(edgeLength * (double)maxParticlesPerEdge));
                if (amountOfParticlesAlongEdge < 1) {
                    amountOfParticlesAlongEdge = 1;
                }
                for (int i = 0; i < amountOfParticlesAlongEdge; ++i) {
                    double particlePos = ((double)i + 0.5) / (double)amountOfParticlesAlongEdge;
                    if (particlePos > edgeLength + 0.0625) continue;
                    double particleXOffset = (biggestEdge == class_2350.class_2351.field_11048 ? particlePos : width) + x1;
                    double particleYOffset = (biggestEdge == class_2350.class_2351.field_11052 ? particlePos : height) + y1 + verticalAxisOffset;
                    double particleZOffset = (biggestEdge == class_2350.class_2351.field_11051 ? particlePos : depth) + z1;
                    class_2394 particleToSpawn = particleOverride.getParticleOptionForState(placedBlockState, level, blockPos, overrideOrigin);
                    if (particleToSpawn == null) continue;
                    level.method_8406(particleToSpawn, (double)blockPos.method_10263() + MathHelpers.expandWhenOutOfBound(particleXOffset, 0.0, 1.0), (double)blockPos.method_10264() + MathHelpers.expandWhenOutOfBound(particleYOffset, 0.0, 1.0), (double)blockPos.method_10260() + MathHelpers.expandWhenOutOfBound(particleZOffset, 0.0, 1.0), (particleXOffset - blockCenter.method_10216()) * particleOutwardVelocityAdjustment, (particleYOffset - blockCenter.method_10214()) * particleOutwardVelocityAdjustment, (particleZOffset - blockCenter.method_10215()) * particleOutwardVelocityAdjustment);
                }
            });
        }
    }

    public static void spawnBlockBreakParticle(class_638 level, class_2680 brokenBlockState, class_2338 brokenBlockPos, BlockParticleOverride particleOverride) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, brokenBlockPos)) {
            return;
        }
        if (ConfigHandler.underwaterBubbles_onBreak) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onBreak, (class_1937)level, brokenBlockPos);
        }
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerLength = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, false);
        if (maxParticlesPerLength <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!brokenBlockState.method_26215() && brokenBlockState.method_45475()) {
            class_265 blockShape = brokenBlockState.method_26218((class_1922)level, brokenBlockPos);
            if (blockShape.method_1110()) {
                return;
            }
            class_243 blockCenter = blockShape.method_1107().method_1005();
            blockShape.method_1089((x1, y1, z1, x2, y2, z2) -> {
                double width = Math.abs(x1 - x2);
                int amountAlongWidth = Math.clamp((long)class_3532.method_15384((double)(width * (double)maxParticlesPerLength)), 1, 999);
                double height = Math.abs(y1 - y2);
                int amountAlongHeight = Math.clamp((long)class_3532.method_15384((double)(height * (double)maxParticlesPerLength)), 1, 999);
                double depth = Math.abs(z1 - z2);
                int amountAlongDepth = Math.clamp((long)class_3532.method_15384((double)(depth * (double)maxParticlesPerLength)), 1, 999);
                for (int i_W = 0; i_W < amountAlongWidth; ++i_W) {
                    for (int i_H = 0; i_H < amountAlongHeight; ++i_H) {
                        for (int i_D = 0; i_D < amountAlongDepth; ++i_D) {
                            double particleXOffset = ((double)i_W + 0.5) / (double)amountAlongWidth;
                            double particleYOffset = ((double)i_H + 0.5) / (double)amountAlongHeight;
                            double particleZOffset = ((double)i_D + 0.5) / (double)amountAlongDepth;
                            class_2394 particleToSpawn = particleOverride.getParticleOptionForState(brokenBlockState, level, brokenBlockPos, 2);
                            if (particleToSpawn == null) continue;
                            level.method_8406(particleToSpawn, (double)brokenBlockPos.method_10263() + (particleXOffset * width + x1), (double)brokenBlockPos.method_10264() + (particleYOffset * height + y1), (double)brokenBlockPos.method_10260() + (particleZOffset * depth + z1), (particleXOffset - blockCenter.method_10216()) * particleOutwardVelocityAdjustment, (particleYOffset - blockCenter.method_10214()) * particleOutwardVelocityAdjustment, (particleZOffset - blockCenter.method_10215()) * particleOutwardVelocityAdjustment);
                        }
                    }
                }
            });
        }
    }

    private static void spawnUnderwaterBubbles(int amountOfBubbles, class_1937 level, class_2338 blockPos) {
        if (!FluidHelpers.probablyPlacedUnderwater(level, blockPos)) {
            return;
        }
        for (int i = 0; i < Math.max(amountOfBubbles + level.field_9229.method_39332(-2, 0), 1); ++i) {
            double x = level.field_9229.method_43058();
            double y = level.field_9229.method_43058();
            double z = level.field_9229.method_43058();
            boolean blockAboveIsWater = level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517);
            double verticalVelocity = (y - 0.5) * (double)(blockAboveIsWater ? 2 : 0);
            double horizontalVelocityMul = !blockAboveIsWater ? 1.5 : 1.0;
            level.method_8406((class_2394)ModParticleTypes.UNDERWATER_RISING_BUBBLE, (double)blockPos.method_10263() + x, (double)blockPos.method_10264() + y, (double)blockPos.method_10260() + z, (x - 0.5) * 2.0 * horizontalVelocityMul, level.method_8320(blockPos.method_10074()).method_51367() ? Math.abs(verticalVelocity) + 0.1 : verticalVelocity, (z - 0.5) * 2.0 * horizontalVelocityMul);
        }
    }

    public static void spawnFallingBlockRandomFallParticles(class_638 level, class_2680 blockState, double x, double y, double z, class_243 deltaMovement) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (!ConfigHandler.fallingBlockEffect_enabled) {
            return;
        }
        if (blockState.method_26215()) {
            return;
        }
        int overrideOrigin = 8;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.NONE || particleOverride == BlockParticleOverride.VANILLA) {
            return;
        }
        for (int i = 0; i < level.field_9229.method_39332(1, 4); ++i) {
            class_2394 particleOptions = particleOverride.getParticleOptionForState(blockState, level, class_2338.method_49637((double)x, (double)y, (double)z), overrideOrigin);
            if (particleOptions == null) continue;
            level.method_8406(particleOptions, x - 0.5 + (double)level.field_9229.method_43057(), y + (double)level.field_9229.method_43057(), z - 0.5 + (double)level.field_9229.method_43057(), deltaMovement.field_1352 * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()), deltaMovement.field_1351 * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()), deltaMovement.field_1350 * 3.0 * (double)(-particleOverride.getParticleVelocityMultiplier()));
        }
    }

    public static void spawnFallingBlockLandParticles(class_638 level, class_2680 blockState, double x, double y, double z, class_243 deltaMovement) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (!ConfigHandler.fallingBlockEffect_enabled) {
            return;
        }
        int overrideOrigin = 7;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        double movementSpeed = deltaMovement.method_1033();
        double particleY = (double)Math.round(y + deltaMovement.field_1351 / 2.0 - 0.1) + 0.0625;
        SpawnParticlesUtil.spawnParticleInCircle(particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin), level, new class_243(x, particleY, z), 16, 0.4f, 0.9f, 1.7f * (float)(movementSpeed * 2.0) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()), 0.035f, 0.0f);
        SpawnParticlesUtil.spawnParticleInCircle(particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin), level, new class_243(x, particleY + (double)0.7f, z), 16, 0.3f, 0.95f, 0.2f, -0.4f * (float)(movementSpeed * 2.0) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()), 0.0f);
    }

    public static void spawnSparksAtMinecartWheels(double minecartX, double minecartY, double minecartZ, double minecartHorizontalRot, double minecartVerticalRot, boolean isOnRails, boolean hasPassenger, boolean hasBlock, class_243 deltaMovement, double maxSpeed, class_1937 level) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, minecartX, minecartY, minecartZ)) {
            return;
        }
        if (!ConfigHandler.minecart_enabled) {
            return;
        }
        if (!isOnRails) {
            return;
        }
        if (!hasBlock && !hasPassenger && ConfigHandler.minecart_onlyWithPassenger) {
            return;
        }
        double speed = MathHelpers.maxVec3(deltaMovement.method_46409(), true);
        if (speed < 0.05) {
            return;
        }
        float sparksChancePerWheel = (float)(Math.clamp(speed, 0.0, maxSpeed) / maxSpeed) - 0.75f;
        sparksChancePerWheel *= (float)ConfigHandler.minecart_spawnChance / 50.0f;
        float rotX = (float)(minecartHorizontalRot * (Math.PI / 180));
        float rotY = (float)(minecartVerticalRot * (Math.PI / 180));
        float sparkDeltaX = (float)Math.clamp(-deltaMovement.field_1352 / 3.0, -0.7, 0.7);
        float sparkDeltaZ = (float)Math.clamp(-deltaMovement.field_1350 / 3.0, -0.7, 0.7);
        minecartY += 0.0425;
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos1 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, 0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos1.x + minecartX, (double)wheelPos1.y + minecartY, (double)wheelPos1.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos2 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, 0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos2.x + minecartX, (double)wheelPos2.y + minecartY, (double)wheelPos2.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos3 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, -0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos3.x + minecartX, (double)wheelPos3.y + minecartY, (double)wheelPos3.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos4 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, -0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos4.x + minecartX, (double)wheelPos4.y + minecartY, (double)wheelPos4.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
    }

    private static Vector3f minecartWheelPoint(float rotationX, float rotationY, float pointX, float pointY, float pointZ) {
        return new Vector3f((float)((double)pointX * Math.cos(rotationX) - (double)pointZ * Math.sin(rotationX)), pointY * rotationY, (float)((double)pointZ * Math.cos(rotationX) + (double)pointX * Math.sin(rotationX)));
    }

    public static void spawnFlintAndSteelSparkParticle(class_1937 level, class_2338 particlePos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) {
            return;
        }
        if (!ConfigHandler.flintAndSteelSpark_onUse) {
            return;
        }
        class_2680 fireOrLitBlock = level.method_8320(particlePos);
        boolean isSoulBlock = level.method_8320(particlePos.method_10074()).method_26164(class_3481.field_23119) || fireOrLitBlock.method_27852(class_2246.field_23860);
        double sparkIntensity = (double)ConfigHandler.flintAndSteelSpark_intensity / 12.0;
        for (int i = 0; i < ConfigHandler.maxFlintAndSteelSpark_onUse; ++i) {
            double x = (double)particlePos.method_10263() + 0.25 + level.field_9229.method_43058() / 2.0;
            double y = (double)particlePos.method_10264() + 0.25 + level.field_9229.method_43058() / 2.0;
            double z = (double)particlePos.method_10260() + 0.25 + level.field_9229.method_43058() / 2.0;
            level.method_8406((class_2394)(isSoulBlock ? ModParticleTypes.FLYING_SOUL_SPARK : ModParticleTypes.FLYING_SPARK), x, y, z, (level.field_9229.method_43058() - 0.5) * sparkIntensity, (level.field_9229.method_43058() + 0.5) * sparkIntensity, (level.field_9229.method_43058() - 0.5) * sparkIntensity);
        }
    }

    public static void spawnAmbientCampfireSparks(class_1937 level, class_2338 particlePos, class_2680 campfireState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) {
            return;
        }
        if (ConfigHandler.campfireSpark_enabled) {
            double sparkIntensity = 0.4166666666666667;
            if (level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.campfireSpark_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; ++i) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (class_2394)(campfireState.method_27852(class_2246.field_23860) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.method_10263() + 0.5, (double)particlePos.method_10264() + 0.5, (double)particlePos.method_10260() + 0.5, sparkIntensity);
                }
            }
        }
        if (ConfigHandler.campfireEmber_enabled && level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.campfireEmber_spawnChance) {
            for (int i = 0; i < level.field_9229.method_39332(1, 4); ++i) {
                level.method_8406((class_2394)(campfireState.method_27852(class_2246.field_23860) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER), (double)particlePos.method_10263() + (double)level.field_9229.method_43057() * 0.75 + 0.125, (double)particlePos.method_10264() + (double)level.field_9229.method_43057() * 0.75 + 0.125, (double)particlePos.method_10260() + (double)level.field_9229.method_43057() * 0.75 + 0.125, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnAmbientFireSparks(class_1937 level, class_2680 fireState, class_2338 particlePos, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) {
            return;
        }
        double width = Math.abs(minX - maxX);
        double height = Math.abs(minY - maxY);
        double depth = Math.abs(minZ - maxZ);
        if (ConfigHandler.fireSpark_enabled) {
            double sparkIntensity = 0.4166666666666667;
            if (level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.fireSpark_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; ++i) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (class_2394)(fireState.method_27852(class_2246.field_22089) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.method_10263() + minX + (double)level.field_9229.method_43057() * width, (double)particlePos.method_10264() + minY + (double)level.field_9229.method_43057() * height, (double)particlePos.method_10260() + minZ + (double)level.field_9229.method_43057() * depth, sparkIntensity);
                }
            }
        }
        if (ConfigHandler.fireEmber_enabled && level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.fireEmber_spawnChance) {
            for (int i = 0; i < level.field_9229.method_39332(1, 4); ++i) {
                level.method_8406((class_2394)(fireState.method_27852(class_2246.field_22089) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER), (double)particlePos.method_10263() + minX + (double)level.field_9229.method_43057() * width, (double)particlePos.method_10264() + minY + (double)level.field_9229.method_43057() * height, (double)particlePos.method_10260() + minZ + (double)level.field_9229.method_43057() * depth, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnFireChargeSmokeParticle(class_1937 level, class_2338 particlePos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) {
            return;
        }
        if (!ConfigHandler.fireCharge_onUse) {
            return;
        }
        double lavaIntensity = (double)ConfigHandler.fireCharge_intensity / 24.0;
        double smokeIntensity = (double)ConfigHandler.fireCharge_intensity / 58.0;
        for (int i = 0; i < ConfigHandler.maxFireCharge_onUse; ++i) {
            double x = (double)particlePos.method_10263() + 0.25 + level.field_9229.method_43058() / 2.0;
            double y = (double)particlePos.method_10264() + 0.25 + level.field_9229.method_43058() / 2.0;
            double z = (double)particlePos.method_10260() + 0.25 + level.field_9229.method_43058() / 2.0;
            if ((double)level.field_9229.method_43057() > 0.2) {
                level.method_8406((class_2394)((double)level.field_9229.method_43057() > 0.3 ? class_2398.field_11251 : class_2398.field_11237), x, y, z, (level.field_9229.method_43058() - 0.5) * smokeIntensity, (level.field_9229.method_43058() + 0.5) * smokeIntensity, (level.field_9229.method_43058() - 0.5) * smokeIntensity);
                continue;
            }
            level.method_8406((class_2394)class_2398.field_11239, x, y, z, (level.field_9229.method_43058() - 0.5) * lavaIntensity, (level.field_9229.method_43058() + 0.5) * lavaIntensity, (level.field_9229.method_43058() - 0.5) * lavaIntensity);
        }
    }

    public static void spawnHoeTillParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.hoeTill_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxHoeTill_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnShovelFlattenParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.shovelFlatten_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxShovelFlatten_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnAxeStripParticle(class_1937 level, class_2338 blockPos, class_2680 unstrippedBlockState, class_2680 strippedBlockState, class_1838 context) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.axeStrip_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxAxeStrip_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = (double)level.field_9229.method_43057() > 0.9 ? new class_2388(class_2398.field_11217, strippedBlockState) : new class_2388(class_2398.field_11217, unstrippedBlockState);
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnFluidPlacedParticle(class_1936 levelAccessor, class_2338 particlePos, class_3611 placedFluid) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, particlePos)) {
            return;
        }
        if (placedFluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidPlacementParticle particleOverride = FluidPlacementParticle.getParticleForFluid(placedFluid);
        if (particleOverride == FluidPlacementParticle.NONE) {
            return;
        }
        Object particleOption = particleOverride.isBlockStateParticle() ? particleOverride.getBlockParticleOption(placedFluid.method_15785().method_15759()) : particleOverride.getParticleOption();
        if (particleOption == null) {
            return;
        }
        int maxParticles = FluidPlacementParticle.getParticleMultiplier(particleOverride, true);
        for (int i = 0; i < maxParticles; ++i) {
            double x = (double)particlePos.method_10263() + levelAccessor.method_8409().method_43058();
            double y = (double)particlePos.method_10264() + levelAccessor.method_8409().method_43058() / 1.5 + 0.6;
            double z = (double)particlePos.method_10260() + levelAccessor.method_8409().method_43058();
            levelAccessor.method_8406(particleOption, x, y, z, 0.0, 0.21, 0.0);
        }
    }

    public static void spawnAnvilUseSparkParticles(class_638 level, class_2338 blockPos) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.anvilUseSparks_enabled) {
            return;
        }
        double x = (float)blockPos.method_10263() + 0.5f;
        double y = (double)blockPos.method_10264() + 1.0 + level.field_9229.method_43058() / 16.0;
        double z = (float)blockPos.method_10260() + 0.5f;
        RandomDistributionEmitterOptions emitter = new RandomDistributionEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, 3, 7, 1, new Vector3f(0.25f, 0.0f, 0.25f));
        SpawnParticlesUtil.spawnParticleInCircle(emitter, level, new class_243(x, y, z), ConfigHandler.maxAnvilUseSparks_onUse, 0.32f, 0.16f, 2.0f, 0.2f, 2.0f);
    }

    public static void spawnGrindstoneUseSparkParticles(class_638 level, class_2338 blockPos) {
        double z;
        double y;
        double x;
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        if (!ConfigHandler.grindstoneUseSparks_enabled) {
            return;
        }
        class_2680 grindstoneState = level.method_8320(blockPos);
        if (!(grindstoneState.method_26204() instanceof class_3713)) {
            return;
        }
        class_2350 facing = (class_2350)grindstoneState.method_11654((class_2769)class_3713.field_11177);
        class_2738 attachFace = (class_2738)grindstoneState.method_11654((class_2769)class_3713.field_11007);
        if (attachFace == class_2738.field_12471) {
            x = (double)((float)blockPos.method_10263() + 0.5f) + (double)facing.method_10148() / 1.9;
            y = (float)blockPos.method_10264() + 0.5f;
            z = (double)((float)blockPos.method_10260() + 0.5f) + (double)facing.method_10165() / 1.9;
        } else {
            x = (float)blockPos.method_10263() + 0.5f;
            y = (float)blockPos.method_10264() + (attachFace == class_2738.field_12473 ? 0.0f : 1.05f);
            z = (float)blockPos.method_10260() + 0.5f;
        }
        RandomDistributionEmitterOptions emitter = SpawnParticles.getGrindstoneSparkEmitter(attachFace, facing);
        float HORIZONTAL_MIN_SPEED = 0.05f;
        float HORIZONTAL_MAX_SPEED = 0.3f;
        float UPWARDS_SPEED = 0.5f;
        float DOWNWARDS_SPEED = 0.1f;
        level.method_8406((class_2394)emitter, x, y, z, (double)((float)facing.method_10148() * (attachFace == class_2738.field_12471 ? 0.05f : 0.3f)), attachFace == class_2738.field_12471 ? 0.5 : 0.0, (double)((float)facing.method_10165() * (attachFace == class_2738.field_12471 ? 0.05f : 0.3f)));
        level.method_8406((class_2394)emitter, x, y, z, (double)((float)facing.method_10148() * (attachFace == class_2738.field_12471 ? -0.05f : -0.3f)), attachFace == class_2738.field_12471 ? (double)-0.1f : 0.0, (double)((float)facing.method_10165() * (attachFace == class_2738.field_12471 ? -0.05f : -0.3f)));
    }

    @NotNull
    private static RandomDistributionEmitterOptions getGrindstoneSparkEmitter(class_2738 attachFace, class_2350 facing) {
        float depth;
        float EMITTER_BOUND_WIDTH = 0.1f;
        float EMITTER_BOUND_LENGTH = 0.8f;
        float width = attachFace == class_2738.field_12471 ? 0.0f : 0.1f;
        float height = attachFace == class_2738.field_12471 ? 0.8f : 0.0f;
        float f = depth = attachFace == class_2738.field_12471 ? 0.0f : 0.1f;
        if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
            width = 0.1f;
            depth = attachFace == class_2738.field_12471 ? depth : 0.8f;
        } else if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
            width = attachFace == class_2738.field_12471 ? width : 0.8f;
            depth = 0.1f;
        }
        return new RandomDistributionEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, ConfigHandler.maxGrindstoneUseSparks_onUse < 6 ? ConfigHandler.maxGrindstoneUseSparks_onUse : 6, 1, (int)Math.ceil((double)ConfigHandler.maxGrindstoneUseSparks_onUse / 6.0), new Vector3f(width, height, depth));
    }

    public static void spawnBrushingParticles(class_638 level, BlockParticleOverride override, class_2680 blockState, class_2350 brushDirection, class_243 particlePos, int armDirection, int amountOfParticles, double baseDeltaX, double baseDeltaY, double baseDeltaZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215())) {
            return;
        }
        double outwardVelocity = 0.05;
        for (int i = 0; i < amountOfParticles; ++i) {
            float velocityMultiplier;
            TintedParticleOption particleOption;
            if (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_VANILLA || ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_DUST && override != BlockParticleOverride.VANILLA && override != BlockParticleOverride.NONE) {
                particleOption = override.getParticleOptionForState(blockState, level, class_2338.method_49638((class_2374)particlePos), 5);
                velocityMultiplier = override.getParticleVelocityMultiplier();
            } else {
                particleOption = TintedParticleOption.BRUSH_OPTION;
                velocityMultiplier = 0.1f;
            }
            if (particleOption == null) continue;
            level.method_8406((class_2394)particleOption, particlePos.field_1352 + (double)brushDirection.method_10148() * 0.05, particlePos.field_1351 + (double)brushDirection.method_10164() * 0.05, particlePos.field_1350 + (double)brushDirection.method_10165() * 0.05, baseDeltaX * (double)armDirection * level.method_8409().method_43058() * (double)velocityMultiplier + (double)brushDirection.method_10148() * 0.05, (baseDeltaY + 1.0) * level.method_8409().method_43058() * (double)velocityMultiplier * (double)brushDirection.method_10164(), baseDeltaZ * (double)armDirection * level.method_8409().method_43058() * (double)velocityMultiplier + (double)brushDirection.method_10165() * 0.05);
        }
    }

    public static void spawnBlazeAmbientParticles(class_638 level, double x, double y, double z) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (level.field_9229.method_43057() < (float)ConfigHandler.blaze_spawnChance / 100.0f) {
            float xVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            float yVel = MathHelpers.randomBetween(0.3f, 0.6f);
            float zVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            level.method_8406((class_2394)ModParticleTypes.FLOATING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }

    public static void spawnBlazeHurtParticles(class_638 level, double x, double y, double z) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) {
            return;
        }
        if (!ConfigHandler.blaze_spawnOnHurt) {
            return;
        }
        for (int i = 0; i < level.field_9229.method_39332(ConfigHandler.blaze_amountToSpawnOnHurt <= 1 ? 1 : ConfigHandler.blaze_amountToSpawnOnHurt - 1, ConfigHandler.blaze_amountToSpawnOnHurt + 2); ++i) {
            float xVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            float yVel = MathHelpers.randomBetween(0.4f, 0.6f);
            float zVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }

    public static void spawnRedstoneInteractionParticles(class_638 level, class_2680 blockState, double interactionX, double interactionY, double interactionZ, float spreadX, float spreadY, float spreadZ) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, interactionX, interactionY, interactionZ)) {
            return;
        }
        if (!ConfigHandler.redstoneInteractionDust_enabled) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)interactionX, (double)interactionY, (double)interactionZ);
        for (int i = 0; i < ConfigHandler.redstoneInteractionDust_amount; ++i) {
            double particleX = interactionX + (double)MathHelpers.randomBetween(-spreadX / 2.0f, spreadX / 2.0f);
            double particleY = interactionY + (double)MathHelpers.randomBetween(-spreadY / 2.0f, spreadY / 2.0f);
            double particleZ = interactionZ + (double)MathHelpers.randomBetween(-spreadZ / 2.0f, spreadZ / 2.0f);
            class_2394 particleOptions = BlockParticleOverrides.REDSTONE_DUST.getParticleOptionForState(blockState, level, pos, 9);
            if (particleOptions == null) continue;
            level.method_8406(particleOptions, particleX, particleY, particleZ, (double)MathHelpers.randomBetween(-0.05f, 0.05f), (double)0.2f, (double)MathHelpers.randomBetween(-0.05f, 0.05f));
        }
    }

    public static void spawnLavaBubblePopParticles(class_638 level, class_2338 fluidPos, class_3610 fluidState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, fluidPos)) {
            return;
        }
        if (!ConfigHandler.lavaBubblePop_enabled) {
            return;
        }
        if (level.field_9229.method_43057() < (float)ConfigHandler.lavaBubblePop_spawnChance / 2500.0f) {
            double d0 = (double)fluidPos.method_10263() + level.field_9229.method_43058();
            double d1 = (double)fluidPos.method_10264() + 0.9;
            double d2 = (double)fluidPos.method_10260() + level.field_9229.method_43058();
            level.method_8406((class_2394)ModParticleTypes.LAVA_POP, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnRandomUnderwaterBubbleStreams(class_638 level, class_2338 blockPos, class_2680 blockState) {
        if (!ConfigHandler.underwaterBubbleStreams_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!FluidHelpers.probablyPlacedUnderwater((class_1937)level, blockPos)) {
            return;
        }
        class_2960 blockLocation = RegistryHelpers.getLocationFromBlock(blockState.method_26204());
        if (!TagUtil.doesListContainBlock(ConfigHandler.underwaterBubbleStreams_blocks, blockLocation)) {
            return;
        }
        if (level.field_9229.method_43057() < (float)ConfigHandler.underwaterBubbleStreams_spawnChance / 2500.0f) {
            double x = (double)blockPos.method_10263() + level.field_9229.method_43058();
            double y = (double)blockPos.method_10264() + (blockState.method_51367() ? 1.05 : level.field_9229.method_43058());
            double z = (double)blockPos.method_10260() + level.field_9229.method_43058();
            RandomDistributionEmitterOptions emitter = new RandomDistributionEmitterOptions(ModParticleTypes.UNDERWATER_RISING_BUBBLE_SMALL_EMITTER, MathHelpers.randomBetween(9, 30), MathHelpers.randomBetween(2, 4), 1);
            level.method_8406((class_2394)emitter, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnBlockDisturbanceParticles(class_638 level, class_2338 blockPos, class_2680 blockState, double entityX, double entityY, double entityZ, class_243 deltaMovement, boolean isSprinting) {
        if (!ConfigHandler.blockRustle_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) {
            return;
        }
        double speed = deltaMovement.method_1033();
        if (speed <= 0.1 && !isSprinting) {
            return;
        }
        class_2960 blockLocation = RegistryHelpers.getLocationFromBlock(blockState.method_26204());
        if (!TagUtil.doesListContainBlock(ConfigHandler.blockRustle_Blocks, blockLocation)) {
            return;
        }
        int overrideOrigin = 10;
        int particlesAmount = speed > 0.25 || isSprinting ? 3 : 1;
        for (int i = 0; i < particlesAmount; ++i) {
            class_2394 particleToSpawn;
            BlockParticleOverride particleOverride;
            double particleX = entityX + ((double)level.field_9229.method_43057() * 0.5 - 0.25);
            double particleY = entityY + 0.35 + ((double)level.field_9229.method_43057() * 0.5 - 0.25);
            double particleZ = entityZ + ((double)level.field_9229.method_43057() * 0.5 - 0.25);
            class_2338 entityBlockPos = class_2338.method_49637((double)particleX, (double)blockPos.method_10264(), (double)particleZ);
            if (level.method_8320(entityBlockPos).method_26215() || (particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin)) == BlockParticleOverride.NONE || (particleToSpawn = particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin)) == null) continue;
            level.method_8406(particleToSpawn, particleX, particleY, particleZ, deltaMovement.field_1352 * 3.0 * (double)particleOverride.getParticleVelocityMultiplier(), Math.min(deltaMovement.field_1351, 0.1) * 3.0 * (double)particleOverride.getParticleVelocityMultiplier() + 0.1, deltaMovement.field_1350 * 3.0 * (double)particleOverride.getParticleVelocityMultiplier());
        }
    }

    public static void spawnItemFrameInteractionParticles(class_638 level, double x, double y, double z, class_238 boundingBox, class_2350 itemFrameDirection, ItemFrameParticleOrigin particleOrigin, boolean glowingItemFrame) {
        if (!ConfigHandler.itemFrame_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) {
            return;
        }
        double particleSpeed = 0.2;
        if (particleOrigin == ItemFrameParticleOrigin.FRAME_KILLED) {
            return;
        }
        TintedParticleOption particleOptionToSpawn = glowingItemFrame ? TintedParticleOption.GLOW_ITEM_FRAME_DUST_OPTION : TintedParticleOption.ITEM_FRAME_DUST_OPTION;
        for (int i = 0; i < ConfigHandler.itemFrame_amount; ++i) {
            double randomX = boundingBox.field_1323 + boundingBox.method_17939() * level.field_9229.method_43058();
            double randomY = boundingBox.field_1322 + boundingBox.method_17940() * level.field_9229.method_43058();
            double randomZ = boundingBox.field_1321 + boundingBox.method_17941() * level.field_9229.method_43058();
            level.method_8406((class_2394)particleOptionToSpawn, (double)itemFrameDirection.method_10148() * 0.15 + x, (double)itemFrameDirection.method_10164() * 0.15 + y, (double)itemFrameDirection.method_10165() * 0.15 + z, (double)itemFrameDirection.method_10148() * 0.03 + (randomX - x) * 2.0 * particleSpeed, (double)itemFrameDirection.method_10164() * 0.03 + (randomY - y) * 2.0 * particleSpeed, (double)itemFrameDirection.method_10165() * 0.03 + (randomZ - z) * 2.0 * particleSpeed);
        }
    }

    public static void spawnSmokerSmokeParticles(class_638 level, class_2338 blockPos) {
        if (!ConfigHandler.smokerSmoke_enabled) {
            return;
        }
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if ((double)level.field_9229.method_43057() > 0.3) {
            class_243 centerPos = blockPos.method_46558();
            level.method_8406((class_2394)class_2398.field_17430, centerPos.field_1352, (double)blockPos.method_10264() + 0.8, centerPos.field_1350, 0.0, (double)0.07f, 0.0);
        }
    }

    public static void spawnAdditionalFurnaceParticles(class_638 level, class_2338 blockPos, class_2680 furnaceState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!ConfigHandler.furnaceEmbers_enabled) {
            return;
        }
        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if (level.method_8320(class_2338.method_49637((double)positions[0], (double)positions[1], (double)positions[2])).method_26228((class_1922)level, blockPos)) {
            return;
        }
        class_2350 furnaceDirection = (class_2350)furnaceState.method_11654((class_2769)class_3865.field_11104);
        boolean spawnSpark = (double)level.field_9229.method_43057() < 0.7;
        float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (float)(spawnSpark ? 1 : 5);
        level.method_8406((class_2394)(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK), positions[0], positions[1], positions[2], (double)((float)furnaceDirection.method_10148() * outwardVelocity), (double)0.05f, (double)((float)furnaceDirection.method_10165() * outwardVelocity));
    }

    public static void spawnAdditionalBlastFurnaceParticles(class_638 level, class_2338 blockPos, class_2680 furnaceState) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) {
            return;
        }
        if (!ConfigHandler.blastFurnaceSparks_enabled) {
            return;
        }
        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if (level.method_8320(class_2338.method_49637((double)positions[0], (double)positions[1], (double)positions[2])).method_26228((class_1922)level, blockPos)) {
            return;
        }
        class_2350 furnaceDirection = (class_2350)furnaceState.method_11654((class_2769)class_3865.field_11104);
        boolean spawnSpark = (double)level.field_9229.method_43057() < 0.2;
        float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (float)(spawnSpark ? 1 : 5);
        level.method_8406((class_2394)(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK), positions[0], positions[1] + 0.125, positions[2], (double)((float)furnaceDirection.method_10148() * outwardVelocity), (double)0.05f, (double)((float)furnaceDirection.method_10165() * outwardVelocity));
    }

    public static void spawnLightningImpactSparks(class_638 level, double x, double y, double z) {
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) {
            return;
        }
        if (!ConfigHandler.lightningStrike_enabled) {
            return;
        }
        SpawnParticlesUtil.spawnParticleInCircle(() -> new ArcEmitterOptions(ModParticleTypes.ARC_EMITTER, MathHelpers.randomBetween(7, 14), MathHelpers.randomBetween(3, 5), 40, MathHelpers.randomBetween(4, 6), 1, MathHelpers.randomBetween(160, 380), null), level, new class_243(x, y + 0.5, z), ConfigHandler.lightningStrike_amountOfArcs, 0.2f, 0.8f, 3.0f, 0.3f, 1.0f);
        SpawnParticlesUtil.spawnParticleInCircle((class_2394)ModParticleTypes.FLYING_SPARK, level, new class_243(x, y + 0.01, z), MathHelpers.randomBetween(Math.max(0, ConfigHandler.lightningStrike_amountOfSparks - 4), ConfigHandler.lightningStrike_amountOfSparks), 0.3f, 0.8f, 0.25f, 0.25f, 1.1f);
    }

    public static void spawnHoneyCollectionParticles(class_638 level, double x, double y, double z, class_2350 faceDirection) {
        for (int i = 0; i < level.field_9229.method_39332(Math.max(ConfigHandler.maxHoneyCollection_onUse - 2, 0), Math.max(ConfigHandler.maxHoneyCollection_onUse, 1)); ++i) {
            double xOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 + Math.abs(faceDirection.method_10148()));
            double yOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 + Math.abs(faceDirection.method_10164()));
            double zOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 + Math.abs(faceDirection.method_10165()));
            level.method_8406((class_2394)DripParticleOption.FALLING_HONEY_DROP, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnHoneyCollectionParticlesOnPlayer(class_638 level, class_1657 player) {
        for (int i = 0; i < level.field_9229.method_39332(Math.max(ConfigHandler.maxHoneyCollection_onUse / 2, 0), Math.max(ConfigHandler.maxHoneyCollection_onUse / 2, 1)); ++i) {
            level.method_8406((class_2394)DripParticleOption.FALLING_HONEY_DROP, player.method_23317() - 0.25 + level.field_9229.method_43058() / 2.0, player.method_23318() + 0.85 + level.field_9229.method_43058() / 5.0, player.method_23321() - 0.25 + level.field_9229.method_43058() / 2.0, 0.0, 0.0, 0.0);
        }
    }

    public static enum ItemFrameParticleOrigin {
        FRAME_KILLED,
        HELD_ITEM_REMOVED,
        ITEM_ROTATED,
        ITEM_PLACED;

    }
}

