package games.enchanted.eg_particle_interactions.common.particle.dust;

import games.enchanted.eg_particle_interactions.common.particle.option.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2394;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class BasicTintedDust extends BasicDust {
    protected BasicTintedDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_4002 spriteSet, float gravityMultiplier, TintedParticleOption tintedParticleOption, boolean spawnSpecks, boolean spriteFromAge, Supplier<class_2394> speckGetter) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks, spriteFromAge, speckGetter);

        int[] rgb = tintedParticleOption.getRandomisedColour();
        this.field_3861 = rgb[0] / 255f;
        this.field_3842 = rgb[1] / 255f;
        this.field_3859 = rgb[2] / 255f;
    }

    public static class RedstoneProvider implements class_707<TintedParticleOption> {
        private final class_4002 spriteSet;

        public RedstoneProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            BasicTintedDust particle = new BasicTintedDust(level, x, y, z, xSpeed, MathHelpers.randomBetween(0.06f, 0.13f), zSpeed, this.spriteSet, -0.0f, type, false, true, () -> null);
            particle.field_3839 = 0;
            particle.field_3857 = 0;
            particle.field_3847 = (int)(particle.field_3847 * 0.6f);
            return particle;
        }
    }

    public static class BrushProvider implements class_707<TintedParticleOption> {
        private final class_4002 spriteSet;

        public BrushProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.7f, type, true, true, () -> TintedParticleOption.BRUSH_SPECK_OPTION);
        }
    }
    public static class BrushSpeckProvider implements class_707<TintedParticleOption>  {
        private final class_4002 spriteSet;

        public BrushSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.35f, type, false, false, () -> null);
        }
    }

    public static class ItemFrameProvider implements class_707<TintedParticleOption> {
        private final class_4002 spriteSet;

        public ItemFrameProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.7f, type, true, true, () -> TintedParticleOption.ITEM_FRAME_DUST_SPECK_OPTION);
        }
    }
    public static class ItemFrameSpeckProvider implements class_707<TintedParticleOption>  {
        private final class_4002 spriteSet;

        public ItemFrameSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.35f, type, false, false, () -> null);
        }
    }

    public static class GlowItemFrameProvider implements class_707<TintedParticleOption> {
        private final class_4002 spriteSet;

        public GlowItemFrameProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            BasicTintedDust particle = new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.7f, type, true, true, () -> TintedParticleOption.GLOW_ITEM_FRAME_DUST_SPECK_OPTION);
            particle.emissive = true;
            return particle;
        }
    }
    public static class GlowItemFrameSpeckProvider implements class_707<TintedParticleOption>  {
        private final class_4002 spriteSet;

        public GlowItemFrameSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            TintedParticleOption type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            BasicTintedDust particle = new BasicTintedDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.35f, type, false, false, () -> null);
            particle.emissive = true;
            return particle;
        }
    }
}
