package games.enchanted.eg_particle_interactions.common.particle.falling_spin;

import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

public class FallingSpinningColouredParticle extends FallingSpinningParticle {
    protected FallingSpinningColouredParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_2338 blockPos, class_2680 blockState, class_4002 spriteSet, float gravityMultiplier) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier);
        int tintColour = class_310.method_1551().method_1505().method_1697(blockState, level, blockPos, 0);
        int[] tintColourARGB = ColourUtil.RGBint_to_ARGB(tintColour);
        int[] averageTextureColourARGB = ColourUtil.getRandomBlockColour(blockState, tintColourARGB);
        this.field_3861 = (float)averageTextureColourARGB[1] / 255f;
        this.field_3842 = (float)averageTextureColourARGB[2] / 255f;
        this.field_3859 = (float)averageTextureColourARGB[3] / 255f;
        this.field_3841 = (float)averageTextureColourARGB[0] / 255f;
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        if(this.field_3841 < 0.99) return ParticleLayer.TRANSLUCENT;
        return super.getParticleLayer();
    }

    public static class TintedLeafProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public TintedLeafProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 1f);
            float particleSize = level.field_9229.method_43056() ? 0.1f : 0.15f;
            particle.setScale(particleSize);
            particle.maxSpinSpeed = 0.5f;
            particle.method_3080(particleSize, particleSize);
            return particle;
        }
    }

    public static class FlowerPetalProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public FlowerPetalProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 1f);
            particle.maxSpinSpeed = 0.5f;
            return particle;
        }
    }

    public static class GrassBladeProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public GrassBladeProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 1f);
            float particleSize = level.field_9229.method_43056() ? 0.10F : 0.12F;
            particle.setScale(particleSize);
            particle.method_3080(particleSize, particleSize);
            return particle;
        }
    }

    public static class HeavyGrassBladeProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public HeavyGrassBladeProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 2f);
            float particleSize = level.field_9229.method_43056() ? 0.10F : 0.12F;
            particle.setScale(particleSize);
            particle.method_3080(particleSize, particleSize);
            return particle;
        }
    }

    public static class ChainSnapProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public ChainSnapProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 3f);
            float particleSize = level.field_9229.method_43056() ? 0.14F : 0.15F;
            particle.setScale(particleSize);
            particle.method_3080(particleSize, particleSize);
            particle.maxSpinSpeed = 0.2f;
            particle.spinAcceleration = (float)Math.toRadians(level.field_9229.method_43056() ? -1.0 : 1.0);
            return particle;
        }
    }

    public static class SugarCaneProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public SugarCaneProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            FallingSpinningColouredParticle particle = new FallingSpinningColouredParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet, 2.5f);
            float particleSize = level.field_9229.method_43056() ? 0.11F : 0.13F;
            particle.setScale(particleSize);
            particle.method_3080(particleSize, particleSize);
            return particle;
        }
    }
}