package games.enchanted.eg_particle_interactions.common.particle.splash;

import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import net.minecraft.class_1058;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.Nullable;

public class BucketSplash extends CustomGeometryParticle {
    protected BucketSplash(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);

        this.field_3844 = 0.95F;
        this.field_28786 = 0.999F;
        this.field_3852 = xSpeed + (Math.random() * 2.0 - 1.0) * 0.05000000074505806;
        this.field_3869 = ySpeed + (Math.random() - 0.5) * ((this.field_3840.method_43057() * 0.5f) - 0.3F);
        this.field_3850 = zSpeed + (Math.random() * 2.0 - 1.0) * 0.05000000074505806;
        this.field_3847 = (int)(16.0 / (Math.random() * 0.8 + 0.2));

        float particleSize = (float) 0.1355 - (this.field_3840.method_43056() ? 0.01f : 0.0f);
        this.setScale(particleSize);
        this.method_3080(particleSize, particleSize);
    }

    @Override
    public void method_3070() {
        super.method_3070();
        if (!this.field_3843 && this.field_3845 && this.field_3840.method_43057() > 0.9f) {
            randomOnParticleLand();
        }
    }

    public void randomOnParticleLand() {
        this.method_3085();
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        return ParticleLayer.TRANSLUCENT;
    }

    public static class Provider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public Provider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new BucketSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.method_18139(level.field_9229));
        }
    }
}