package games.enchanted.eg_particle_interactions.common.particle.splash;

import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColouredBucketSplash extends BucketSplash {
    protected ColouredBucketSplash(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_2338 blockPos, class_2680 blockState, class_4002 spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet.method_18139(level.field_9229));
        int tintColour = class_310.method_1551().method_1505().method_1697(blockState, level, blockPos, 0);
        this.field_3861 *= (float)(tintColour >> 16 & 255) / 255.0F;
        this.field_3842 *= (float)(tintColour >> 8 & 255) / 255.0F;
        this.field_3859 *= (float)(tintColour & 255) / 255.0F;
    }

    public static class Provider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public Provider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            /*, RandomSource random
            *///?}
        ) {
            return new ColouredBucketSplash(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), spriteSet);
        }
    }
}
