package games.enchanted.eg_particle_interactions.common.resource;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_particle_interactions.common.Constants;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_4075;
import net.minecraft.class_7677;

public class ParticlePaletteAtlasManager
    //? if minecraft: <= 1.21.8 {
    extends class_4075
    //?}
{
    private static final String ID = "particle_palettes";
    public static final class_2960 ATLAS_LOCATION = class_2960.method_60655(Constants.MOD_ID, "textures/atlas/" + ID);
    public static final class_2960 ATLAS_ID = class_2960.method_60655(Constants.MOD_ID, ID);
    public static final Set<class_7677<?>> METADATA_SECTIONS = Set.of(ParticlePaletteSettingsMetadataSection.TYPE);

    public ParticlePaletteAtlasManager(class_1060 textureManager) {
        //? if minecraft: <= 1.21.8 {
        super(
            textureManager,
            ATLAS_LOCATION,
            ATLAS_ID,
            METADATA_SECTIONS
        );
        //?}
    }

    public class_1058 get(class_2960 location) {
        //? if minecraft: <= 1.21.8 {
        return this.method_18667(location);
        //?} else {
        /*return Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(ATLAS_ID).getSprite(location);
        *///?}
    }

    public static ParticlePaletteSettingsMetadataSection getMetadataFromSprite(class_1058 sprite) {
        //? if minecraft: <= 1.21.8 {
        return sprite.method_45851().method_52848().method_43041(ParticlePaletteSettingsMetadataSection.TYPE).orElse(ParticlePaletteSettingsMetadataSection.DEFAULT);
        //?} else {
        /*return sprite.contents().getAdditionalMetadata(ParticlePaletteSettingsMetadataSection.TYPE).orElse(ParticlePaletteSettingsMetadataSection.DEFAULT);
        *///?}
    }

    public record ParticlePaletteSettingsMetadataSection(boolean useBiomeTint) {
        private static final boolean BIOME_TINT_DEFAULT = true;

        public static final ParticlePaletteSettingsMetadataSection DEFAULT = new ParticlePaletteSettingsMetadataSection(BIOME_TINT_DEFAULT);

        public static final Codec<ParticlePaletteSettingsMetadataSection> CODEC = RecordCodecBuilder.create(
            instance -> instance
                .group(
                    Codec.BOOL.optionalFieldOf("use_biome_tint", BIOME_TINT_DEFAULT).forGetter(ParticlePaletteSettingsMetadataSection::useBiomeTint)
                )
                .apply(
                    instance, ParticlePaletteSettingsMetadataSection::new
                )
        );

        public static final class_7677<ParticlePaletteSettingsMetadataSection> TYPE = new class_7677<>(Constants.MOD_ID + ":particle_palette_settings", CODEC);
    }
}
