package games.enchanted.eg_particle_interactions.common.util.render;

import net.minecraft.class_4588;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderingUtil {
    public static void addVertexToConsumer(class_4588 consumer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
        Vector3f vertexPos = (new Vector3f(xOffset, yOffset, 0.0F)).rotate(quaternion).mul(scale).add(x, y, z);
        addVertexToConsumer(consumer, vertexPos.x(), vertexPos.y(), vertexPos.z(), 0, 0, 0, u, v, packedLight, rCol, gCol, bCol, alpha);
    }

    public static void addVertexToConsumer(class_4588 consumer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight) {
        addVertexToConsumer(consumer, quaternion, x, y, z, xOffset, yOffset, scale, u, v, packedLight, 1, 1, 1, 1);
    }

    public static void addVertexToConsumer(class_4588 consumer, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
        Vector3f vertexPos = (new Vector3f(xOffset, yOffset, 0.0F)).mul(scale).add(x, y, z);
        consumer.method_22912(vertexPos.x(), vertexPos.y(), vertexPos.z()).method_22913(u, v).method_22915(rCol, gCol, bCol, alpha).method_60803(packedLight);
    }

    public static void addVertex(
        //? if minecraft: <= 1.21.8 {
        class_4588 consumer,
         //?} else {
        /*StateAndLayer stateAndLayer,
        *///?}
        Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight) {
        //? if minecraft: <= 1.21.8 {
        RenderingUtil.addVertexToConsumer(
            consumer,
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight
        );
        //?} else {
        /*stateAndLayer.state().addVertex(stateAndLayer.layer(),
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight
        );
        *///?}
    }

    public static void addVertex(
        //? if minecraft: <= 1.21.8 {
        class_4588 consumer,
         //?} else {
        /*StateAndLayer stateAndLayer,
        *///?}
        Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
        //? if minecraft: <= 1.21.8 {
        RenderingUtil.addVertexToConsumer(
            consumer,
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight,
            rCol,
            gCol,
            bCol,
            alpha
        );
        //?} else {
        /*stateAndLayer.state().addVertex(
            stateAndLayer.layer(),
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight,
            rCol,
            gCol,
            bCol,
            alpha
        );
        *///?}
    }
}
