/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle;

import games.enchanted.eg_particle_interactions.common.particle.BouncyParticle;
import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.shapes.QuadFaceShape;
import games.enchanted.eg_particle_interactions.common.shapes.ShapeDefinitions;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_1058;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class StretchyBouncyShapeParticle
extends BouncyParticle {
    protected double prevPrevX;
    protected double prevPrevY;
    protected double prevPrevZ;
    private QuadFaceShape particleShape;
    protected Vector3f particleShapeScale;
    protected float prevPitch;
    protected float prevYaw;

    protected StretchyBouncyShapeParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        this.field_28787 = true;
        this.particleShapeScale = new Vector3f(1.0f);
        this.setShape(ShapeDefinitions.CUBE);
    }

    @Override
    public void method_3070() {
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        super.method_3070();
    }

    protected void setShape(QuadFaceShape newShape) {
        this.particleShape = newShape;
    }

    protected boolean isParticleMoving() {
        return (double)this.getTotalVelocity() < 0.001;
    }

    @Override
    @NotNull
    public CustomGeometryParticle.BillboardMode getBillboardMode() {
        return CustomGeometryParticle.BillboardMode.FIXED;
    }

    @Override
    protected void adjustPositionBeforeExtraction(QuadConsumer consumer, class_4184 camera, Quaternionf quaternionf, float partialTicks) {
        Vector3f cameraPosition = camera.method_19326().method_46409();
        float xPos = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874);
        float yPos = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854);
        float zPos = (float)class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871);
        Vector3f pos = new Vector3f(xPos, yPos, zPos).sub((Vector3fc)cameraPosition);
        float prevXPos = (float)class_3532.method_16436((double)partialTicks, (double)this.prevPrevX, (double)this.field_3858);
        float prevYPos = (float)class_3532.method_16436((double)partialTicks, (double)this.prevPrevY, (double)this.field_3838);
        float prevZPos = (float)class_3532.method_16436((double)partialTicks, (double)this.prevPrevZ, (double)this.field_3856);
        Vector3f prevPos = new Vector3f(prevXPos, prevYPos, prevZPos).sub((Vector3fc)cameraPosition);
        this.extractShapeGeometry(consumer, pos, prevPos, partialTicks);
    }

    private void extractShapeGeometry(QuadConsumer consumer, Vector3f pos, Vector3f prevPos, float partialTicks) {
        float cuboidSize = this.getScale();
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int lightColor = this.method_3068(partialTicks);
        Vector3f normalisedMovementDir = new Vector3f((Vector3fc)pos).sub((Vector3fc)prevPos).normalize();
        float pitch = (float)Math.toDegrees(Math.asin(normalisedMovementDir.y));
        if (!Float.isFinite(pitch)) {
            pitch = this.prevPitch;
        }
        this.prevPitch = pitch;
        float yaw = (float)Math.toDegrees(Math.atan2(normalisedMovementDir.x, normalisedMovementDir.z));
        if (!Float.isFinite(yaw)) {
            yaw = this.prevYaw;
        }
        this.prevYaw = yaw;
        Vector3f shapePos = MathHelpers.getPosBetween3DPoints(pos, prevPos);
        Vector3f shapeScale = new Vector3f(1.0f, Math.max(Math.abs(MathHelpers.getDistanceBetweenVectors(pos, prevPos) * 40.0f), 1.0f), 1.0f).mul((Vector3fc)this.particleShapeScale);
        Vector3f shapeRotation = new Vector3f(-(pitch - 90.0f), yaw, 0.0f);
        this.particleShape.extractShape(consumer, new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u1, v1)}, shapePos, shapeScale, shapeRotation, cuboidSize, lightColor, ColourUtil.ARGBfloats_to_ARGB(this.alpha, this.rCol, this.gCol, this.bCol));
    }

    @Override
    @NotNull
    public class_238 getCullingBox(float partialTicks) {
        double diffX = this.field_3874 - this.field_3858;
        double diffY = this.field_3854 - this.field_3838;
        double diffZ = this.field_3871 - this.field_3856;
        return this.method_3064().method_989(-diffX / 2.0, -diffY / 2.0, -diffZ / 2.0).method_1014(Math.abs(new class_243(this.field_3874, this.field_3854, this.field_3871).method_1022(new class_243(this.field_3858, this.field_3838, this.field_3856)) / 2.0));
    }
}

