/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.drip;

import games.enchanted.eg_particle_interactions.common.duck.ParticleAccess;
import games.enchanted.eg_particle_interactions.common.particle.compat.CustomGeometryParticle;
import games.enchanted.eg_particle_interactions.common.particle.option.DripParticleOption;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class DripAndLandParticle
extends CustomGeometryParticle {
    protected boolean hasLanded = false;
    protected final int startFallingAtTicks;
    protected final boolean translucent;
    protected float uo;
    protected float u1;
    protected float v0;
    protected float v1;

    DripAndLandParticle(class_638 level, double x, double y, double z, class_4002 sprites, DripParticleOption dripParticleOption, boolean translucent) {
        super(level, x, y, z, sprites.method_18139(level.field_9229));
        this.translucent = translucent;
        this.method_3080(0.01f, 0.01f);
        this.setScale(0.15f);
        this.field_3844 = dripParticleOption.getGravity() + level.field_9229.method_43057() * dripParticleOption.getGravityRandomness();
        this.startFallingAtTicks = dripParticleOption.getStartFallingTicks();
        this.uo = this.getU0();
        this.u1 = this.getU1();
        this.v0 = this.getV0();
        float v1 = this.getV1();
        float halfHeight = Math.abs(this.v0 - v1) / 2.0f;
        this.v1 = v1 - halfHeight;
        this.field_3847 = level.field_9229.method_39332(350, 500);
    }

    public void method_3070() {
        if (this.field_3843) {
            return;
        }
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }
        if (this.startFallingAtTicks - this.field_3866 > 30) {
            return;
        }
        if (this.field_3866 < this.startFallingAtTicks) {
            this.field_3869 -= 0.004 / (double)this.startFallingAtTicks;
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            return;
        }
        this.field_3869 -= (double)this.field_3844;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        if (this.field_3845) {
            this.land();
        }
        this.field_3852 *= (double)0.98f;
        this.field_3869 *= (double)0.98f;
        this.field_3850 *= (double)0.98f;
    }

    protected void land() {
        if (this.hasLanded) {
            return;
        }
        this.hasLanded = true;
        float v0 = this.getV0();
        this.v1 = this.getV1();
        float halfHeight = Math.abs(v0 - this.v1) / 2.0f;
        this.v0 = v0 + halfHeight;
        this.field_3847 = this.field_3866 + this.field_3851.field_9229.method_43051(30, 60);
        ((ParticleAccess)((Object)this)).eg_particle_interactions$moveUpBecauseParticleLanded();
    }

    @Override
    protected CustomGeometryParticle.ParticleLayer getParticleLayer() {
        return this.translucent ? CustomGeometryParticle.ParticleLayer.TRANSLUCENT : CustomGeometryParticle.ParticleLayer.OPAQUE;
    }

    @Override
    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float scale = this.getScale();
        int packedLight = this.method_3068(partialTicks);
        float yOffset = this.hasLanded ? 1.0f : 0.0f;
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, 1.0f, -1.0f + yOffset, scale, this.u1, this.v1, packedLight);
        consumer.addVertex(quaternion, x, y, z, 1.0f, 1.0f + yOffset, scale, this.u1, this.v0, packedLight);
        consumer.addVertex(quaternion, x, y, z, -1.0f, 1.0f + yOffset, scale, this.uo, this.v0, packedLight);
        consumer.addVertex(quaternion, x, y, z, -1.0f, -1.0f + yOffset, scale, this.uo, this.v1, packedLight);
        consumer.finishQuad();
    }

    public static class UntintedDropProvider
    implements class_707<DripParticleOption> {
        class_4002 sprites;

        public UntintedDropProvider(class_4002 sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public class_703 createParticle(DripParticleOption options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DripAndLandParticle(level, x, y, z, this.sprites, options, true);
        }
    }
}

