/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.emitter.arc;

import games.enchanted.eg_particle_interactions.common.particle.emitter.AbstractEmitterParticle;
import games.enchanted.eg_particle_interactions.common.particle.option.ArcEmitterOptions;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2394;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;

public abstract class AbstractArcEmitter
extends AbstractEmitterParticle {
    protected static final float DIRECTION_VECTOR_SCALE = 0.0625f;
    List<Split> splits = new ArrayList<Split>();
    protected final int length;
    protected final int splitAmount;
    protected final int angleVariance;
    protected final int tickInterval;
    protected final int repeat;
    protected final float initialAngleXRad;
    protected final float initialAngleYRad;

    public AbstractArcEmitter(class_638 level, double x, double y, double z, float width, float height, float depth, ArcEmitterOptions options) {
        super(level, x, y, z, width, height, depth);
        this.length = options.getLength();
        this.splitAmount = options.getSplits();
        this.angleVariance = options.getAngleVariance();
        this.tickInterval = options.getTickInterval();
        this.repeat = options.getRepeat();
        this.method_3077(this.repeat * this.tickInterval);
        this.initialAngleXRad = options.getInitialAngleXDeg().isPresent() ? (float)options.getInitialAngleXDeg().get().intValue() * ((float)Math.PI / 180) : this.field_3851.field_9229.method_43057() * 360.0f * ((float)Math.PI / 180);
        this.initialAngleYRad = options.getInitialAngleYDeg().isPresent() ? (float)options.getInitialAngleYDeg().get().intValue() * ((float)Math.PI / 180) : this.field_3851.field_9229.method_43057() * 360.0f * ((float)Math.PI / 180);
        this.calculateSplits();
    }

    private float applyRandomDirectionRotation(float startingAngleRad) {
        float randomOffset = (this.field_3851.field_9229.method_43057() - 0.5f) * (float)this.angleVariance * 2.0f;
        return startingAngleRad + (randomOffset *= (float)Math.PI / 180);
    }

    private void calculateSplits() {
        this.splits.clear();
        for (int i = 0; i < this.splitAmount; ++i) {
            Vector3f directionVector = MathHelpers.directionVectorFromPitchYaw(this.applyRandomDirectionRotation(this.initialAngleXRad), this.applyRandomDirectionRotation(this.initialAngleYRad)).mul(0.0625f);
            @Nullable Split prevSplit = this.splits.isEmpty() ? null : this.splits.getLast();
            this.splits.add(new Split(prevSplit == null ? this.field_3874 : prevSplit.getEndPos().x, prevSplit == null ? this.field_3854 : prevSplit.getEndPos().y, prevSplit == null ? this.field_3871 : prevSplit.getEndPos().z, directionVector, this.length));
        }
    }

    @Override
    protected void emitterTick() {
        for (Split split : this.splits) {
            split.tick(this.field_3851, (x$0, x$1, x$2, x$3) -> this.getParticleToEmit(x$0, x$1, x$2, x$3));
        }
        if (this.field_3866 % this.tickInterval == 0) {
            this.calculateSplits();
        }
    }

    private record Split(double x, double y, double z, Vector3f directionVector, int length) {
        void tick(class_638 level, ParticleSupplier particleSupplier) {
            for (int i = 0; i < this.length; ++i) {
                class_2394 particle = particleSupplier.getParticle(level, this.x, this.y, this.z);
                if (particle == null) continue;
                level.method_8406(particle, this.x + (double)(this.directionVector.x * (float)i), this.y + (double)(this.directionVector.y * (float)i), this.z + (double)(this.directionVector.z * (float)i), 0.0, 0.0, 0.0);
            }
        }

        Vector3d getEndPos() {
            return new Vector3d(this.x + (double)(this.directionVector.x * (float)this.length), this.y + (double)(this.directionVector.y * (float)this.length), this.z + (double)(this.directionVector.z * (float)this.length));
        }
    }

    @FunctionalInterface
    private static interface ParticleSupplier {
        public class_2394 getParticle(class_638 var1, double var2, double var4, double var6);
    }
}

