/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.emitter.random_distribution;

import games.enchanted.eg_particle_interactions.common.particle.emitter.AbstractEmitterParticle;
import games.enchanted.eg_particle_interactions.common.particle.option.RandomDistributionEmitterOptions;
import net.minecraft.class_2394;
import net.minecraft.class_638;
import org.joml.Vector3f;

public abstract class AbstractRandomDistributionEmitter
extends AbstractEmitterParticle {
    protected double emittedXSpeed;
    protected double emittedYSpeed;
    protected double emittedZSpeed;
    protected int emitterInterval;
    protected int emitterIterations;
    protected int particlesPerEmission;
    protected Vector3f emitterVariance;
    protected boolean emitOnFirstTick;

    protected AbstractRandomDistributionEmitter(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomDistributionEmitterOptions emitterOptions) {
        super(level, x, y, z, emitterOptions.getDimensions().x, emitterOptions.getDimensions().y, emitterOptions.getDimensions().z);
        this.emittedXSpeed = xSpeed;
        this.emittedYSpeed = ySpeed;
        this.emittedZSpeed = zSpeed;
        this.emitterInterval = emitterOptions.getTickInterval();
        this.emitterIterations = emitterOptions.getRepeat();
        this.particlesPerEmission = emitterOptions.getParticlesPerEmission();
        this.emitOnFirstTick = emitterOptions.getEmitOnFirstTick();
        this.emitterVariance = emitterOptions.getVelocityVariance();
        this.method_3077(this.emitterInterval * this.emitterIterations);
        this.field_3874 -= (double)(this.emitterWidth / 2.0f);
        this.field_3854 -= (double)(this.emitterHeight / 2.0f);
        this.field_3871 -= (double)(this.emitterDepth / 2.0f);
    }

    @Override
    protected void emitterTick() {
        if ((this.field_3866 - (this.emitOnFirstTick ? 1 : 0)) % this.emitterInterval == 0) {
            for (int i = 0; i < this.particlesPerEmission; ++i) {
                double[] emitPos = this.getRandomPositionInsideBounds();
                class_2394 particle = this.getParticleToEmit(this.field_3851, emitPos[0], emitPos[1], emitPos[2]);
                if (particle == null) continue;
                this.field_3851.method_8406(particle, emitPos[0], emitPos[1], emitPos[2], this.emittedXSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.x - this.emitterVariance.x / 2.0f), this.emittedYSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.y - this.emitterVariance.y / 2.0f), this.emittedZSpeed + (double)(this.field_3851.field_9229.method_43057() * this.emitterVariance.z - this.emitterVariance.z / 2.0f));
            }
        }
    }

    protected double[] getRandomPositionInsideBounds() {
        double newX = this.field_3874 + (double)(this.emitterWidth * this.field_3851.field_9229.method_43057());
        double newY = this.field_3854 + (double)(this.emitterHeight * this.field_3851.field_9229.method_43057());
        double newZ = this.field_3871 + (double)(this.emitterDepth * this.field_3851.field_9229.method_43057());
        return new double[]{newX, newY, newZ};
    }
}

