/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.util;

import games.enchanted.eg_particle_interactions.common.Logging;
import games.enchanted.eg_particle_interactions.common.mixin.accessor.client.SpriteContentsAccessor;
import games.enchanted.eg_particle_interactions.common.resource.ParticlePaletteAtlasManager;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextureHelpers;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;

public class ColourUtil {
    private static final HashMap<class_2960, Integer> AVERAGE_SPRITE_COLOUR_CACHE = new HashMap();
    private static final int OPAQUE_PIXELS_THRESHOLD = 20;
    private static final HashMap<class_2960, ImageCoordinate[]> SPRITE_OPAQUE_PIXELS_CACHE = new HashMap();
    private static final HashMap<class_2680, class_1058> BLOCKSTATE_PARTICLE_SPRITE_CACHE = new HashMap();

    public static int[] getAverageBlockColour(class_2680 blockState) {
        class_1058 particleSprite = class_310.method_1551().method_1541().method_3349(blockState).method_68511();
        try (class_7764 contents = particleSprite.method_45851();){
            class_2960 particleSpriteLocation = contents.method_45816();
            if (AVERAGE_SPRITE_COLOUR_CACHE.containsKey(particleSpriteLocation)) {
                int[] nArray = ColourUtil.ARGBint_to_ARGB(AVERAGE_SPRITE_COLOUR_CACHE.get(particleSpriteLocation));
                return nArray;
            }
            int average = ColourUtil.calculateAverageSpriteColour(particleSprite);
            AVERAGE_SPRITE_COLOUR_CACHE.put(particleSpriteLocation, average);
            int[] nArray = ColourUtil.ARGBint_to_ARGB(average);
            return nArray;
        }
    }

    public static int calculateAverageSpriteColour(class_1058 sprite) {
        if (sprite == null) {
            return -1;
        }
        try (class_7764 spriteContents = sprite.method_45851();){
            if (spriteContents.method_45817().findAny().isEmpty()) {
                int n = -1;
                return n;
            }
            float total = 0.0f;
            float red = 0.0f;
            float blue = 0.0f;
            float green = 0.0f;
            float alpha = 0.0f;
            for (int x = 0; x < spriteContents.method_45807(); ++x) {
                for (int y = 0; y < spriteContents.method_45815(); ++y) {
                    int color = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage().method_61940(x, y);
                    int[] argb = ColourUtil.ARGBint_to_ARGB(color);
                    int pixelAlpha = argb[0];
                    if (pixelAlpha <= 10) continue;
                    total += 1.0f;
                    alpha += (float)pixelAlpha;
                    red += (float)argb[1];
                    green += (float)argb[2];
                    blue += (float)argb[3];
                }
            }
            float[] hsb = Color.RGBtoHSB((int)(red / total), (int)(green / total), (int)(blue / total), null);
            hsb[2] = hsb[2] * 1.05f;
            int[] rgb = ColourUtil.RGBint_to_RGB(Color.HSBtoRGB(Math.clamp(hsb[0], 0.0f, 1.0f), Math.clamp(hsb[1], 0.0f, 1.0f), Math.clamp(hsb[2], 0.0f, 1.0f)));
            int n = ColourUtil.ARGB_to_ARGBint((int)(alpha / total), rgb[0], rgb[1], rgb[2]);
            return n;
        }
    }

    public static int[] getRandomBlockColour(class_2680 blockState, int[] tintColour) {
        ImageCoordinate[] pixelCoordinatesList;
        class_1058 paletteSprite;
        if (BLOCKSTATE_PARTICLE_SPRITE_CACHE.containsKey(blockState)) {
            paletteSprite = BLOCKSTATE_PARTICLE_SPRITE_CACHE.get(blockState);
        } else {
            class_1058 particleSprite = class_310.method_1551().method_1541().method_3349(blockState).method_68511();
            class_2960 particleSpriteLocation = particleSprite.method_45851().method_45816();
            paletteSprite = TextureHelpers.getParticlePaletteOrBlockSprite(blockState.method_26204().method_40142().method_40237().method_29177(), particleSpriteLocation);
            BLOCKSTATE_PARTICLE_SPRITE_CACHE.put(blockState, paletteSprite);
            Logging.textureDebugInfo("Palette sprite for blockstate: {} has been cached", blockState);
        }
        ParticlePaletteAtlasManager.ParticlePaletteSettingsMetadataSection paletteMetadata = ParticlePaletteAtlasManager.getMetadataFromSprite(paletteSprite);
        class_7764 spriteContents = paletteSprite.method_45851();
        class_2960 paletteSpriteLocation = spriteContents.method_45816();
        if (SPRITE_OPAQUE_PIXELS_CACHE.containsKey(paletteSpriteLocation)) {
            pixelCoordinatesList = SPRITE_OPAQUE_PIXELS_CACHE.get(paletteSpriteLocation);
        } else {
            pixelCoordinatesList = ColourUtil.findOutWhereOpaquePixelCoordinatesAre(spriteContents);
            SPRITE_OPAQUE_PIXELS_CACHE.put(paletteSpriteLocation, pixelCoordinatesList);
            Logging.textureDebugInfo("Opaque pixels list for sprite: {} has been cached", spriteContents.method_45816());
        }
        if (pixelCoordinatesList.length == 0) {
            return new int[]{0, 255, 255, 255};
        }
        ImageCoordinate randomPixelCoordinate = pixelCoordinatesList.length == 1 && (pixelCoordinatesList[0].x() < 0 || pixelCoordinatesList[0].y() < 0) ? new ImageCoordinate(MathHelpers.randomBetween(0, spriteContents.method_45807() - 1), MathHelpers.randomBetween(0, spriteContents.method_45815() - 1)) : pixelCoordinatesList[MathHelpers.randomBetween(0, pixelCoordinatesList.length - 1)];
        class_1011 particleImage = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage();
        if (randomPixelCoordinate.x() > particleImage.method_4307() - 1 || randomPixelCoordinate.y() > particleImage.method_4323() - 1) {
            return new int[]{255, 255, 255, 255};
        }
        int sampledColour = particleImage.method_61940(randomPixelCoordinate.x(), randomPixelCoordinate.y());
        int[] sampledARGB = ColourUtil.ARGBint_to_ARGB(sampledColour);
        if (paletteMetadata.useBiomeTint()) {
            return ColourUtil.multiplyColours(sampledARGB, tintColour);
        }
        return sampledARGB;
    }

    private static ImageCoordinate[] findOutWhereOpaquePixelCoordinatesAre(class_7764 spriteContents) {
        ArrayList<ImageCoordinate> coordinatesList = new ArrayList<ImageCoordinate>();
        int totalOpaquePixels = 0;
        for (int x = 0; x < spriteContents.method_45807(); ++x) {
            for (int y = 0; y < spriteContents.method_45815(); ++y) {
                class_1011 image = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage();
                int sampledColour = image.method_61940(x, y);
                int[] argb = ColourUtil.ARGBint_to_ARGB(sampledColour);
                if (argb[0] <= 20) continue;
                ImageCoordinate coordinate = new ImageCoordinate(x, y);
                if (!coordinatesList.contains(coordinate)) {
                    coordinatesList.add(coordinate);
                }
                ++totalOpaquePixels;
            }
        }
        if (totalOpaquePixels >= (spriteContents.method_45807() - 1) * (spriteContents.method_45815() - 1)) {
            Logging.textureDebugInfo("Sprite {} contains entirely opaque pixels", spriteContents.method_45816());
            return new ImageCoordinate[]{new ImageCoordinate(-1, -1)};
        }
        ImageCoordinate[] coordinatesArray = new ImageCoordinate[coordinatesList.size()];
        coordinatesArray = coordinatesList.toArray(coordinatesArray);
        Logging.textureDebugInfo("Sprite {} has {} opaque pixels", spriteContents.method_45816(), totalOpaquePixels);
        return coordinatesArray;
    }

    public static void invalidateCaches() {
        AVERAGE_SPRITE_COLOUR_CACHE.clear();
        SPRITE_OPAQUE_PIXELS_CACHE.clear();
        BLOCKSTATE_PARTICLE_SPRITE_CACHE.clear();
    }

    public static int ARGB_to_ARGBint(int a, int r, int g, int b) {
        int alpha = MathHelpers.clampInt(a, 0, 255);
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int[] ARGBint_to_ARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int RGB_to_RGBint(int r, int g, int b) {
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return red << 16 | green << 8 | blue;
    }

    public static int[] RGBint_to_RGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }

    public static int[] RGBint_to_ARGB(int rgb) {
        int[] rgbArray = ColourUtil.RGBint_to_RGB(rgb);
        return new int[]{255, rgbArray[0], rgbArray[1], rgbArray[2]};
    }

    public static int[] ARGBfloats_to_ARGB(float a, float r, float g, float b) {
        return new int[]{(int)(a * 255.0f), (int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f)};
    }

    public static int[] randomiseNegative(int[] colours, float amount) {
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], -MathHelpers.randomBetween(0.0f, amount));
        }
        return randomised;
    }

    public static int[] randomiseNegativeUniform(int[] colours, float amount) {
        float randomAmount = -MathHelpers.randomBetween(0.0f, amount);
        int[] randomised = new int[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            randomised[i] = ColourUtil.variateColourComponent(colours[i], randomAmount);
        }
        return randomised;
    }

    public static int variateColourComponent(int colour, float variation) {
        return MathHelpers.clampInt(colour + (int)(variation * 255.0f), 0, 255);
    }

    public static int[] multiplyColours(int[] colour1, int[] colour2) {
        if (colour1.length != colour2.length) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: colour1 and colour2 must both be either ARGB or RGB arrays. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        if (colour1.length != 4 && colour1.length != 3) {
            throw new IllegalArgumentException(ColourUtil.class.getName() + "#multiplyColours: both colours must have 4 or 3 values. colour1: " + Arrays.toString(colour1) + ", colour2: " + Arrays.toString(colour2));
        }
        int[] multipliedColour = new int[colour1.length];
        for (int i = 0; i < colour1.length; ++i) {
            multipliedColour[i] = (int)(Math.clamp((float)colour1[i] / 255.0f * ((float)colour2[i] / 255.0f), 0.0f, 255.0f) * 255.0f);
        }
        return multipliedColour;
    }

    private record ImageCoordinate(int x, int y) {
    }
}

