package games.enchanted.eg_particle_interactions.common.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import games.enchanted.eg_particle_interactions.common.Constants;
import games.enchanted.eg_particle_interactions.common.config.adapters.BlockLocationTypeAdapter;
import games.enchanted.eg_particle_interactions.common.config.adapters.FluidTypeAdapter;
import games.enchanted.eg_particle_interactions.common.config.adapters.ResourceLocationTypeAdapter;
import games.enchanted.eg_particle_interactions.common.config.type.BrushParticleBehaviour;
import games.enchanted.eg_particle_interactions.common.platform.PlatformHelper;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class ConfigHandler {
    public static final Path CONFIG_PATH = PlatformHelper.getConfigPath().resolve(Constants.MOD_ID + "_config.json");

    public static final ConfigClassHandler<ConfigHandler> HANDLER = ConfigClassHandler.createBuilder(ConfigHandler.class)
        .id(class_2960.method_60655(Constants.MOD_ID, "config"))
        .serializer(config -> GsonConfigSerializerBuilder.create(config)
            .appendGsonBuilder(builder -> builder.registerTypeAdapter(class_3611.class, new FluidTypeAdapter()))
            .appendGsonBuilder(builder -> builder.registerTypeAdapter(class_2960.class, new ResourceLocationTypeAdapter()))
            .appendGsonBuilder(builder -> builder.registerTypeAdapter(BlockOrTagLocation.class, new BlockLocationTypeAdapter()))
            .setPath(CONFIG_PATH)
            .build())
        .build();

    public static void load() {
        HANDLER.load();
    }

    public static void save() {
        HANDLER.save();
    }

    public static ConfigHandler instance() {
        return HANDLER.instance();
    }

    @SerialEntry
    public static double config_version = 0.5;

    // General options
    // pixel consistent terrain particles
    public static final boolean general_pixelConsistentTerrainParticles_DEFAULT = true;
    @SerialEntry
    public static boolean general_pixelConsistentTerrainParticles = general_pixelConsistentTerrainParticles_DEFAULT;

    // particle z-fighting fix
    public static final boolean general_particleZFightingFix_DEFAULT = true;
    @SerialEntry
    public static boolean general_particleZFightingFix = general_particleZFightingFix_DEFAULT;

    // projectile breaking particles
    public static final boolean general_projectileBreakingParticleVelocity_DEFAULT = true;
    @SerialEntry
    public static boolean general_projectileBreakingParticleVelocity = general_projectileBreakingParticleVelocity_DEFAULT;

    // auto collapse config lists
    public static final boolean general_autoCollapseConfigLists_DEFAULT = true;
    @SerialEntry
    public static boolean general_autoCollapseConfigLists = general_autoCollapseConfigLists_DEFAULT;

    // firefly tweaks
    public static final boolean general_fireflyFixes_DEFAULT = true;
    @SerialEntry
    public static boolean general_fireflyFixes = general_fireflyFixes_DEFAULT;

    // - performance
    // interaction render distance
    public static final int general_interactionRenderDistance_DEFAULT = 6;
    @SerialEntry
    public static int general_interactionRenderDistance = general_interactionRenderDistance_DEFAULT;

    // block render distance
    public static final int general_blockRenderDistance_DEFAULT = 6;
    @SerialEntry
    public static int general_blockRenderDistance = general_blockRenderDistance_DEFAULT;

    // ambient render distance
    public static final int general_ambientRenderDistance_DEFAULT = 3;
    @SerialEntry
    public static int general_ambientRenderDistance = general_ambientRenderDistance_DEFAULT;

    // advanced particle physics
    public static final boolean general_extraParticlePhysicsEnabled_DEFAULT = true;
    @SerialEntry
    public static boolean general_extraParticlePhysicsEnabled = general_extraParticlePhysicsEnabled_DEFAULT;

    // sparks: spawn additional flash effects
    public static final boolean particle_sparks_additionalFlashEffects_DEFAULT = true;
    @SerialEntry
    public static boolean particle_sparks_additionalFlashEffects = particle_sparks_additionalFlashEffects_DEFAULT;

    // sparks: water evaporation
    public static final boolean particle_sparks_waterEvaporation_DEFAULT = true;
    @SerialEntry
    public static boolean particle_sparks_waterEvaporation = particle_sparks_waterEvaporation_DEFAULT;

    // dust: spawn specks
    public static final boolean particle_dust_additionalSpecks_DEFAULT = true;
    @SerialEntry
    public static boolean particle_dust_additionalSpecks = particle_dust_additionalSpecks_DEFAULT;

    // - debug
    // debug emitter bounds
    public static final boolean debug_showEmitterBounds_DEFAULT = false;
    public static boolean debug_showEmitterBounds = debug_showEmitterBounds_DEFAULT;

    // Block Interaction Particles
    // underwater bubbles
    public static final int maxUnderwaterBubbles_onBreak_DEFAULT = 6;
    @SerialEntry
    public static int maxUnderwaterBubbles_onBreak = maxUnderwaterBubbles_onBreak_DEFAULT;

    public static final boolean underwaterBubbles_onBreak_DEFAULT = true;
    @SerialEntry
    public static boolean underwaterBubbles_onBreak = underwaterBubbles_onBreak_DEFAULT;

    // snowflake particle
    public static final int maxSnowflakes_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxSnowflakes_onPlace = maxSnowflakes_onPlace_DEFAULT;

    public static final boolean snowflake_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean snowflake_enabled = snowflake_enabled_DEFAULT;

    public static final int maxSnowflakes_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxSnowflakes_onBreak = maxSnowflakes_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> snowflake_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10477), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10491), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_27879));
    @SerialEntry
    public static List<BlockOrTagLocation> snowflake_Blocks = snowflake_Blocks_DEFAULT;

    // firefly particle
    public static final int maxFirefly_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxFirefly_onPlace = maxFirefly_onPlace_DEFAULT;

    public static final boolean firefly_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean firefly_enabled = firefly_enabled_DEFAULT;

    public static final int maxFirefly_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxFirefly_onBreak = maxFirefly_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> firefly_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56455)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> firefly_Blocks = firefly_Blocks_DEFAULT;

    // cherry petal particle
    public static final int maxCherryPetals_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxCherryPetals_onPlace = maxCherryPetals_onPlace_DEFAULT;

    public static final boolean cherryPetal_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean cherryPetal_enabled = cherryPetal_enabled_DEFAULT;

    public static final int maxCherryPetals_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxCherryPetals_onBreak = maxCherryPetals_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> cherryPetal_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_42731), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_42727), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_42750));
    @SerialEntry
    public static List<BlockOrTagLocation> cherryPetal_Blocks = cherryPetal_Blocks_DEFAULT;

    // azalea leaf particle
    public static final int maxAzaleaLeaves_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxAzaleaLeaves_onPlace = maxAzaleaLeaves_onPlace_DEFAULT;

    public static final boolean azaleaLeaf_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean azaleaLeaf_enabled = azaleaLeaf_enabled_DEFAULT;

    public static final int maxAzaleaLeaves_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxAzaleaLeaves_onBreak = maxAzaleaLeaves_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> azaleaLeaf_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28678), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28673));
    @SerialEntry
    public static List<BlockOrTagLocation> azaleaLeaf_Blocks = azaleaLeaf_Blocks_DEFAULT;

    // flowering azalea leaf particle
    public static final int maxFloweringAzaleaLeaves_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxFloweringAzaleaLeaves_onPlace = maxFloweringAzaleaLeaves_onPlace_DEFAULT;

    public static final boolean floweringAzaleaLeaf_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean floweringAzaleaLeaf_enabled = floweringAzaleaLeaf_enabled_DEFAULT;

    public static final int maxFloweringAzaleaLeaves_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxFloweringAzaleaLeaves_onBreak = maxFloweringAzaleaLeaves_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> floweringAzaleaLeaf_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28679), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28674));
    @SerialEntry
    public static List<BlockOrTagLocation> floweringAzaleaLeaf_Blocks = floweringAzaleaLeaf_Blocks_DEFAULT;

    // pale leaf particle
    public static final int maxPaleLeaves_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxPaleLeaves_onPlace = maxPaleLeaves_onPlace_DEFAULT;

    public static final boolean paleLeaf_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean paleLeaf_enabled = paleLeaf_enabled_DEFAULT;

    public static final int maxPaleLeaves_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxPaleLeaves_onBreak = maxPaleLeaves_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> paleLeaf_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54714), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54712));
    @SerialEntry
    public static List<BlockOrTagLocation> paleLeaf_Blocks = paleLeaf_Blocks_DEFAULT;

    // biome tinted leaf particle
    public static final int maxTintedLeaves_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxTintedLeaves_onPlace = maxTintedLeaves_onPlace_DEFAULT;

    public static final boolean tintedLeaves_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean tintedLeaves_enabled = tintedLeaves_enabled_DEFAULT;

    public static final int maxTintedLeaves_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxTintedLeaves_onBreak = maxTintedLeaves_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> tintedLeaves_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_55742),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10335),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10503),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10035),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10098),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_37551)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> tintedLeaves_Blocks = tintedLeaves_Blocks_DEFAULT;

    // biome tinted pine leaf particle
    public static final int maxTintedPineLeaves_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxTintedPineLeaves_onPlace = maxTintedPineLeaves_onPlace_DEFAULT;

    public static final boolean tintedPineLeaves_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean tintedPineLeaves_enabled = tintedPineLeaves_enabled_DEFAULT;

    public static final int maxTintedPineLeaves_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxTintedPineLeaves_onBreak = maxTintedPineLeaves_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> tintedPineLeaves_Blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10539), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_9988));
    @SerialEntry
    public static List<BlockOrTagLocation> tintedPineLeaves_Blocks = tintedPineLeaves_Blocks_DEFAULT;

    // flower petal particle
    public static final int maxFlowerPetals_onPlace_DEFAULT = 3;
    @SerialEntry
    public static int maxFlowerPetals_onPlace = maxFlowerPetals_onPlace_DEFAULT;

    public static final boolean flowerPetals_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean flowerPetals_enabled = flowerPetals_enabled_DEFAULT;

    public static final int maxFlowerPetals_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxFlowerPetals_onBreak = maxFlowerPetals_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> flowerPetals_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23079),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23078),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22124),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22123),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56454),
        new BlockOrTagLocation(class_3481.field_28621.comp_327(), true),
        new BlockOrTagLocation(class_3481.field_20339.comp_327(), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers"), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers/small"), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers/tall"), true)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> flowerPetals_Blocks = flowerPetals_Blocks_DEFAULT;

    // grass blade
    public static final int maxGrassBlade_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxGrassBlade_onPlace = maxGrassBlade_onPlace_DEFAULT;

    public static final boolean grassBlade_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean grassBlade_enabled = grassBlade_enabled_DEFAULT;

    public static final int maxGrassBlade_onBreak_DEFAULT = 4;
    @SerialEntry
    public static int maxGrassBlade_onBreak = maxGrassBlade_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> grassBlade_Blocks_DEFAULT = List.of(
        new BlockOrTagLocation(class_3481.field_20341.comp_327(), true),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10597),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10479),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10214),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10112),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10313),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_16999),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10428),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10376),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10238),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10359),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10194),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10219),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28411),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56562),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56563),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10428)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> grassBlade_Blocks = grassBlade_Blocks_DEFAULT;

    // heavy grass blade
    public static final int maxHeavyGrassBlade_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxHeavyGrassBlade_onPlace = maxHeavyGrassBlade_onPlace_DEFAULT;

    public static final boolean heavyGrassBlade_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean heavyGrassBlade_enabled = heavyGrassBlade_enabled_DEFAULT;

    public static final int maxHeavyGrassBlade_onBreak_DEFAULT = 4;
    @SerialEntry
    public static int maxHeavyGrassBlade_onBreak = maxHeavyGrassBlade_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> heavyGrassBlade_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28686),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54733),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10343),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10589)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> heavyGrassBlade_Blocks = heavyGrassBlade_Blocks_DEFAULT;

    // moss clump
    public static final int maxMossClump_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxMossClump_onPlace = maxMossClump_onPlace_DEFAULT;

    public static final boolean mossClump_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean mossClump_enabled = mossClump_enabled_DEFAULT;

    public static final int maxMossClump_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxMossClump_onBreak = maxMossClump_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> mossClump_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28680),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28681)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> mossClump_Blocks = mossClump_Blocks_DEFAULT;

    // pale moss clump
    public static final int maxPaleMossClump_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxPaleMossClump_onPlace = maxPaleMossClump_onPlace_DEFAULT;

    public static final boolean paleMossClump_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean paleMossClump_enabled = paleMossClump_enabled_DEFAULT;

    public static final int maxPaleMossClump_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxPaleMossClump_onBreak = maxPaleMossClump_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> paleMossClump_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54732),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54731)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> paleMossClump_Blocks = mossClump_Blocks_DEFAULT;

    // dust
    public static final int maxDust_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxDust_onPlace = maxDust_onPlace_DEFAULT;

    public static final boolean dust_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean dust_enabled = dust_enabled_DEFAULT;

    public static final int maxDust_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxDust_onBreak = maxDust_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> dust_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10102),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_42728),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10255),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_43227),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10534),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10114),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22090),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10197),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10628),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10353),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10023),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10287),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10022),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10145),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10133),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10529),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10233),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10321),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10456),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10404),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10300),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10522)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> dust_Blocks = dust_Blocks_DEFAULT;

    // redstone dust
    public static final int maxRedstoneDust_onPlace_DEFAULT = 3;
    @SerialEntry
    public static int maxRedstoneDust_onPlace = maxRedstoneDust_onPlace_DEFAULT;

    public static final boolean redstoneDust_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean redstoneDust_enabled = redstoneDust_enabled_DEFAULT;

    public static final int maxRedstoneDust_onBreak_DEFAULT = 4;
    @SerialEntry
    public static int maxRedstoneDust_onBreak = maxRedstoneDust_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> redstoneDust_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10523),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10301),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10091),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10002),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10450),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10377)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> redstoneDust_Blocks = redstoneDust_Blocks_DEFAULT;

    // nether portal shatter
    public static final int maxBlockShatter_onPlace_DEFAULT = 3;
    @SerialEntry
    public static int maxBlockShatter_onPlace = maxBlockShatter_onPlace_DEFAULT;

    public static final boolean blockShatter_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean blockShatter_enabled = blockShatter_enabled_DEFAULT;

    public static final int maxBlockShatter_onBreak_DEFAULT = 4;
    @SerialEntry
    public static int maxBlockShatter_onBreak = maxBlockShatter_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> blockShatter_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10316)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> blockShatter_Blocks = blockShatter_Blocks_DEFAULT;

    // chain snap
    public static final int maxChainSnap_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxChainSnap_onPlace = maxChainSnap_onPlace_DEFAULT;

    public static final boolean chainSnap_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean chainSnap_enabled = chainSnap_enabled_DEFAULT;

    public static final int maxChainSnap_onBreak_DEFAULT = 6;
    @SerialEntry
    public static int maxChainSnap_onBreak = maxChainSnap_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> chainSnap_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23985),
        new BlockOrTagLocation(class_2960.method_60655("c", "chains"), true)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> chainSnap_Blocks = chainSnap_Blocks_DEFAULT;

    // sugar cane
    public static final int maxSugarCane_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxSugarCane_onPlace = maxSugarCane_onPlace_DEFAULT;

    public static final boolean sugarCane_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean sugarCane_enabled = sugarCane_enabled_DEFAULT;

    public static final int maxSugarCane_onBreak_DEFAULT = 3;
    @SerialEntry
    public static int maxSugarCane_onBreak = maxSugarCane_onBreak_DEFAULT;

    public static final List<BlockOrTagLocation> sugarCane_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10424),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10211),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_37546)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> sugarCane_Blocks = sugarCane_Blocks_DEFAULT;

    // vanilla block particle
    public static final int maxBlock_onPlace_DEFAULT = 2;
    @SerialEntry
    public static int maxBlock_onPlace = maxBlock_onPlace_DEFAULT;

    public static final boolean block_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean block_enabled = block_enabled_DEFAULT;

    public static final int maxBlock_onBreak_DEFAULT = 4;
    @SerialEntry
    public static int maxBlock_onBreak = maxBlock_onBreak_DEFAULT;

    // Block Interaction / Ambient Particles
    // underwater bubbles
    public static final int maxUnderwaterBubbles_onPlace_DEFAULT = 12;
    @SerialEntry
    public static int maxUnderwaterBubbles_onPlace = maxUnderwaterBubbles_onPlace_DEFAULT;

    public static final boolean underwaterBubbles_onPlace_DEFAULT = true;
    @SerialEntry
    public static boolean underwaterBubbles_onPlace = underwaterBubbles_onPlace_DEFAULT;

    // campfire sparks
    public static final int campfireSpark_spawnChance_DEFAULT = 20;
    @SerialEntry
    public static int campfireSpark_spawnChance = campfireSpark_spawnChance_DEFAULT;

    public static final boolean campfireSpark_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean campfireSpark_enabled = campfireSpark_enabled_DEFAULT;

    public static final int campfireEmber_spawnChance_DEFAULT = 45;
    @SerialEntry
    public static int campfireEmber_spawnChance = campfireEmber_spawnChance_DEFAULT;

    public static final boolean campfireEmber_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean campfireEmber_enabled = campfireEmber_enabled_DEFAULT;

    // fire sparks
    public static final int fireSpark_spawnChance_DEFAULT = 25;
    @SerialEntry
    public static int fireSpark_spawnChance = fireSpark_spawnChance_DEFAULT;

    public static final boolean fireSpark_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean fireSpark_enabled = fireSpark_enabled_DEFAULT;

    public static final int fireEmber_spawnChance_DEFAULT = 45;
    @SerialEntry
    public static int fireEmber_spawnChance = fireEmber_spawnChance_DEFAULT;

    public static final boolean fireEmber_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean fireEmber_enabled = fireEmber_enabled_DEFAULT;

    // block rustle particles
    public static final boolean blockRustle_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean blockRustle_enabled = blockRustle_enabled_DEFAULT;

    public static final List<BlockOrTagLocation> blockRustle_Blocks_DEFAULT = List.of(
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10424),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56455),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56454),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56562),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56563),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_55742),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10597),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54733),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10479),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10214),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10112),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10313),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_16999),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10428),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10376),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10238),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22116),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23078),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23079),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22117),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22125),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22123),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22124),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28686),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10343),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10477),
        RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10091),
        new BlockOrTagLocation(class_3481.field_28621.comp_327(), true),
        new BlockOrTagLocation(class_3481.field_20339.comp_327(), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers"), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers/small"), true),
        new BlockOrTagLocation(class_2960.method_60655("c", "flowers/tall"), true),
        new BlockOrTagLocation(class_3481.field_20341.comp_327(), true)
    );
    @SerialEntry
    public static List<BlockOrTagLocation> blockRustle_Blocks = blockRustle_Blocks_DEFAULT;

    // anvil use sparks
    public static final int maxAnvilUseSparks_onUse_DEFAULT = 18;
    @SerialEntry
    public static int maxAnvilUseSparks_onUse = maxAnvilUseSparks_onUse_DEFAULT;

    public static final boolean anvilUseSparks_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean anvilUseSparks_enabled = anvilUseSparks_enabled_DEFAULT;

    // grindstone use sparks
    public static final int maxGrindstoneUseSparks_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxGrindstoneUseSparks_onUse = maxGrindstoneUseSparks_onUse_DEFAULT;

    public static final boolean grindstoneUseSparks_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean grindstoneUseSparks_enabled = grindstoneUseSparks_enabled_DEFAULT;

    // falling block effects
    public static final boolean fallingBlockEffect_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean fallingBlockEffect_enabled = fallingBlockEffect_enabled_DEFAULT;

    public static final int fallingBlockEffect_renderDistance_DEFAULT = 64;
    @SerialEntry
    public static int fallingBlockEffect_renderDistance = fallingBlockEffect_renderDistance_DEFAULT;

    // redstone interaction dust
    public static final boolean redstoneInteractionDust_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean redstoneInteractionDust_enabled = redstoneInteractionDust_enabled_DEFAULT;

    public static final int redstoneInteractionDust_amount_DEFAULT = 6;
    @SerialEntry
    public static int redstoneInteractionDust_amount = redstoneInteractionDust_amount_DEFAULT;

    // smoker smoke
    public static final boolean smokerSmoke_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean smokerSmoke_enabled = smokerSmoke_enabled_DEFAULT;

    // furnace embers
    public static final boolean furnaceEmbers_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean furnaceEmbers_enabled = furnaceEmbers_enabled_DEFAULT;

    public static final boolean furnaceVanillaParticles_enabled_DEFAULT = false;
    @SerialEntry
    public static boolean furnaceVanillaParticles_enabled = furnaceVanillaParticles_enabled_DEFAULT;

    // blast furnace sparks
    public static final boolean blastFurnaceSparks_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean blastFurnaceSparks_enabled = blastFurnaceSparks_enabled_DEFAULT;

    // Entity Particles
    // travelling minecarts
    public static final int minecart_spawnChance_DEFAULT = 50;
    @SerialEntry
    public static int minecart_spawnChance = minecart_spawnChance_DEFAULT;

    public static final boolean minecart_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean minecart_enabled = minecart_enabled_DEFAULT;

    public static final boolean minecart_onlyWithPassenger_DEFAULT = true;
    @SerialEntry
    public static boolean minecart_onlyWithPassenger = minecart_onlyWithPassenger_DEFAULT;

    // lightning strike particles
    public static final boolean lightningStrike_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean lightningStrike_enabled = lightningStrike_enabled_DEFAULT;

    public static final int lightningStrike_amountOfArcs_DEFAULT = 3;
    @SerialEntry
    public static int lightningStrike_amountOfArcs = lightningStrike_amountOfArcs_DEFAULT;

    public static final int lightningStrike_amountOfSparks_DEFAULT = 18;
    @SerialEntry
    public static int lightningStrike_amountOfSparks = lightningStrike_amountOfSparks_DEFAULT;

    // blaze sparks
    public static final int blaze_spawnChance_DEFAULT = 25;
    @SerialEntry
    public static int blaze_spawnChance = blaze_spawnChance_DEFAULT;

    public static final boolean blaze_spawnOnHurt_DEFAULT = true;
    @SerialEntry
    public static boolean blaze_spawnOnHurt = blaze_spawnOnHurt_DEFAULT;

    public static final int blaze_amountToSpawnOnHurt_DEFAULT = 6;
    @SerialEntry
    public static int blaze_amountToSpawnOnHurt = blaze_amountToSpawnOnHurt_DEFAULT;

    // item frame interaction
    public static final boolean itemFrame_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean itemFrame_enabled = itemFrame_enabled_DEFAULT;

    public static final int itemFrame_amount_DEFAULT = 4;
    @SerialEntry
    public static int itemFrame_amount = itemFrame_amount_DEFAULT;

    // Fluid Placement Particles
    // water
    public static final List<class_2960> tintedWaterSplash_fluids_DEFAULT = List.of(RegistryHelpers.getLocationFromFluid(class_3612.field_15910), RegistryHelpers.getLocationFromFluid(class_3612.field_15909));
    @SerialEntry
    public static List<class_2960> tintedWaterSplash_fluids = tintedWaterSplash_fluids_DEFAULT;

    public static final int maxTintedWaterSplash_onPlace_DEFAULT = 12;
    @SerialEntry
    public static int maxTintedWaterSplash_onPlace = maxTintedWaterSplash_onPlace_DEFAULT;

    public static final boolean tintedWaterSplash_onPlace_DEFAULT = true;
    @SerialEntry
    public static boolean tintedWaterSplash_onPlace = tintedWaterSplash_onPlace_DEFAULT;

    // lava
    public static final List<class_2960> lavaSplash_fluids_DEFAULT = List.of(RegistryHelpers.getLocationFromFluid(class_3612.field_15908), RegistryHelpers.getLocationFromFluid(class_3612.field_15907));
    @SerialEntry
    public static List<class_2960> lavaSplash_fluids = lavaSplash_fluids_DEFAULT;

    public static final int maxLavaSplash_onPlace_DEFAULT = 7;
    @SerialEntry
    public static int maxLavaSplash_onPlace = maxLavaSplash_onPlace_DEFAULT;

    public static final boolean lavaSplash_onPlace_DEFAULT = true;
    @SerialEntry
    public static boolean lavaSplash_onPlace = lavaSplash_onPlace_DEFAULT;

    // generic
    public static final List<class_2960> genericSplash_fluids_DEFAULT = List.of();
    @SerialEntry
    public static List<class_2960> genericSplash_fluids = genericSplash_fluids_DEFAULT;

    public static final int maxGenericSplash_onPlace_DEFAULT = 10;
    @SerialEntry
    public static int maxGenericSplash_onPlace = maxGenericSplash_onPlace_DEFAULT;

    public static final boolean genericSplash_onPlace_DEFAULT = true;
    @SerialEntry
    public static boolean genericSplash_onPlace = genericSplash_onPlace_DEFAULT;

    // Item Interaction Particles
    // brush particle behaviour
    public static final BrushParticleBehaviour brushParticleBehaviour_DEFAULT = BrushParticleBehaviour.BLOCK_OVERRIDE_OR_DUST;
    @SerialEntry
    public static BrushParticleBehaviour brushParticleBehaviour = brushParticleBehaviour_DEFAULT;

    // flint and steel sparks
    public static final int flintAndSteelSpark_intensity_DEFAULT = 5;
    @SerialEntry
    public static int flintAndSteelSpark_intensity = flintAndSteelSpark_intensity_DEFAULT;

    public static final int maxFlintAndSteelSpark_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxFlintAndSteelSpark_onUse = maxFlintAndSteelSpark_onUse_DEFAULT;

    public static final boolean flintAndSteelSpark_onUse_DEFAULT = true;
    @SerialEntry
    public static boolean flintAndSteelSpark_onUse = flintAndSteelSpark_onUse_DEFAULT;

    // fire charge particles
    public static final int fireCharge_intensity_DEFAULT = 5;
    @SerialEntry
    public static int fireCharge_intensity = fireCharge_intensity_DEFAULT;

    public static final int maxFireCharge_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxFireCharge_onUse = maxFireCharge_onUse_DEFAULT;

    public static final boolean fireCharge_onUse_DEFAULT = true;
    @SerialEntry
    public static boolean fireCharge_onUse = fireCharge_onUse_DEFAULT;

    // axe strip
    public static final int maxAxeStrip_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxAxeStrip_onUse = maxAxeStrip_onUse_DEFAULT;

    public static final boolean axeStrip_onUse_DEFAULT = true;
    @SerialEntry
    public static boolean axeStrip_onUse = axeStrip_onUse_DEFAULT;

    // hoe till
    public static final int maxHoeTill_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxHoeTill_onUse = maxHoeTill_onUse_DEFAULT;

    public static final boolean hoeTill_onUse_DEFAULT = true;
    @SerialEntry
    public static boolean hoeTill_onUse = hoeTill_onUse_DEFAULT;

    // shovel flatten
    public static final int maxShovelFlatten_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxShovelFlatten_onUse = maxShovelFlatten_onUse_DEFAULT;

    public static final boolean shovelFlatten_onUse_DEFAULT = true;
    @SerialEntry
    public static boolean shovelFlatten_onUse = shovelFlatten_onUse_DEFAULT;

    // honey collection particles
    public static final int maxHoneyCollection_onUse_DEFAULT = 12;
    @SerialEntry
    public static int maxHoneyCollection_onUse = maxHoneyCollection_onUse_DEFAULT;

    public static final boolean honeyCollection_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean honeyCollection_enabled = honeyCollection_enabled_DEFAULT;

    public static final boolean honeyCollection_replaceVanilla_DEFAULT = true;
    @SerialEntry
    public static boolean honeyCollection_replaceVanilla = honeyCollection_replaceVanilla_DEFAULT;

    // fluid ambient
    // lava bubble pop particles
    public static final boolean lavaBubblePop_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean lavaBubblePop_enabled = lavaBubblePop_enabled_DEFAULT;

    public static final int lavaBubblePop_spawnChance_DEFAULT = 20;
    @SerialEntry
    public static int lavaBubblePop_spawnChance = lavaBubblePop_spawnChance_DEFAULT;

    // underwater bubble streams
    public static final List<BlockOrTagLocation> underwaterBubbleStreams_blocks_DEFAULT = List.of(RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10376), RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10238));
    @SerialEntry
    public static List<BlockOrTagLocation> underwaterBubbleStreams_blocks = underwaterBubbleStreams_blocks_DEFAULT;

    public static final boolean underwaterBubbleStreams_enabled_DEFAULT = true;
    @SerialEntry
    public static boolean underwaterBubbleStreams_enabled = underwaterBubbleStreams_enabled_DEFAULT;

    public static final int underwaterBubbleStreams_spawnChance_DEFAULT = 12;
    @SerialEntry
    public static int underwaterBubbleStreams_spawnChance = underwaterBubbleStreams_spawnChance_DEFAULT;

}
