package games.enchanted.eg_particle_interactions.common.particle.constant_motion;

import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import games.enchanted.eg_particle_interactions.common.util.RenderingUtil;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class LavaPop extends ConstantMotionAnimatedParticle {
    protected LavaPop(class_638 level, double x, double y, double z, class_4002 spriteSet, int lifetime, float quadSize, boolean transparency) {
        super(level, x, y, z, spriteSet, lifetime, quadSize, transparency);
    }

    @Override
    protected void method_60374(@NotNull class_4588 buffer, @NotNull Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float scale = this.method_18132(partialTicks);
        float uo = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int packedLight = this.method_3068(partialTicks);
        this.method_60375(buffer, quaternion, x, y, z, 1.0F, -1.0F, scale, u1, v1, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, 1.0F, 1.0F, scale, u1, v0, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, -1.0F, 1.0F, scale, uo, v0, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, -1.0F, -1.0F, scale, uo, v1, packedLight);
    }

    private void method_60375(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight) {
        yOffset += 1f;
        RenderingUtil.addVertexToConsumer(buffer, quaternion, x, y, z, xOffset, yOffset, scale, u, v, packedLight, this.field_3861, this.field_3842, this.field_3859, this.field_3841);
    }

    public static class LavaPopProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public LavaPopProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        @Override
        public class_703 createParticle(@NotNull class_2400 type, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LavaPop(level, x, y, z, spriteSet, MathHelpers.randomBetween(26, 32), 2/8f, false);
        }
    }
}
