package games.enchanted.eg_particle_interactions.common.config.adapters;

import com.google.gson.*;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import java.lang.reflect.Type;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class FluidTypeAdapter implements JsonSerializer<class_3611>, JsonDeserializer<class_3611> {
    @Override
    public class_3611 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        return RegistryHelpers.getDefaultedFluid(jsonElement.getAsString(), class_3612.field_15906);
    }

    @Override
    public JsonElement serialize(class_3611 fluid, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(RegistryHelpers.getLocationFromFluid(fluid).toString());
    }
}
