package games.enchanted.eg_particle_interactions.common.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1297.class)
public abstract class LocalPlayer_EntityMixin {
    @Shadow public abstract double getX();
    @Shadow public abstract class_1937 level();
    @Shadow public abstract class_243 getDeltaMovement();

    @Shadow public abstract double getY();

    @Shadow public abstract double getZ();

    @Unique private int block_place_particle$ticksUntilNextBlockDisturbance = 0;

    @WrapOperation(
        at = @At(value = "INVOKE",
            //? if minecraft: <= 1.21.8 {
            /*target = "Lnet/minecraft/world/level/block/state/BlockState;entityInside(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/InsideBlockEffectApplier;)V"
            *///?} else {
            target = "Lnet/minecraft/world/level/block/state/BlockState;entityInside(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/InsideBlockEffectApplier;Z)V"
            //?}
        ),
        method = {"lambda$checkInsideBlocks$0", "method_67632"}
    )
    protected void trySpawnParticlesWhenPlayerInsideBlock(
        class_2680 insideBlockState,
        class_1937 level,
        class_2338 insideBlockPos,
        class_1297 entity,
        class_10774 insideBlockEffectApplier,
        //? if minecraft: > 1.21.8 {
        boolean b,
        //?}
        Operation<Void> original
    ) {
        original.call(
            insideBlockState,
            level,
            insideBlockPos,
            entity,
            insideBlockEffectApplier
            //? if minecraft: > 1.21.8 {
            , b
            //?}
        );

        if(
            block_place_particle$ticksUntilNextBlockDisturbance > 0
            ||
            // check if entity is player
            !((Object) entity instanceof class_1657 player)
            ||
            // check if player's level is client side
            !(player.method_73183() instanceof class_638 clientLevel)
        ) {
            --block_place_particle$ticksUntilNextBlockDisturbance;
            return;
        }

        block_place_particle$ticksUntilNextBlockDisturbance = MathHelpers.randomBetween(3, 10);
        class_2338 verticalOffsetBlockPos = class_2338.method_49637(insideBlockPos.method_10263(), this.getY() + 0.1, insideBlockPos.method_10260());
        SpawnParticles.spawnBlockDisturbanceParticles(clientLevel, verticalOffsetBlockPos, level.method_8320(verticalOffsetBlockPos), this.getX(), this.getY(), this.getZ(), this.getDeltaMovement(), player.method_5624());
    }
}
