/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.ListOptionEntry;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import games.enchanted.blockplaceparticles.ParticleInteractionsLogging;
import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.config.ConfigScreenHelper;
import games.enchanted.blockplaceparticles.config.controller.BlockLocationController;
import games.enchanted.blockplaceparticles.config.controller.FluidLocationController;
import games.enchanted.blockplaceparticles.config.type.BrushParticleBehaviour;
import games.enchanted.blockplaceparticles.localisation.ConfigTranslation;
import games.enchanted.blockplaceparticles.util.RegistryHelpers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_437;

public class ConfigScreen {
    public static class_437 createConfigScreen(class_437 parentScreen) {
        YetAnotherConfigLib.Builder yaclBuilder = YetAnotherConfigLib.createBuilder().save(ConfigHandler::save).title(ConfigTranslation.getConfigTitle().toComponent());
        return ConfigScreen.createConfigCategories(yaclBuilder).generateScreen(parentScreen);
    }

    private static YetAnotherConfigLib createConfigCategories(YetAnotherConfigLib.Builder yaclBuilder) {
        yaclBuilder.category(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("general").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("general"))}).group(ConfigScreen.createGenericConfigGroup("general", "general", false, ConfigScreen.genericBooleanOption("pixel_consistent_terrain_particles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.general_pixelConsistentTerrainParticles, newVal -> {
            ConfigHandler.general_pixelConsistentTerrainParticles = newVal;
        })), ConfigScreen.genericBooleanOption("particle_zfighting_fix", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.general_particleZFightingFix, newVal -> {
            ConfigHandler.general_particleZFightingFix = newVal;
        })))).group(ConfigScreen.createGenericConfigGroup("performance", "general", false, ConfigScreen.genericBooleanOption("particle_physics_enabled", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.general_extraParticlePhysicsEnabled, newVal -> {
            ConfigHandler.general_extraParticlePhysicsEnabled = newVal;
        })))).group(ConfigScreen.createGenericConfigGroup("debug", "general", true, new Option[]{ButtonOption.createBuilder().name(ConfigTranslation.getGlobalOption("toggle_debug_logs").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("toggle_debug_logs"))})).action((yaclScreen, thisOption) -> ParticleInteractionsLogging.toggleDebugLogs()).build(), ConfigScreen.genericBooleanOption("debug_show_emitter_bounds", (Binding<Boolean>)Binding.generic((Object)false, () -> ConfigHandler.debug_showEmitterBounds, newVal -> {
            ConfigHandler.debug_showEmitterBounds = newVal;
        }))})).build());
        yaclBuilder.category(ConfigScreenHelper.createBlockParticleOverrideConfigWidgets(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("blocks").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("blocks"))}).group(OptionGroup.createBuilder().name(ConfigTranslation.getGroupName("blocks", "info").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGroupName("blocks", "info"))})).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build())).build());
        yaclBuilder.category(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("block_ambient").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("block_ambient"))}).group(OptionGroup.createBuilder().name(ConfigTranslation.getGroupName("block_ambient", "info").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGroupName("block_ambient", "info"))})).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build()).group(ConfigScreen.createMultipleOptionsConfigGroup("underwater_block_bubbles", "underwater_block_bubbles", "block_ambient", ConfigScreen.booleanOption("spawn_block_particle_on_place", "underwater_block_bubbles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.underwaterBubbles_onPlace, newVal -> {
            ConfigHandler.underwaterBubbles_onPlace = newVal;
        })), ConfigScreen.integerSliderOption("max_particles_block_place", "underwater_block_bubbles", 12, () -> ConfigHandler.maxUnderwaterBubbles_onPlace, newVal -> {
            ConfigHandler.maxUnderwaterBubbles_onPlace = newVal;
        }, 1, 50, 1), ConfigScreen.booleanOption("spawn_block_particle_on_break", "underwater_block_bubbles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.underwaterBubbles_onBreak, newVal -> {
            ConfigHandler.underwaterBubbles_onBreak = newVal;
        })), ConfigScreen.integerSliderOption("max_particles_block_break", "underwater_block_bubbles", 6, () -> ConfigHandler.maxUnderwaterBubbles_onBreak, newVal -> {
            ConfigHandler.maxUnderwaterBubbles_onBreak = newVal;
        }, 1, 50, 1))).group(ConfigScreen.createParticleToggleAndIntSliderConfigGroup("campfire_sparks", "campfire_sparks", "block_ambient", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.campfireSpark_enabled, newVal -> {
            ConfigHandler.campfireSpark_enabled = newVal;
        }), "is_particle_enabled", ConfigScreen.integerSliderOption("particle_spawn_chance", "campfire_sparks", 20, () -> ConfigHandler.campfireSpark_spawnChance, newVal -> {
            ConfigHandler.campfireSpark_spawnChance = newVal;
        }, 1, 100, 1))).group(ConfigScreen.createParticleToggleAndIntSliderConfigGroup("fire_sparks", "fire_sparks", "block_ambient", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.fireSpark_enabled, newVal -> {
            ConfigHandler.fireSpark_enabled = newVal;
        }), "is_particle_enabled", ConfigScreen.integerSliderOption("particle_spawn_chance", "fire_sparks", 25, () -> ConfigHandler.fireSpark_spawnChance, newVal -> {
            ConfigHandler.fireSpark_spawnChance = newVal;
        }, 1, 100, 1))).group(ConfigScreen.createParticleToggleAndIntSliderConfigGroup("anvil_craft_sparks", "anvil_craft_sparks", "block_ambient", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.anvilUseSparks_enabled, newVal -> {
            ConfigHandler.anvilUseSparks_enabled = newVal;
        }), "is_particle_enabled", ConfigScreen.integerSliderOption("max_particles_block_craft", "anvil_craft_sparks", 18, () -> ConfigHandler.maxAnvilUseSparks_onUse, newVal -> {
            ConfigHandler.maxAnvilUseSparks_onUse = newVal;
        }, 1, 32, 1))).group(ConfigScreen.createParticleToggleAndIntSliderConfigGroup("grindstone_craft_sparks", "grindstone_craft_sparks", "block_ambient", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.grindstoneUseSparks_enabled, newVal -> {
            ConfigHandler.grindstoneUseSparks_enabled = newVal;
        }), "is_particle_enabled", ConfigScreen.integerSliderOption("max_particles_block_craft", "grindstone_craft_sparks", 12, () -> ConfigHandler.maxGrindstoneUseSparks_onUse, newVal -> {
            ConfigHandler.maxGrindstoneUseSparks_onUse = newVal;
        }, 1, 32, 1))).build());
        yaclBuilder.category(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("items").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("items"))}).group(OptionGroup.createBuilder().name(ConfigTranslation.getGroupName("items", "info").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGroupName("items", "info"))})).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build()).group(ConfigScreen.createGenericConfigGroup("brush_particles", "items", false, ConfigScreen.enumCycleOption("brush_particle_behaviour", Binding.generic((Object)((Object)ConfigHandler.brushParticleBehaviour_DEFAULT), () -> ConfigHandler.brushParticleBehaviour, newVal -> {
            ConfigHandler.brushParticleBehaviour = newVal;
        }), BrushParticleBehaviour.class))).group(ConfigScreen.createParticleToggleAndMaxAndIntensityConfigGroup("flint_and_steel_sparks", "flint_and_steel_sparks", "items", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.flintAndSteelSpark_onUse, newVal -> {
            ConfigHandler.flintAndSteelSpark_onUse = newVal;
        }), "spawn_particle_on_item_use", ConfigScreen.integerSliderOption("max_particles_item_use", "flint_and_steel_sparks", 12, () -> ConfigHandler.maxFlintAndSteelSpark_onUse, newVal -> {
            ConfigHandler.maxFlintAndSteelSpark_onUse = newVal;
        }, 1, 32, 1), ConfigScreen.integerSliderOption("item_use_particle_intensity", "flint_and_steel_sparks", 5, () -> ConfigHandler.flintAndSteelSpark_intensity, newVal -> {
            ConfigHandler.flintAndSteelSpark_intensity = newVal;
        }, 1, 8, 1))).group(ConfigScreen.createParticleToggleAndMaxAndIntensityConfigGroup("fire_charge_smoke", "fire_charge_smoke", "items", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.fireCharge_onUse, newVal -> {
            ConfigHandler.fireCharge_onUse = newVal;
        }), "spawn_particle_on_item_use", ConfigScreen.integerSliderOption("max_particles_item_use", "fire_charge_smoke", 12, () -> ConfigHandler.maxFireCharge_onUse, newVal -> {
            ConfigHandler.maxFireCharge_onUse = newVal;
        }, 1, 32, 1), ConfigScreen.integerSliderOption("item_use_particle_intensity", "fire_charge_smoke", 5, () -> ConfigHandler.fireCharge_intensity, newVal -> {
            ConfigHandler.fireCharge_intensity = newVal;
        }, 1, 8, 1))).group(ConfigScreen.createMultipleOptionsConfigGroup("axe_strip_particles", "axe_strip_particles", "items", ConfigScreen.booleanOption("spawn_particle_on_item_use", "axe_strip_particles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.axeStrip_onUse, newVal -> {
            ConfigHandler.axeStrip_onUse = newVal;
        })), ConfigScreen.integerSliderOption("max_particles_item_use", "axe_strip_particles", 12, () -> ConfigHandler.maxAxeStrip_onUse, newVal -> {
            ConfigHandler.maxAxeStrip_onUse = newVal;
        }, 1, 50, 1))).group(ConfigScreen.createMultipleOptionsConfigGroup("hoe_till_particles", "hoe_till_particles", "items", ConfigScreen.booleanOption("spawn_particle_on_item_use", "hoe_till_particles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.hoeTill_onUse, newVal -> {
            ConfigHandler.hoeTill_onUse = newVal;
        })), ConfigScreen.integerSliderOption("max_particles_item_use", "hoe_till_particles", 12, () -> ConfigHandler.maxHoeTill_onUse, newVal -> {
            ConfigHandler.maxHoeTill_onUse = newVal;
        }, 1, 50, 1))).group(ConfigScreen.createMultipleOptionsConfigGroup("shovel_flatten_particles", "shovel_flatten_particles", "items", ConfigScreen.booleanOption("spawn_particle_on_item_use", "shovel_flatten_particles", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.shovelFlatten_onUse, newVal -> {
            ConfigHandler.shovelFlatten_onUse = newVal;
        })), ConfigScreen.integerSliderOption("max_particles_item_use", "shovel_flatten_particles", 12, () -> ConfigHandler.maxShovelFlatten_onUse, newVal -> {
            ConfigHandler.maxShovelFlatten_onUse = newVal;
        }, 1, 50, 1))).build());
        yaclBuilder.category(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("entity").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("entity"))}).group(OptionGroup.createBuilder().name(ConfigTranslation.getGroupName("entity", "info").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGroupName("entity", "info"))})).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build()).group(ConfigScreen.createMultipleOptionsConfigGroup("minecart_sparks", "minecart_sparks", "entity", ConfigScreen.booleanOption("spawn_particle_at_minecart_max_speed", "minecart_sparks", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.minecart_enabled, newVal -> {
            ConfigHandler.minecart_enabled = newVal;
        })), ConfigScreen.integerSliderOption("minecart_wheel_particle_amount", "minecart_sparks", 50, () -> ConfigHandler.minecart_spawnChance, newVal -> {
            ConfigHandler.minecart_spawnChance = newVal;
        }, 1, 100, 1), ConfigScreen.booleanOption("minecart_only_with_passenger", "minecart_sparks", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.minecart_onlyWithPassenger, newVal -> {
            ConfigHandler.minecart_onlyWithPassenger = newVal;
        })))).group(ConfigScreen.createMultipleOptionsConfigGroup("blaze_sparks", "blaze_sparks", "entity", ConfigScreen.integerSliderOption("entity_ambient_particle_spawn_chance", "blaze_sparks", 25, () -> ConfigHandler.blaze_spawnChance, newVal -> {
            ConfigHandler.blaze_spawnChance = newVal;
        }, 1, 100, 1), ConfigScreen.booleanOption("spawn_particle_on_entity_hurt", "blaze_sparks", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.blaze_spawnOnHurt, newVal -> {
            ConfigHandler.blaze_spawnOnHurt = newVal;
        })), ConfigScreen.integerSliderOption("amount_to_spawn_on_entity_hurt", "blaze_sparks", 6, () -> ConfigHandler.blaze_amountToSpawnOnHurt, newVal -> {
            ConfigHandler.blaze_amountToSpawnOnHurt = newVal;
        }, 1, 32, 1))).build());
        yaclBuilder.category(ConfigCategory.createBuilder().name(ConfigTranslation.getCategoryName("fluids").toComponent()).tooltip(new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getCategoryName("fluids"))}).group(OptionGroup.createBuilder().name(ConfigTranslation.getGroupName("fluids", "info").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(ConfigTranslation.getGroupName("fluids", "info"))})).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build()).group(ConfigScreen.createFluidParticleToggleAndMaxConfigGroup("tinted_splash", "tinted_splash", "fluids", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.tintedWaterSplash_onPlace, newVal -> {
            ConfigHandler.tintedWaterSplash_onPlace = newVal;
        }), ConfigScreen.maxParticlesOnPlaceOption("max_particles_fluid_place", 12, () -> ConfigHandler.maxTintedWaterSplash_onPlace, newVal -> {
            ConfigHandler.maxTintedWaterSplash_onPlace = newVal;
        }))).group(ConfigScreen.createFluidListOption("tinted_splash", "tinted_splash_fluids", "fluids", ConfigHandler.tintedWaterSplash_fluids_DEFAULT, () -> ConfigHandler.tintedWaterSplash_fluids, newVal -> {
            ConfigHandler.tintedWaterSplash_fluids = newVal;
        })).group(ConfigScreen.createSeparator()).group(ConfigScreen.createFluidParticleToggleAndMaxConfigGroup("lava_splash", "generic_particle_fluids", "fluids", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.lavaSplash_onPlace, newVal -> {
            ConfigHandler.lavaSplash_onPlace = newVal;
        }), ConfigScreen.maxParticlesOnPlaceOption("max_particles_fluid_place", 7, () -> ConfigHandler.maxLavaSplash_onPlace, newVal -> {
            ConfigHandler.maxLavaSplash_onPlace = newVal;
        }))).group(ConfigScreen.createFluidListOption("lava_splash", "generic_particle", "fluids", ConfigHandler.lavaSplash_fluids_DEFAULT, () -> ConfigHandler.lavaSplash_fluids, newVal -> {
            ConfigHandler.lavaSplash_fluids = newVal;
        })).group(ConfigScreen.createSeparator()).group(ConfigScreen.createFluidParticleToggleAndMaxConfigGroup("generic_splash", "generic_splash", "fluids", (Binding<Boolean>)Binding.generic((Object)true, () -> ConfigHandler.genericSplash_onPlace, newVal -> {
            ConfigHandler.genericSplash_onPlace = newVal;
        }), ConfigScreen.maxParticlesOnPlaceOption("max_particles_fluid_place", 10, () -> ConfigHandler.maxGenericSplash_onPlace, newVal -> {
            ConfigHandler.maxGenericSplash_onPlace = newVal;
        }))).group(ConfigScreen.createFluidListOption("generic_splash", "generic_splash_fluids", "fluids", ConfigHandler.genericSplash_fluids_DEFAULT, () -> ConfigHandler.genericSplash_fluids, newVal -> {
            ConfigHandler.genericSplash_fluids = newVal;
        })).build());
        return yaclBuilder.build();
    }

    public static OptionGroup createSeparator() {
        return OptionGroup.createBuilder().name((class_2561)class_2561.method_43471((String)"eg_particle_interactions.config.category_separator").method_54663(-9671572)).collapsed(true).option((Option)LabelOption.createBuilder().line((class_2561)class_2561.method_43473()).build()).build();
    }

    private static OptionGroup createFluidParticleToggleAndMaxConfigGroup(String particleTypeKey, String groupName, String category, Binding<Boolean> spawnOnFluidPlaceBinding, Option<Integer> maxPlaceParticlesOption) {
        Option onFluidPlaceOption = Option.createBuilder().name(ConfigTranslation.getGlobalOption("spawn_fluid_particle_on_place").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("spawn_fluid_particle_on_place")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(spawnOnFluidPlaceBinding).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        return ConfigScreen.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, onFluidPlaceOption, maxPlaceParticlesOption);
    }

    public static OptionGroup createBlockPlaceAndBreakConfigGroup(String particleTypeKey, String groupName, String category, Binding<Boolean> spawnOnBlockPlaceBinding, Option<Integer> maxPlaceParticlesOption, Binding<Boolean> spawnOnBlockBreakBinding, Option<Integer> maxBreakParticlesOption) {
        Option spawnOnBlockPlaceOption = Option.createBuilder().name(ConfigTranslation.getGlobalOption("spawn_block_particle_on_place").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("spawn_block_particle_on_place")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(spawnOnBlockPlaceBinding).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        Option spawnOnBlockBreakOption = Option.createBuilder().name(ConfigTranslation.getGlobalOption("spawn_block_particle_on_break").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("spawn_block_particle_on_break")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(spawnOnBlockBreakBinding).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        return ConfigScreen.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, spawnOnBlockPlaceOption, maxPlaceParticlesOption, spawnOnBlockBreakOption, maxBreakParticlesOption);
    }

    private static OptionGroup createParticleToggleAndMaxAndIntensityConfigGroup(String particleTypeKey, String groupName, String category, Binding<Boolean> particleEnabledBinding, String particleEnabledTranslationOption, Option<Integer> maxParticlesOnUseOption, Option<Integer> particleIntensityOption) {
        Option<Boolean> particleToggleOption = ConfigScreen.booleanOption(particleEnabledTranslationOption, particleTypeKey, particleEnabledBinding);
        return ConfigScreen.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, particleToggleOption, maxParticlesOnUseOption, particleIntensityOption);
    }

    private static OptionGroup createParticleToggleAndIntSliderConfigGroup(String particleTypeKey, String groupName, String category, Binding<Boolean> particleEnabledBinding, String particleEnabledTranslationOption, Option<Integer> intSlider) {
        Option<Boolean> particleToggleOption = ConfigScreen.booleanOption(particleEnabledTranslationOption, particleTypeKey, particleEnabledBinding);
        return ConfigScreen.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, particleToggleOption, intSlider);
    }

    public static OptionGroup createMultipleOptionsConfigGroup(String particleTypeKey, String groupName, String category, Option<?> ... options) {
        return ConfigScreen.createMultipleOptionsConfigGroup(particleTypeKey, groupName, category, false, options);
    }

    public static OptionGroup createMultipleOptionsConfigGroup(String particleTypeKey, String groupName, String category, boolean collapseByDefault, Option<?> ... options) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        OptionGroup.Builder optionGroupBuilder = OptionGroup.createBuilder().name(ConfigTranslation.createPlaceholder(groupNameKey.toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(groupNameKey), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())}));
        for (Option<?> option : options) {
            optionGroupBuilder.option(option);
        }
        return optionGroupBuilder.collapsed(collapseByDefault).build();
    }

    public static OptionGroup createGenericConfigGroup(String groupName, String category, boolean collapseByDefault, Option<?> ... options) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        OptionGroup.Builder optionGroupBuilder = OptionGroup.createBuilder().name(groupNameKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(groupNameKey)}));
        for (Option<?> option : options) {
            optionGroupBuilder.option(option);
        }
        return optionGroupBuilder.collapsed(collapseByDefault).build();
    }

    private static Option<Boolean> booleanOption(String booleanOptionLabelText, String particleTypeKey, Binding<Boolean> binding) {
        return Option.createBuilder().name(ConfigTranslation.getGlobalOption(booleanOptionLabelText).toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(booleanOptionLabelText)), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(binding).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
    }

    private static Option<Boolean> genericBooleanOption(String optionName, Binding<Boolean> binding) {
        ConfigTranslation.TranslationKey translationKey = ConfigTranslation.getGlobalOption(optionName);
        return Option.createBuilder().name(translationKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(translationKey)})).binding(binding).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
    }

    private static <T extends Enum> Option<T> enumCycleOption(String optionName, Binding<T> binding, Class<T> enumClass) {
        ConfigTranslation.TranslationKey translationKey = ConfigTranslation.getGlobalOption(optionName);
        return Option.createBuilder().name(translationKey.toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createDesc(translationKey)})).binding(binding).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(enumClass)).build();
    }

    public static Option<Integer> maxParticlesOnPlaceOption(String optionName, int maxParticlesDefault, Supplier<Integer> getter, Consumer<Integer> setter) {
        return ConfigScreen.integerSliderOption(optionName, maxParticlesDefault, getter, setter, 0, 16, 1);
    }

    public static Option<Integer> maxParticlesOnBreakOption(String optionName, int maxParticlesDefault, Supplier<Integer> getter, Consumer<Integer> setter) {
        return ConfigScreen.integerSliderOption(optionName, maxParticlesDefault, getter, setter, 0, 8, 1);
    }

    private static Option<Integer> integerSliderOption(String optionName, int maxParticlesDefault, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, int step) {
        return ConfigScreen.createIntegerOption(maxParticlesDefault, getter, setter, ConfigTranslation.getGlobalOption(optionName).toComponent(), ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(optionName)), min, max, step);
    }

    private static Option<Integer> integerSliderOption(String optionName, String particleTypeKey, int maxParticlesDefault, Supplier<Integer> getter, Consumer<Integer> setter, int min, int max, int step) {
        return ConfigScreen.createIntegerOption(maxParticlesDefault, getter, setter, ConfigTranslation.getGlobalOption(optionName).toComponent(), ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(optionName)), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString()), min, max, step);
    }

    private static Option<Integer> createIntegerOption(int defaultValue, Supplier<Integer> getter, Consumer<Integer> setter, class_2561 name, class_2561 description, int min, int max, int step) {
        return Option.createBuilder().name(name).description(OptionDescription.of((class_2561[])new class_2561[]{description})).binding((Object)defaultValue, getter, setter).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)min, (Number)max)).step((Number)step)).build();
    }

    public static ListOption<class_2960> createBlockLocationListOption(String particleTypeKey, String groupName, String category, List<class_2960> defaultValue, Supplier<List<class_2960>> getter, Consumer<List<class_2960>> setter) {
        return ConfigScreen.createListOption(RegistryHelpers.getLocationFromBlock(class_2246.field_10340), BlockLocationController::new, particleTypeKey, groupName, category, true, defaultValue, getter, setter);
    }

    private static ListOption<class_2960> createFluidListOption(String particleTypeKey, String groupName, String category, List<class_2960> defaultValue, Supplier<List<class_2960>> getter, Consumer<List<class_2960>> setter) {
        return ConfigScreen.createListOption(RegistryHelpers.getLocationFromFluid((class_3611)class_3612.field_15910), FluidLocationController::new, particleTypeKey, groupName, category, false, defaultValue, getter, setter);
    }

    private static <T> ListOption<T> createListOption(T initial, Function<ListOptionEntry<T>, Controller<T>> controller, String particleTypeKey, String groupName, String category, boolean collapsedByDefault, List<T> defaultValue, Supplier<List<T>> getter, Consumer<List<T>> setter) {
        ConfigTranslation.TranslationKey groupNameKey = ConfigTranslation.getGroupName(category, groupName);
        return ListOption.createBuilder().name(ConfigTranslation.createPlaceholder(groupNameKey.toComponent(), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(groupNameKey), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(defaultValue, getter, setter).customController(controller).collapsed(collapsedByDefault).initial(initial).build();
    }
}

