/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.config.controller.generic;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.blockplaceparticles.config.type.TwoTypesInterface;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public abstract class HybridOptionController<A, B, T extends TwoTypesInterface<A, B>>
implements Controller<T> {
    private final Option<T> option;
    @NotNull
    A currentTypeAValue;
    @NotNull
    Option<A> typeAOption;
    @NotNull
    B currentTypeBValue;
    @NotNull
    Option<B> typeBOption;

    public HybridOptionController(Option<T> option) {
        this.option = option;
        this.currentTypeAValue = ((TwoTypesInterface)option.pendingValue()).getTypeA();
        this.typeAOption = this.createOptionForTypeA();
        this.currentTypeBValue = ((TwoTypesInterface)option.pendingValue()).getTypeB();
        this.typeBOption = this.createOptionForTypeB();
        this.option.addListener(this::updateCurrentValues);
    }

    @NotNull
    public Option<A> getTypeAOption() {
        return this.typeAOption;
    }

    @NotNull
    public Option<B> getTypeBOption() {
        return this.typeBOption;
    }

    protected abstract Option<A> createOptionForTypeA();

    protected Binding<A> getTypeABinding(A defaultValue) {
        return Binding.generic(defaultValue, () -> this.currentTypeAValue, this::setTypeA);
    }

    protected abstract Option<B> createOptionForTypeB();

    protected Binding<B> getTypeBBinding(B defaultValue) {
        return Binding.generic(defaultValue, () -> this.currentTypeBValue, this::setTypeB);
    }

    protected void setTypeA(A location) {
        this.currentTypeAValue = location;
        this.setPendingValue();
    }

    protected void setTypeB(B colour) {
        this.currentTypeBValue = colour;
        this.setPendingValue();
    }

    protected void setPendingValue() {
        this.option.requestSet(this.getValueToSetAsPending(this.currentTypeAValue, this.currentTypeBValue));
    }

    protected abstract T getValueToSetAsPending(A var1, B var2);

    protected void updateCurrentValues(Option<T> changedOption, T pending) {
        this.typeAOption.requestSet(pending.getTypeA());
        this.typeAOption.applyValue();
        this.typeBOption.requestSet(pending.getTypeB());
        this.typeBOption.applyValue();
    }

    public Option<T> option() {
        return this.option;
    }

    public class_2561 formatValue() {
        return class_2561.method_43470((String)"");
    }

    public abstract AbstractWidget provideWidget(YACLScreen var1, Dimension<Integer> var2);
}

