/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle;

import games.enchanted.blockplaceparticles.particle.BouncyParticle;
import games.enchanted.blockplaceparticles.shapes.QuadFaceShape;
import games.enchanted.blockplaceparticles.shapes.ShapeDefinitions;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public abstract class StretchyBouncyShapeParticle
extends BouncyParticle {
    protected double prevPrevX;
    protected double prevPrevY;
    protected double prevPrevZ;
    private QuadFaceShape particleShape;
    protected Vector3f particleShapeScale;
    protected float prevPitch;
    protected float prevYaw;

    protected StretchyBouncyShapeParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        this.field_28787 = true;
        this.particleShapeScale = new Vector3f(1.0f);
        this.setShape(ShapeDefinitions.CUBE);
    }

    @Override
    public void method_3070() {
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        super.method_3070();
    }

    protected void setShape(QuadFaceShape newShape) {
        this.particleShape = newShape;
    }

    protected boolean isParticleMoving() {
        return (double)this.getTotalVelocity() < 0.001;
    }

    @NotNull
    public class_3940.class_8981 method_55245() {
        return (quaternionf, camera, d) -> quaternionf.set(0.0f, 0.0f, 0.0f, camera.method_23767().w);
    }

    protected void method_60373(@NotNull class_4588 consumer, @NotNull class_4184 camera, @NotNull Quaternionf quaternionf, float d) {
        Vector3f cameraPosition = camera.method_19326().method_46409();
        float xPos = (float)class_3532.method_16436((double)d, (double)this.field_3858, (double)this.field_3874);
        float yPos = (float)class_3532.method_16436((double)d, (double)this.field_3838, (double)this.field_3854);
        float zPos = (float)class_3532.method_16436((double)d, (double)this.field_3856, (double)this.field_3871);
        Vector3f pos = new Vector3f(xPos, yPos, zPos).sub((Vector3fc)cameraPosition);
        float prevXPos = (float)class_3532.method_16436((double)d, (double)this.prevPrevX, (double)this.field_3858);
        float prevYPos = (float)class_3532.method_16436((double)d, (double)this.prevPrevY, (double)this.field_3838);
        float prevZPos = (float)class_3532.method_16436((double)d, (double)this.prevPrevZ, (double)this.field_3856);
        Vector3f prevPos = new Vector3f(prevXPos, prevYPos, prevZPos).sub((Vector3fc)cameraPosition);
        this.renderCubeGeometry(consumer, pos, prevPos, d);
    }

    private void renderCubeGeometry(@NotNull class_4588 consumer, Vector3f pos, Vector3f prevPos, float d) {
        float cuboidSize = this.method_18132(d);
        float u0 = this.method_18133();
        float u1 = this.method_18134();
        float v0 = this.method_18135();
        float v1 = this.method_18136();
        int lightColor = this.method_3068(d);
        Vector3f normalisedMovementDir = new Vector3f((Vector3fc)pos).sub((Vector3fc)prevPos).normalize();
        float pitch = (float)Math.toDegrees(Math.asin(normalisedMovementDir.y));
        if (!Float.isFinite(pitch)) {
            pitch = this.prevPitch;
        }
        this.prevPitch = pitch;
        float yaw = (float)Math.toDegrees(Math.atan2(normalisedMovementDir.x, normalisedMovementDir.z));
        if (!Float.isFinite(yaw)) {
            yaw = this.prevYaw;
        }
        this.prevYaw = yaw;
        Vector3f shapePos = MathHelpers.getPosBetween3DPoints(pos, prevPos);
        Vector3f shapeScale = new Vector3f(1.0f, Math.max(Math.abs(MathHelpers.getDistanceBetweenVectors(pos, prevPos) * 40.0f), 1.0f), 1.0f).mul((Vector3fc)this.particleShapeScale);
        Vector3f shapeRotation = new Vector3f(-(pitch - 90.0f), yaw, 0.0f);
        this.particleShape.renderShapeWithRotation(consumer, new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u1, v1)}, shapePos, shapeScale, shapeRotation, cuboidSize, lightColor, new Vector4f(this.field_3861, this.field_3842, this.field_3859, this.field_3841));
    }
}

