/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.particle_spawning;

import games.enchanted.blockplaceparticles.config.ConfigHandler;
import games.enchanted.blockplaceparticles.config.type.BrushParticleBehaviour;
import games.enchanted.blockplaceparticles.particle.ModParticleTypes;
import games.enchanted.blockplaceparticles.particle.option.ParticleEmitterOptions;
import games.enchanted.blockplaceparticles.particle_spawning.SpawnParticlesUtil;
import games.enchanted.blockplaceparticles.particle_spawning.override.BlockParticleOverride;
import games.enchanted.blockplaceparticles.particle_spawning.override.FluidPlacementParticle;
import games.enchanted.blockplaceparticles.util.FluidHelpers;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3713;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SpawnParticles {
    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos, class_2680 placedBlockState) {
        int overrideOrigin;
        BlockParticleOverride particleOverride;
        if (ConfigHandler.underwaterBubbles_onPlace) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onPlace, (class_1937)level, blockPos);
        }
        if ((particleOverride = BlockParticleOverride.getOverrideForBlockState(placedBlockState, overrideOrigin = 1)) == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerEdge = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, true);
        if (maxParticlesPerEdge <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!placedBlockState.method_26215() && placedBlockState.method_45475()) {
            class_265 blockShape = placedBlockState.method_26218((class_1922)level, blockPos);
            double verticalAxisOffset = level.method_8320(blockPos.method_10069(0, -1, 0)).method_51367() ? 0.01 : 0.0;
            blockShape.method_1104((x1, y1, z1, x2, y2, z2) -> {
                class_2350.class_2351 biggestEdge;
                double edgeLength;
                double width = Math.abs(x1 - x2);
                double height = Math.abs(y1 - y2);
                double depth = Math.abs(z1 - z2);
                if (width > height && width > depth) {
                    edgeLength = width;
                    biggestEdge = class_2350.class_2351.field_11048;
                } else if (height > width && height > depth) {
                    edgeLength = height;
                    biggestEdge = class_2350.class_2351.field_11052;
                } else {
                    edgeLength = depth;
                    biggestEdge = class_2350.class_2351.field_11051;
                }
                int amountOfParticlesAlongEdge = class_3532.method_15384((double)(edgeLength * (double)maxParticlesPerEdge));
                if (amountOfParticlesAlongEdge < 1) {
                    amountOfParticlesAlongEdge = 1;
                }
                for (int i = 0; i < amountOfParticlesAlongEdge; ++i) {
                    double particlePos = ((double)i + 0.5) / (double)amountOfParticlesAlongEdge;
                    if (particlePos > edgeLength + 0.0625) continue;
                    double particleXOffset = (biggestEdge == class_2350.class_2351.field_11048 ? particlePos : width) + x1;
                    double particleYOffset = (biggestEdge == class_2350.class_2351.field_11052 ? particlePos : height) + y1 + verticalAxisOffset;
                    double particleZOffset = (biggestEdge == class_2350.class_2351.field_11051 ? particlePos : depth) + z1;
                    class_2394 particleToSpawn = particleOverride.getParticleOptionForState(placedBlockState, level, blockPos, overrideOrigin);
                    if (particleToSpawn == null) continue;
                    level.method_8406(particleToSpawn, (double)blockPos.method_10263() + MathHelpers.expandWhenOutOfBound(particleXOffset, 0.0, 1.0), (double)blockPos.method_10264() + MathHelpers.expandWhenOutOfBound(particleYOffset, 0.0, 1.0), (double)blockPos.method_10260() + MathHelpers.expandWhenOutOfBound(particleZOffset, 0.0, 1.0), (particleXOffset - 0.5) * particleOutwardVelocityAdjustment, (particleYOffset - 0.5) * particleOutwardVelocityAdjustment, (particleZOffset - 0.5) * particleOutwardVelocityAdjustment);
                }
            });
        }
    }

    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos) {
        class_2680 placedBlockState = level.method_8320(blockPos);
        SpawnParticles.spawnBlockPlaceParticle(level, blockPos, placedBlockState);
    }

    public static void spawnBlockBreakParticle(class_638 level, class_2680 brokenBlockState, class_2338 brokenBlockPos, BlockParticleOverride particleOverride) {
        if (ConfigHandler.underwaterBubbles_onBreak) {
            SpawnParticles.spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onBreak, (class_1937)level, brokenBlockPos);
        }
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }
        int maxParticlesPerLength = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, false);
        if (maxParticlesPerLength <= 0) {
            return;
        }
        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();
        if (!brokenBlockState.method_26215() && brokenBlockState.method_45475()) {
            class_265 blockShape = brokenBlockState.method_26218((class_1922)level, brokenBlockPos);
            blockShape.method_1089((x1, y1, z1, x2, y2, z2) -> {
                double width = Math.abs(x1 - x2);
                int amountAlongWidth = Math.clamp((long)class_3532.method_15384((double)(width * (double)maxParticlesPerLength)), 1, 999);
                double height = Math.abs(y1 - y2);
                int amountAlongHeight = Math.clamp((long)class_3532.method_15384((double)(height * (double)maxParticlesPerLength)), 1, 999);
                double depth = Math.abs(z1 - z2);
                int amountAlongDepth = Math.clamp((long)class_3532.method_15384((double)(depth * (double)maxParticlesPerLength)), 1, 999);
                for (int i_W = 0; i_W < amountAlongWidth; ++i_W) {
                    for (int i_H = 0; i_H < amountAlongHeight; ++i_H) {
                        for (int i_D = 0; i_D < amountAlongDepth; ++i_D) {
                            double particleXOffset = ((double)i_W + 0.5) / (double)amountAlongWidth;
                            double particleYOffset = ((double)i_H + 0.5) / (double)amountAlongHeight;
                            double particleZOffset = ((double)i_D + 0.5) / (double)amountAlongDepth;
                            class_2394 particleToSpawn = particleOverride.getParticleOptionForState(brokenBlockState, level, brokenBlockPos, 2);
                            if (particleToSpawn == null) continue;
                            level.method_8406(particleToSpawn, (double)brokenBlockPos.method_10263() + (particleXOffset * width + x1), (double)brokenBlockPos.method_10264() + (particleYOffset * height + y1), (double)brokenBlockPos.method_10260() + (particleZOffset * depth + z1), (particleXOffset - 0.5) * particleOutwardVelocityAdjustment, (particleYOffset - 0.5) * particleOutwardVelocityAdjustment, (particleZOffset - 0.5) * particleOutwardVelocityAdjustment);
                        }
                    }
                }
            });
        }
    }

    private static void spawnUnderwaterBubbles(int amountOfBubbles, class_1937 level, class_2338 blockPos) {
        if (!FluidHelpers.probablyPlacedUnderwater(level, blockPos)) {
            return;
        }
        for (int i = 0; i < Math.max(amountOfBubbles + level.field_9229.method_39332(-2, 0), 1); ++i) {
            double x = level.field_9229.method_43058();
            double y = level.field_9229.method_43058();
            double z = level.field_9229.method_43058();
            boolean blockAboveIsWater = level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517);
            double verticalVelocity = (y - 0.5) * (double)(blockAboveIsWater ? 2 : 0);
            double horizontalVelocityMul = !blockAboveIsWater ? 1.5 : 1.0;
            level.method_8406((class_2394)ModParticleTypes.UNDERWATER_RISING_BUBBLE, (double)blockPos.method_10263() + x, (double)blockPos.method_10264() + y, (double)blockPos.method_10260() + z, (x - 0.5) * 2.0 * horizontalVelocityMul, level.method_8320(blockPos.method_10074()).method_51367() ? Math.abs(verticalVelocity) + 0.1 : verticalVelocity, (z - 0.5) * 2.0 * horizontalVelocityMul);
        }
    }

    public static void spawnSparksAtMinecartWheels(double minecartX, double minecartY, double minecartZ, double minecartHorizontalRot, double minecartVerticalRot, boolean isOnRails, boolean hasPassenger, boolean hasBlock, class_243 deltaMovement, double maxSpeed, class_1937 level) {
        if (!ConfigHandler.minecart_enabled) {
            return;
        }
        if (!isOnRails) {
            return;
        }
        if (!hasBlock && !hasPassenger && ConfigHandler.minecart_onlyWithPassenger) {
            return;
        }
        double speed = MathHelpers.maxVec3(deltaMovement.method_46409(), true);
        if (speed < 0.05) {
            return;
        }
        float sparksChancePerWheel = (float)(Math.clamp(speed, 0.0, maxSpeed) / maxSpeed) - 0.75f;
        sparksChancePerWheel *= (float)ConfigHandler.minecart_spawnChance / 50.0f;
        float rotX = (float)(minecartHorizontalRot * (Math.PI / 180));
        float rotY = (float)(minecartVerticalRot * (Math.PI / 180));
        float sparkDeltaX = (float)Math.clamp(-deltaMovement.field_1352 / 3.0, -0.7, 0.7);
        float sparkDeltaZ = (float)Math.clamp(-deltaMovement.field_1350 / 3.0, -0.7, 0.7);
        minecartY += 0.0425;
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos1 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, 0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos1.x + minecartX, (double)wheelPos1.y + minecartY, (double)wheelPos1.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos2 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, 0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos2.x + minecartX, (double)wheelPos2.y + minecartY, (double)wheelPos2.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos3 = SpawnParticles.minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, -0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos3.x + minecartX, (double)wheelPos3.y + minecartY, (double)wheelPos3.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos4 = SpawnParticles.minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, -0.45f);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, (double)wheelPos4.x + minecartX, (double)wheelPos4.y + minecartY, (double)wheelPos4.z + minecartZ, (double)sparkDeltaX, 0.17, (double)sparkDeltaZ);
        }
    }

    private static Vector3f minecartWheelPoint(float rotationX, float rotationY, float pointX, float pointY, float pointZ) {
        return new Vector3f((float)((double)pointX * Math.cos(rotationX) - (double)pointZ * Math.sin(rotationX)), pointY * rotationY, (float)((double)pointZ * Math.cos(rotationX) + (double)pointX * Math.sin(rotationX)));
    }

    public static void spawnFlintAndSteelSparkParticle(class_1937 level, class_2338 particlePos) {
        if (!ConfigHandler.flintAndSteelSpark_onUse) {
            return;
        }
        class_2680 fireOrLitBlock = level.method_8320(particlePos);
        boolean isSoulBlock = level.method_8320(particlePos.method_10074()).method_26164(class_3481.field_23119) || fireOrLitBlock.method_27852(class_2246.field_23860);
        double sparkIntensity = (double)ConfigHandler.flintAndSteelSpark_intensity / 12.0;
        for (int i = 0; i < ConfigHandler.maxFlintAndSteelSpark_onUse; ++i) {
            double x = (double)particlePos.method_10263() + 0.25 + level.field_9229.method_43058() / 2.0;
            double y = (double)particlePos.method_10264() + 0.25 + level.field_9229.method_43058() / 2.0;
            double z = (double)particlePos.method_10260() + 0.25 + level.field_9229.method_43058() / 2.0;
            level.method_8406((class_2394)(isSoulBlock ? ModParticleTypes.FLYING_SOUL_SPARK : ModParticleTypes.FLYING_SPARK), x, y, z, (level.field_9229.method_43058() - 0.5) * sparkIntensity, (level.field_9229.method_43058() + 0.5) * sparkIntensity, (level.field_9229.method_43058() - 0.5) * sparkIntensity);
        }
    }

    public static void spawnAmbientCampfireSparks(class_1937 level, class_2338 particlePos, class_2680 campfireState) {
        if (!ConfigHandler.campfireSpark_enabled) {
            return;
        }
        double sparkIntensity = 0.4166666666666667;
        if (level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.campfireSpark_spawnChance) {
            for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; ++i) {
                SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (class_2394)(campfireState.method_27852(class_2246.field_23860) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.method_10263() + 0.5, (double)particlePos.method_10264() + 0.5, (double)particlePos.method_10260() + 0.5, sparkIntensity);
            }
        }
    }

    public static void spawnAmbientFireSparks(class_1937 level, class_2680 fireState, class_2338 particlePos, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!ConfigHandler.fireSpark_enabled) {
            return;
        }
        double sparkIntensity = 0.4166666666666667;
        double width = Math.abs(minX - maxX);
        double height = Math.abs(minY - maxY);
        double depth = Math.abs(minZ - maxZ);
        if (level.field_9229.method_43057() * 101.0f <= (float)ConfigHandler.fireSpark_spawnChance) {
            for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; ++i) {
                SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(level, (class_2394)(fireState.method_27852(class_2246.field_22089) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK), (double)particlePos.method_10263() + minX + (double)level.field_9229.method_43057() * width, (double)particlePos.method_10264() + minY + (double)level.field_9229.method_43057() * height, (double)particlePos.method_10260() + minZ + (double)level.field_9229.method_43057() * depth, sparkIntensity);
            }
        }
    }

    public static void spawnFireChargeSmokeParticle(class_1937 level, class_2338 particlePos) {
        if (!ConfigHandler.fireCharge_onUse) {
            return;
        }
        double lavaIntensity = (double)ConfigHandler.fireCharge_intensity / 24.0;
        double smokeIntensity = (double)ConfigHandler.fireCharge_intensity / 58.0;
        for (int i = 0; i < ConfigHandler.maxFireCharge_onUse; ++i) {
            double x = (double)particlePos.method_10263() + 0.25 + level.field_9229.method_43058() / 2.0;
            double y = (double)particlePos.method_10264() + 0.25 + level.field_9229.method_43058() / 2.0;
            double z = (double)particlePos.method_10260() + 0.25 + level.field_9229.method_43058() / 2.0;
            if ((double)level.field_9229.method_43057() > 0.2) {
                level.method_8406((class_2394)((double)level.field_9229.method_43057() > 0.3 ? class_2398.field_11251 : class_2398.field_11237), x, y, z, (level.field_9229.method_43058() - 0.5) * smokeIntensity, (level.field_9229.method_43058() + 0.5) * smokeIntensity, (level.field_9229.method_43058() - 0.5) * smokeIntensity);
                continue;
            }
            level.method_8406((class_2394)class_2398.field_11239, x, y, z, (level.field_9229.method_43058() - 0.5) * lavaIntensity, (level.field_9229.method_43058() + 0.5) * lavaIntensity, (level.field_9229.method_43058() - 0.5) * lavaIntensity);
        }
    }

    public static void spawnHoeTillParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if (!ConfigHandler.hoeTill_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxHoeTill_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnShovelFlattenParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if (!ConfigHandler.shovelFlatten_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxShovelFlatten_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnAxeStripParticle(class_1937 level, class_2338 blockPos, class_2680 unstrippedBlockState, class_2680 strippedBlockState, class_1838 context) {
        if (!ConfigHandler.axeStrip_onUse) {
            return;
        }
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxAxeStrip_onUse; ++i) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (double)(1 - clickDirection.method_10165());
            class_2388 blockParticle = (double)level.field_9229.method_43057() > 0.9 ? new class_2388(class_2398.field_11217, strippedBlockState) : new class_2388(class_2398.field_11217, unstrippedBlockState);
            level.method_8406((class_2394)blockParticle, clickedPosition.field_1352 + x, clickedPosition.field_1351 + y, clickedPosition.field_1350 + z, (double)clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5), (double)clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5));
        }
    }

    public static void spawnFluidPlacedParticle(class_1936 levelAccessor, class_2338 particlePos, class_3611 placedFluid) {
        if (placedFluid.method_15780(class_3612.field_15906)) {
            return;
        }
        FluidPlacementParticle particleOverride = FluidPlacementParticle.getParticleForFluid(placedFluid);
        if (particleOverride == FluidPlacementParticle.NONE) {
            return;
        }
        Object particleOption = particleOverride.isBlockStateParticle() ? particleOverride.getBlockParticleOption(placedFluid.method_15785().method_15759()) : particleOverride.getParticleOption();
        if (particleOption == null) {
            return;
        }
        int maxParticles = FluidPlacementParticle.getParticleMultiplier(particleOverride, true);
        for (int i = 0; i < maxParticles; ++i) {
            double x = (double)particlePos.method_10263() + levelAccessor.method_8409().method_43058();
            double y = (double)particlePos.method_10264() + levelAccessor.method_8409().method_43058() / 1.5 + 0.6;
            double z = (double)particlePos.method_10260() + levelAccessor.method_8409().method_43058();
            levelAccessor.method_8406(particleOption, x, y, z, 0.0, 0.21, 0.0);
        }
    }

    public static void spawnAnvilUseSparkParticles(class_638 level, class_2338 blockPos) {
        if (!ConfigHandler.anvilUseSparks_enabled) {
            return;
        }
        double x = (float)blockPos.method_10263() + 0.5f;
        double y = (double)blockPos.method_10264() + 1.0 + level.field_9229.method_43058() / 16.0;
        double z = (float)blockPos.method_10260() + 0.5f;
        ParticleEmitterOptions emitter = new ParticleEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, 3, 7, 1, 0.25f, 0.0f, 0.25f);
        SpawnParticlesUtil.spawnParticleInCircle(emitter, level, new class_243(x, y, z), ConfigHandler.maxAnvilUseSparks_onUse, 0.32f, 0.16f, 2.0f, 0.2f, 2.0f);
    }

    public static void spawnGrindstoneUseSparkParticles(class_638 level, class_2338 blockPos) {
        double z;
        double y;
        double x;
        if (!ConfigHandler.grindstoneUseSparks_enabled) {
            return;
        }
        class_2680 grindstoneState = level.method_8320(blockPos);
        if (!(grindstoneState.method_26204() instanceof class_3713)) {
            return;
        }
        class_2350 facing = (class_2350)grindstoneState.method_11654((class_2769)class_3713.field_11177);
        class_2738 attachFace = (class_2738)grindstoneState.method_11654((class_2769)class_3713.field_11007);
        if (attachFace == class_2738.field_12471) {
            x = (double)((float)blockPos.method_10263() + 0.5f) + (double)facing.method_10148() / 1.9;
            y = (float)blockPos.method_10264() + 0.5f;
            z = (double)((float)blockPos.method_10260() + 0.5f) + (double)facing.method_10165() / 1.9;
        } else {
            x = (float)blockPos.method_10263() + 0.5f;
            y = (float)blockPos.method_10264() + (attachFace == class_2738.field_12473 ? 0.0f : 1.05f);
            z = (float)blockPos.method_10260() + 0.5f;
        }
        ParticleEmitterOptions emitter = SpawnParticles.getGrindstoneSparkEmitter(attachFace, facing);
        float HORIZONTAL_MIN_SPEED = 0.05f;
        float HORIZONTAL_MAX_SPEED = 0.3f;
        float UPWARDS_SPEED = 0.5f;
        float DOWNWARDS_SPEED = 0.1f;
        level.method_8406((class_2394)emitter, x, y, z, (double)((float)facing.method_10148() * (attachFace == class_2738.field_12471 ? 0.05f : 0.3f)), attachFace == class_2738.field_12471 ? 0.5 : 0.0, (double)((float)facing.method_10165() * (attachFace == class_2738.field_12471 ? 0.05f : 0.3f)));
        level.method_8406((class_2394)emitter, x, y, z, (double)((float)facing.method_10148() * (attachFace == class_2738.field_12471 ? -0.05f : -0.3f)), attachFace == class_2738.field_12471 ? (double)-0.1f : 0.0, (double)((float)facing.method_10165() * (attachFace == class_2738.field_12471 ? -0.05f : -0.3f)));
    }

    @NotNull
    private static ParticleEmitterOptions getGrindstoneSparkEmitter(class_2738 attachFace, class_2350 facing) {
        float depth;
        float EMITTER_BOUND_WIDTH = 0.1f;
        float EMITTER_BOUND_LENGTH = 0.8f;
        float width = attachFace == class_2738.field_12471 ? 0.0f : 0.1f;
        float height = attachFace == class_2738.field_12471 ? 0.8f : 0.0f;
        float f = depth = attachFace == class_2738.field_12471 ? 0.0f : 0.1f;
        if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
            width = 0.1f;
            depth = attachFace == class_2738.field_12471 ? depth : 0.8f;
        } else if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
            width = attachFace == class_2738.field_12471 ? width : 0.8f;
            depth = 0.1f;
        }
        return new ParticleEmitterOptions(ModParticleTypes.FLYING_SPARK_EMITTER, ConfigHandler.maxGrindstoneUseSparks_onUse < 6 ? ConfigHandler.maxGrindstoneUseSparks_onUse : 6, 1, (int)Math.ceil((double)ConfigHandler.maxGrindstoneUseSparks_onUse / 6.0), width, height, depth);
    }

    public static void spawnBrushingParticles(class_638 level, BlockParticleOverride override, class_2680 blockState, class_2350 brushDirection, class_243 particlePos, int armDirection, int amountOfParticles, double baseDeltaX, double baseDeltaY, double baseDeltaZ) {
        double outwardVelocity = 0.05;
        for (int i = 0; i < amountOfParticles; ++i) {
            float velocityMultiplier;
            class_2400 particleOption;
            if (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_VANILLA || ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_DUST && override != BlockParticleOverride.VANILLA && override != BlockParticleOverride.NONE) {
                particleOption = override.getParticleOptionForState(blockState, level, class_2338.method_49638((class_2374)particlePos), 5);
                velocityMultiplier = override.getParticleVelocityMultiplier();
            } else {
                particleOption = ModParticleTypes.BRUSH_DUST;
                velocityMultiplier = 0.1f;
            }
            if (particleOption == null) continue;
            level.method_8406((class_2394)particleOption, particlePos.field_1352 + (double)brushDirection.method_10148() * 0.05, particlePos.field_1351 + (double)brushDirection.method_10164() * 0.05, particlePos.field_1350 + (double)brushDirection.method_10165() * 0.05, baseDeltaX * (double)armDirection * level.method_8409().method_43058() * (double)velocityMultiplier + (double)brushDirection.method_10148() * 0.05, (baseDeltaY + 1.0) * level.method_8409().method_43058() * (double)velocityMultiplier * (double)brushDirection.method_10164(), baseDeltaZ * (double)armDirection * level.method_8409().method_43058() * (double)velocityMultiplier + (double)brushDirection.method_10165() * 0.05);
        }
    }

    public static void spawnBlazeAmbientParticles(class_638 level, double x, double y, double z) {
        if (level.field_9229.method_43057() < (float)ConfigHandler.blaze_spawnChance / 100.0f) {
            float xVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            float yVel = MathHelpers.randomBetween(0.3f, 0.6f);
            float zVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            level.method_8406((class_2394)ModParticleTypes.FLOATING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }

    public static void spawnBlazeHurtParticles(class_638 level, double x, double y, double z) {
        if (!ConfigHandler.blaze_spawnOnHurt) {
            return;
        }
        for (int i = 0; i < level.field_9229.method_39332(ConfigHandler.blaze_amountToSpawnOnHurt <= 1 ? 1 : ConfigHandler.blaze_amountToSpawnOnHurt - 1, ConfigHandler.blaze_amountToSpawnOnHurt + 2); ++i) {
            float xVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            float yVel = MathHelpers.randomBetween(0.4f, 0.6f);
            float zVel = (float)MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            level.method_8406((class_2394)ModParticleTypes.FLYING_SPARK, x, y, z, (double)xVel, (double)yVel, (double)zVel);
        }
    }
}

