/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.shapes;

import games.enchanted.blockplaceparticles.util.MathHelpers;
import net.minecraft.class_4588;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class QuadFaceShape {
    protected final Vector3dc[] vertices;

    public QuadFaceShape(Vector3dc[] shapeVertices) {
        if (shapeVertices.length % 4 != 0) {
            throw new IllegalArgumentException("VertexShape must be initialised with a multiple of 4 vertices");
        }
        this.vertices = shapeVertices;
    }

    public Vector3dc[] getVertices() {
        return this.vertices;
    }

    public void renderShapeWithRotation(class_4588 vertexConsumer, Vector2f[] uvCoordinates, Vector3f pos, Vector3f scale, Vector3f rotation, float size, int lightColour, Vector4f colour) {
        if (uvCoordinates.length > 2) {
            throw new IllegalArgumentException("VertexShape#renderShape requires exactly 2 elements in uvCoordinates specifying the top left and top right uv coordinates");
        }
        float pitchRad = (float)Math.toRadians(rotation.x);
        float yawRad = (float)Math.toRadians(rotation.y);
        float rollRad = (float)Math.toRadians(rotation.z);
        for (int i = 0; i < this.vertices.length; i += 4) {
            Vector3d vertex1 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            Vector3d vertex2 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 1]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            Vector3d vertex3 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 2]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            Vector3d vertex4 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 3]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            this.renderVertex(vertexConsumer, vertex1, uvCoordinates[0].x, uvCoordinates[1].y, lightColour, colour);
            this.renderVertex(vertexConsumer, vertex2, uvCoordinates[0].x, uvCoordinates[0].y, lightColour, colour);
            this.renderVertex(vertexConsumer, vertex3, uvCoordinates[1].x, uvCoordinates[0].y, lightColour, colour);
            this.renderVertex(vertexConsumer, vertex4, uvCoordinates[1].x, uvCoordinates[1].y, lightColour, colour);
        }
    }

    public void renderShape(class_4588 vertexConsumer, Vector2f[] uvCoordinates, Vector3f pos, Vector3f scale, float size, int lightColour, Vector4f colour) {
        this.renderShapeWithRotation(vertexConsumer, uvCoordinates, pos, scale, new Vector3f(0.0f), size, lightColour, colour);
    }

    protected void renderVertex(class_4588 vertexConsumer, Vector3d vertexPos, float u, float v, int lightColor, Vector4f colour) {
        vertexConsumer.method_22912((float)vertexPos.x, (float)vertexPos.y, (float)vertexPos.z).method_22913(u, v).method_22915(colour.x, colour.y, colour.z, colour.w).method_60803(lightColor);
    }

    public static QuadFaceShape copyShape(QuadFaceShape shapeToCopy) {
        Vector3d[] copiedVerts = new Vector3d[shapeToCopy.getVertices().length];
        for (int i = 0; i < shapeToCopy.getVertices().length; ++i) {
            copiedVerts[i] = new Vector3d(shapeToCopy.getVertices()[i]);
        }
        return new QuadFaceShape((Vector3dc[])copiedVerts);
    }
}

