/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.util;

import games.enchanted.blockplaceparticles.mixin.accessor.SpriteContentsAccessor;
import games.enchanted.blockplaceparticles.util.MathHelpers;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.class_1058;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7764;

public class ColourUtil {
    private static final HashMap<class_2960, Integer> colourCache = new HashMap();

    public static int[] getAverageBlockColour(class_2680 blockState) {
        class_1058 particleSprite = class_310.method_1551().method_1541().method_3349(blockState).method_4711();
        class_2960 particleSpriteLocation = particleSprite.method_45851().method_45816();
        if (colourCache.containsKey(particleSpriteLocation)) {
            return ColourUtil.ARGBint_to_ARGB(colourCache.get(particleSpriteLocation));
        }
        int average = ColourUtil.calculateAverageSpriteColour(particleSprite);
        colourCache.put(particleSpriteLocation, average);
        return ColourUtil.ARGBint_to_ARGB(average);
    }

    public static int calculateAverageSpriteColour(class_1058 sprite) {
        if (sprite == null) {
            return -1;
        }
        class_7764 spriteContents = sprite.method_45851();
        if (spriteContents.method_45817().count() == 0L) {
            return -1;
        }
        float total = 0.0f;
        float red = 0.0f;
        float blue = 0.0f;
        float green = 0.0f;
        float alpha = 0.0f;
        for (int x = 0; x < spriteContents.method_45807(); ++x) {
            for (int y = 0; y < spriteContents.method_45815(); ++y) {
                int color = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage().method_4315(x, y);
                int[] argb = ColourUtil.ABGRint_to_RGBA(color);
                int pixelAlpha = argb[0];
                if (pixelAlpha <= 10) continue;
                total += 1.0f;
                alpha += (float)pixelAlpha;
                red += (float)argb[1];
                green += (float)argb[2];
                blue += (float)argb[3];
            }
        }
        float[] hsb = Color.RGBtoHSB((int)(red / total), (int)(green / total), (int)(blue / total), null);
        hsb[2] = hsb[2] * 1.05f;
        int[] rgb = ColourUtil.RGBint_to_RGB(Color.HSBtoRGB(Math.clamp(hsb[0], 0.0f, 1.0f), Math.clamp(hsb[1], 0.0f, 1.0f), Math.clamp(hsb[2], 0.0f, 1.0f)));
        return ColourUtil.ARGB_to_ARGBint((int)(alpha / total), rgb[0], rgb[1], rgb[2]);
    }

    public static int[] getRandomBlockColour(class_2680 blockState) {
        class_1058 particleSprite = class_310.method_1551().method_1541().method_3349(blockState).method_4711();
        class_7764 spriteContents = particleSprite.method_45851();
        int x = MathHelpers.randomBetween(0, spriteContents.method_45807() - 1);
        int y = MathHelpers.randomBetween(0, spriteContents.method_45815() - 1);
        int sampledColour = ((SpriteContentsAccessor)spriteContents).block_place_particle$getOriginalImage().method_4315(x, y);
        return ColourUtil.ABGRint_to_RGBA(sampledColour);
    }

    public static void invalidateCaches() {
        colourCache.clear();
    }

    public static int ARGB_to_ARGBint(int a, int r, int g, int b) {
        int alpha = MathHelpers.clampInt(a, 0, 255);
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int[] ARGBint_to_ARGB(int argb) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int[] ABGRint_to_RGBA(int abgr) {
        int a = abgr >> 24 & 0xFF;
        int b = abgr >> 16 & 0xFF;
        int g = abgr >> 8 & 0xFF;
        int r = abgr & 0xFF;
        return new int[]{a, r, g, b};
    }

    public static int RGB_to_RGBint(int r, int g, int b) {
        int red = MathHelpers.clampInt(r, 0, 255);
        int green = MathHelpers.clampInt(g, 0, 255);
        int blue = MathHelpers.clampInt(b, 0, 255);
        return red << 16 | green << 8 | blue;
    }

    public static int[] RGBint_to_RGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g, b};
    }
}

