/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.util;

import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MathHelpers {
    public static int clampInt(int val, int min, int max) {
        return Math.max(min, Math.min(max, val));
    }

    public static double expandWhenOutOfBound(double value, double minBound, double maxBound) {
        if (value >= maxBound) {
            return value + 0.005;
        }
        if (value <= minBound) {
            return value - 0.005;
        }
        return value;
    }

    public static double maxVec3(Vector3f vector, boolean abs) {
        if (abs) {
            vector = new Vector3f(Math.abs(vector.x), Math.abs(vector.y), Math.abs(vector.z));
        }
        return Math.max(Math.max(vector.x, vector.y), vector.z);
    }

    public static Vector3d rotate3DPoint(Vector3d point, float pitch, float yaw, float roll) {
        Quaternionf quaternionf = MathHelpers.eulerAnglesToQuaternion(pitch, yaw, roll);
        return quaternionf.transform(new Vector3d((Vector3dc)point));
    }

    public static Quaternionf eulerAnglesToQuaternion(float roll, float pitch, float yaw) {
        float cr = (float)Math.cos((double)roll * 0.5);
        float sr = (float)Math.sin((double)roll * 0.5);
        float cp = (float)Math.cos((double)pitch * 0.5);
        float sp = (float)Math.sin((double)pitch * 0.5);
        float cy = (float)Math.cos((double)yaw * 0.5);
        float sy = (float)Math.sin((double)yaw * 0.5);
        Quaternionf q = new Quaternionf();
        q.w = cr * cp * cy + sr * sp * sy;
        q.x = sr * cp * cy - cr * sp * sy;
        q.y = cr * sp * cy + sr * cp * sy;
        q.z = cr * cp * sy - sr * sp * cy;
        return q;
    }

    public static float getDistanceBetweenVectors(Vector3f pointA, Vector3f pointB) {
        return (float)new Vector3d((Vector3fc)pointA).distance((double)pointB.x, (double)pointB.y, (double)pointB.z);
    }

    public static Vector3f getPosBetween3DPoints(Vector3f pointA, Vector3f pointB) {
        float diffX = pointA.x - pointB.x;
        float diffY = pointA.y - pointB.y;
        float diffZ = pointA.z - pointB.z;
        return new Vector3f((Vector3fc)pointA).sub(diffX / 2.0f, diffY / 2.0f, diffZ / 2.0f);
    }

    public static double clampOutside(double value, double min, double max) {
        if (value > min && value < max) {
            double mid = (max - min) / 2.0 + min;
            return value < mid ? min : max;
        }
        return value;
    }

    public static float randomBetween(float min, float max) {
        return (float)(Math.random() * (double)(max - min)) + min;
    }

    public static int randomBetween(int min, int max) {
        return (int)Math.round(Math.random() * (double)(max - min) + (double)min);
    }

    public static float floorWithResolution(double number, double resolution) {
        return (float)(Math.floor(number * resolution) / resolution);
    }

    public static float ceilWithResolution(double number, double resolution) {
        return (float)(Math.ceil(number * resolution) / resolution);
    }

    public static float roundWithResolution(double number, double resolution) {
        return (float)((double)Math.round(number * resolution) / resolution);
    }
}

