/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.blockplaceparticles.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RegistryHelpers {
    public static <T> Stream<class_2960> getMatchingLocations(String search, class_7922<T> registryToSearch) {
        int separatorIndex = search.indexOf(58);
        String unspacedSearch = search.replace(' ', '_');
        Predicate<class_2960> filterPredicate = RegistryHelpers.getFilterPredicate(unspacedSearch, separatorIndex, registryToSearch);
        return registryToSearch.method_10235().stream().filter(filterPredicate).sorted((location1, location2) -> {
            String path = (separatorIndex == -1 ? unspacedSearch : unspacedSearch.substring(separatorIndex + 1)).toLowerCase();
            boolean location1StartsWith = location1.method_12832().toLowerCase().startsWith(path);
            boolean location2StartsWith = location2.method_12832().toLowerCase().startsWith(path);
            if (location1StartsWith) {
                return location2StartsWith ? location1.method_12833(location2) : -1;
            }
            return location2StartsWith ? 1 : location1.method_12833(location2);
        });
    }

    @NotNull
    private static <T> Predicate<class_2960> getFilterPredicate(String search, int separatorIndex, class_7922<T> registryToSearch) {
        Predicate<class_2960> filterPredicate;
        if (separatorIndex == -1) {
            filterPredicate = location -> location.method_12832().contains(search) || registryToSearch.method_10223(location).toString().toLowerCase().contains(search.toLowerCase());
        } else {
            String namespace = search.substring(0, separatorIndex);
            String path = search.substring(separatorIndex + 1);
            filterPredicate = location -> location.method_12836().equals(namespace) && location.method_12832().startsWith(path);
        }
        return filterPredicate;
    }

    public static class_3611 getDefaultedFluid(String location, class_3611 fallback) {
        try {
            class_2960 fluidLocation = class_2960.method_60654((String)location.toLowerCase());
            Optional fluidFromLoc = class_7923.field_41173.method_17966(fluidLocation);
            if (fluidFromLoc.isEmpty()) {
                return fallback;
            }
            if (fluidFromLoc.get() == class_3612.field_15906) {
                return fallback;
            }
            return (class_3611)fluidFromLoc.get();
        }
        catch (class_151 class_1512) {
            return fallback;
        }
    }

    public static class_2960 validateBlockLocationWithFallback(String location, class_2960 fallback) {
        try {
            class_2960 blockLocation = class_2960.method_60654((String)location.toLowerCase());
            Optional blockFromLoc = class_7923.field_41175.method_17966(blockLocation);
            if (blockFromLoc.isEmpty()) {
                return fallback;
            }
            if (((class_2248)blockFromLoc.get()).method_9564().method_26215()) {
                return fallback;
            }
            return blockLocation;
        }
        catch (class_151 class_1512) {
            return fallback;
        }
    }

    public static class_2960 validateFluidLocationWithFallback(String location, class_2960 fallback) {
        try {
            class_2960 fluidLocation = class_2960.method_60654((String)location.toLowerCase());
            Optional blockFromLoc = class_7923.field_41173.method_17966(fluidLocation);
            if (blockFromLoc.isEmpty()) {
                return fallback;
            }
            if (((class_3611)blockFromLoc.get()).method_15785().method_15759().method_26215()) {
                return fallback;
            }
            return fluidLocation;
        }
        catch (class_151 class_1512) {
            return fallback;
        }
    }

    public static class_2960 getLocationFromBlock(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static class_2248 getBlockFromLocation(class_2960 location) {
        return (class_2248)class_7923.field_41175.method_10223(location);
    }

    public static class_2960 getLocationFromFluid(class_3611 fluid) {
        return class_7923.field_41173.method_10221((Object)fluid);
    }

    public static class_3611 getFluidFromLocation(class_2960 location) {
        return (class_3611)class_7923.field_41173.method_10223(location);
    }
}

