package games.enchanted.eg_particle_interactions.common.particle;

import games.enchanted.eg_particle_interactions.common.shapes.QuadFaceShape;
import games.enchanted.eg_particle_interactions.common.shapes.ShapeDefinitions;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import org.jetbrains.annotations.NotNull;
import org.joml.*;

import java.lang.Math;
import net.minecraft.class_1058;
import net.minecraft.class_638;

public abstract class StretchyBouncyShapeParticle extends BouncyParticle {
    protected double prevPrevX;
    protected double prevPrevY;
    protected double prevPrevZ;
    private QuadFaceShape particleShape;
    /**
     * The scale that the particle will be rendered at
     */
    protected Vector3f particleShapeScale;
    protected float prevPitch;
    protected float prevYaw;

    /**
     * A 3d cube particle that stretches between its current and previous position when moving, this particle also has bounce physics
     * Set {@link #physics_canBounce} to false in your particle constructor to disable bouncing
     *
     * @param level  level
     * @param x      x pos
     * @param y      y pos
     * @param z      z pos
     * @param xSpeed x velocity
     * @param ySpeed y velocity
     * @param zSpeed z velocity
     */
    protected StretchyBouncyShapeParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;
        this.field_28787 = true;

        this.particleShapeScale = new Vector3f(1);
        this.setShape(ShapeDefinitions.CUBE);
    }

    @Override
    public void method_3070() {
        this.prevPrevX = this.field_3858;
        this.prevPrevY = this.field_3838;
        this.prevPrevZ = this.field_3856;

        super.method_3070();
    }

    /**
     * Sets the shape that the particle will use to render
     *
     * @param newShape the new shape
     */
    protected void setShape(QuadFaceShape newShape) {
        this.particleShape = newShape;
    }

    protected boolean isParticleMoving() {
        return this.getTotalVelocity() < 0.001;
    }

    @Override
    public @NotNull BillboardMode getBillboardMode() {
        return BillboardMode.FIXED;
    }

    // TODO: rendering
//    @Override
//    protected void renderRotatedQuad(@NotNull VertexConsumer consumer, @NotNull Camera camera, @NotNull Quaternionf quaternionf, float d) {
//        Vector3f cameraPosition = camera.getPosition().toVector3f();
//
//        float xPos = (float) Mth.lerp(d, this.xo, this.x);
//        float yPos = (float) Mth.lerp(d, this.yo, this.y);
//        float zPos = (float) Mth.lerp(d, this.zo, this.z);
//        Vector3f pos = new Vector3f(xPos, yPos, zPos).sub(cameraPosition);
//        float prevXPos = (float) Mth.lerp(d, this.prevPrevX, this.xo);
//        float prevYPos = (float) Mth.lerp(d, this.prevPrevY, this.yo);
//        float prevZPos = (float) Mth.lerp(d, this.prevPrevZ, this.zo);
//        Vector3f prevPos = new Vector3f(prevXPos, prevYPos, prevZPos).sub(cameraPosition);
//
//        this.renderCubeGeometry(consumer, pos, prevPos, d);
//    }

//    private void renderCubeGeometry(@NotNull VertexConsumer consumer, Vector3f pos, Vector3f prevPos, float d) {
//        float cuboidSize = this.getScale();
//        float u0 = this.getU0();
//        float u1 = this.getU1();
//        float v0 = this.getV0();
//        float v1 = this.getV1();
//        int lightColor = this.getLightColor(d);
//
//        Vector3f normalisedMovementDir = new Vector3f(pos).sub(prevPos).normalize();
//        float pitch = (float) Math.toDegrees(Math.asin(normalisedMovementDir.y));
//        if(!Float.isFinite(pitch)) pitch = prevPitch;
//        prevPitch = pitch;
//
//        float yaw = (float) Math.toDegrees(Math.atan2(normalisedMovementDir.x, normalisedMovementDir.z));
//        if(!Float.isFinite(yaw)) yaw = prevYaw;
//        prevYaw = yaw;
//
//        Vector3f shapePos = MathHelpers.getPosBetween3DPoints(pos, prevPos);
//        Vector3f shapeScale = new Vector3f(1, Math.max(Math.abs(MathHelpers.getDistanceBetweenVectors(pos, prevPos) * 40), 1), 1).mul(this.particleShapeScale);
//        Vector3f shapeRotation = new Vector3f(-(pitch - 90), yaw, 0);
//        this.particleShape.renderShapeWithRotation(
//            consumer,
//            new Vector2f[]{new Vector2f(u0, v0), new Vector2f(u1, v1)},
//            shapePos,
//            shapeScale,
//            shapeRotation,
//            cuboidSize,
//            lightColor,
//            ColourUtil.ARGBfloats_to_ARGB(this.alpha, this.rCol, this.gCol, this.bCol)
//        );
//    }
}
