package games.enchanted.eg_particle_interactions.common.particle.dust;

import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class BasicDust extends AbstractDust {
    private final Supplier<@Nullable class_2394> speckGetter;

    protected BasicDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_4002 spriteSet, float gravityMultiplier, boolean spawnSpecks, boolean spriteFromAge, Supplier<@Nullable class_2394> speckGetter) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks);
        this.spriteFromAge = spriteFromAge;
        this.speckGetter = speckGetter;
    }

    @Override
    protected @Nullable class_2394 getSpeckParticle() {
        return speckGetter.get();
    }

    public static class SnowflakeProvider implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public SnowflakeProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            BasicDust particle = new BasicDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 1.1f, true, true, () -> ModParticleTypes.SNOWFLAKE_SPECK);
            particle.emissive = true;
            return particle;
        }
    }
    public static class SnowflakeSpeckProvider implements class_707<class_2400>  {
        private final class_4002 spriteSet;

        public SnowflakeSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2400 options,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            BasicDust particle = new BasicDust(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, 0.7f, false, false, () -> null);
            particle.emissive = true;
            return particle;
        }
    }
}
