package games.enchanted.eg_particle_interactions.common.particle_spawning;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.config.type.BrushParticleBehaviour;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.option.ArcEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.option.DripParticleOption;
import games.enchanted.eg_particle_interactions.common.particle.option.RandomDistributionEmitterOptions;
import games.enchanted.eg_particle_interactions.common.particle.option.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverrides;
import games.enchanted.eg_particle_interactions.common.particle_override.FluidPlacementParticle;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.registry.TagUtil;
import games.enchanted.eg_particle_interactions.common.util.FluidHelpers;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3713;
import net.minecraft.class_3865;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SpawnParticles {
    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos) {
        class_2680 placedBlockState = level.method_8320(blockPos);
        spawnBlockPlaceParticle(level, blockPos, placedBlockState);
    }

    public static void spawnBlockPlaceParticle(class_638 level, class_2338 blockPos, class_2680 placedBlockState) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, blockPos)) return;
        if (ConfigHandler.underwaterBubbles_onPlace) spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onPlace, level, blockPos);

        int overrideOrigin = BlockParticleOverride.ORIGIN_BLOCK_PLACED;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(placedBlockState, overrideOrigin);
        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }

        int maxParticlesPerEdge = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, true);
        if (maxParticlesPerEdge <= 0) return;

        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();

        if (!placedBlockState.method_26215() && placedBlockState.method_45475()) {
            class_265 blockShape = placedBlockState.method_26218(level, blockPos);
            if(blockShape.method_1110()) return;
            class_243 blockCenter = blockShape.method_1107().method_1005();
            double verticalAxisOffset = level.method_8320(blockPos.method_10069(0, -1, 0)).method_51367() ? 0.01 : 0; // move particles up out the block below them if it is solid
            blockShape.method_1104((x1, y1, z1, x2, y2, z2) -> {
                double width = Math.abs(x1 - x2);
                double height = Math.abs(y1 - y2);
                double depth = Math.abs(z1 - z2);

                double edgeLength;
                class_2350.class_2351 biggestEdge;
                if (width > height && width > depth) {
                    edgeLength = width;
                    biggestEdge = class_2350.class_2351.field_11048;
                } else if (height > width && height > depth) {
                    edgeLength = height;
                    biggestEdge = class_2350.class_2351.field_11052;
                } else {
                    edgeLength = depth;
                    biggestEdge = class_2350.class_2351.field_11051;
                }

                int amountOfParticlesAlongEdge = class_3532.method_15384(edgeLength * maxParticlesPerEdge);
                if (amountOfParticlesAlongEdge < 1)
                    amountOfParticlesAlongEdge = 1; // always try to spawn at least 1 particle per edge

                for (int i = 0; i < amountOfParticlesAlongEdge; ++i) {
                    double particlePos = ((double) i + 0.5) / (double) amountOfParticlesAlongEdge;
                    if (particlePos > edgeLength + (double) 1 / 16) continue;
                    double particleXOffset = (biggestEdge == class_2350.class_2351.field_11048 ? particlePos : width) + x1;
                    double particleYOffset = (biggestEdge == class_2350.class_2351.field_11052 ? particlePos : height) + y1 + verticalAxisOffset;
                    double particleZOffset = (biggestEdge == class_2350.class_2351.field_11051 ? particlePos : depth) + z1;

                    class_2394 particleToSpawn = particleOverride.getParticleOptionForState(placedBlockState, level, blockPos, overrideOrigin);
                    if (particleToSpawn == null) {
                        continue;
                    }
                    level.method_8406(
                        particleToSpawn,
                        (double) blockPos.method_10263() + MathHelpers.expandWhenOutOfBound(particleXOffset, 0, 1),
                        (double) blockPos.method_10264() + MathHelpers.expandWhenOutOfBound(particleYOffset, 0, 1),
                        (double) blockPos.method_10260() + MathHelpers.expandWhenOutOfBound(particleZOffset, 0, 1),
                        (particleXOffset - blockCenter.method_10216()) * particleOutwardVelocityAdjustment,
                        (particleYOffset - blockCenter.method_10214()) * particleOutwardVelocityAdjustment,
                        (particleZOffset - blockCenter.method_10215()) * particleOutwardVelocityAdjustment
                    );
                }
            });
        }
    }

    public static void spawnBlockBreakParticle(class_638 level, class_2680 brokenBlockState, class_2338 brokenBlockPos, BlockParticleOverride particleOverride) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, brokenBlockPos)) return;
        if (ConfigHandler.underwaterBubbles_onBreak) spawnUnderwaterBubbles(ConfigHandler.maxUnderwaterBubbles_onBreak, level, brokenBlockPos);

        if (particleOverride == BlockParticleOverride.NONE) {
            return;
        }

        int maxParticlesPerLength = BlockParticleOverride.getParticleMultiplierForOverride(particleOverride, false);
        if (maxParticlesPerLength <= 0) return;

        double particleOutwardVelocityAdjustment = particleOverride.getParticleVelocityMultiplier();

        if (!brokenBlockState.method_26215() && brokenBlockState.method_45475()) {
            class_265 blockShape = brokenBlockState.method_26218(level, brokenBlockPos);
            if(blockShape.method_1110()) return;
            class_243 blockCenter = blockShape.method_1107().method_1005();
            blockShape.method_1089((x1, y1, z1, x2, y2, z2) -> {
                double width = Math.abs(x1 - x2);
                int amountAlongWidth = Math.clamp(class_3532.method_15384(width * maxParticlesPerLength), 1, 999);
                double height = Math.abs(y1 - y2);
                int amountAlongHeight = Math.clamp(class_3532.method_15384(height * maxParticlesPerLength), 1, 999);
                double depth = Math.abs(z1 - z2);
                int amountAlongDepth = Math.clamp(class_3532.method_15384(depth * maxParticlesPerLength), 1, 999);

                for (int i_W = 0; i_W < amountAlongWidth; ++i_W) {
                    for (int i_H = 0; i_H < amountAlongHeight; ++i_H) {
                        for (int i_D = 0; i_D < amountAlongDepth; ++i_D) {
                            double particleXOffset = (((double) i_W + 0.5) / (double) amountAlongWidth);
                            double particleYOffset = (((double) i_H + 0.5) / (double) amountAlongHeight);
                            double particleZOffset = (((double) i_D + 0.5) / (double) amountAlongDepth);

                            class_2394 particleToSpawn = particleOverride.getParticleOptionForState(brokenBlockState, level, brokenBlockPos, BlockParticleOverride.ORIGIN_BLOCK_BROKEN);
                            if (particleToSpawn == null) {
                                continue;
                            }

                            level.method_8406(
                                particleToSpawn,
                                brokenBlockPos.method_10263() + (particleXOffset * width + x1),
                                brokenBlockPos.method_10264() + (particleYOffset * height + y1),
                                brokenBlockPos.method_10260() + (particleZOffset * depth + z1),
                                (particleXOffset - blockCenter.method_10216()) * particleOutwardVelocityAdjustment,
                                (particleYOffset - blockCenter.method_10214()) * particleOutwardVelocityAdjustment,
                                (particleZOffset - blockCenter.method_10215()) * particleOutwardVelocityAdjustment
                            );
                        }
                    }
                }
            });
        }
    }

    private static void spawnUnderwaterBubbles(int amountOfBubbles, class_1937 level, class_2338 blockPos) {
        if (!FluidHelpers.probablyPlacedUnderwater(level, blockPos)) return;
        for (int i = 0; i < Math.max(amountOfBubbles + level.field_9229.method_39332(-2, 0), 1); i++) {
            double x = level.field_9229.method_43058();
            double y = level.field_9229.method_43058();
            double z = level.field_9229.method_43058();
            boolean blockAboveIsWater = level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517);
            double verticalVelocity = (y - 0.5) * (blockAboveIsWater ? 2 : 0);
            double horizontalVelocityMul = !blockAboveIsWater ? 1.5 : 1;
            level.method_8406(
                ModParticleTypes.UNDERWATER_RISING_BUBBLE,
                blockPos.method_10263() + x,
                blockPos.method_10264() + y,
                blockPos.method_10260() + z,
                (x - 0.5) * 2 * horizontalVelocityMul,
                level.method_8320(blockPos.method_10074()).method_51367() ? Math.abs(verticalVelocity) + 0.1 : verticalVelocity,
                (z - 0.5) * 2 * horizontalVelocityMul
            );
        }
    }

    public static void spawnFallingBlockRandomFallParticles(class_638 level, class_2680 blockState, double x, double y, double z, class_243 deltaMovement) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) return;
        if (!ConfigHandler.fallingBlockEffect_enabled) return;
        if (blockState.method_26215()) return;

        int overrideOrigin = BlockParticleOverride.ORIGIN_FALLING_BLOCK_FALLING;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);

        if (particleOverride == BlockParticleOverride.NONE || particleOverride == BlockParticleOverride.VANILLA) return;

        for (int i = 0; i < level.field_9229.method_39332(1, 4); i++) {
            class_2394 particleOptions = particleOverride.getParticleOptionForState(blockState, level, class_2338.method_49637(x, y, z), overrideOrigin);
            if (particleOptions == null) continue;
            level.method_8406(
                particleOptions,
                x - 0.5 + level.field_9229.method_43057(),
                y + level.field_9229.method_43057(),
                z - 0.5 + level.field_9229.method_43057(),
                (deltaMovement.field_1352 * 3) * -particleOverride.getParticleVelocityMultiplier(),
                (deltaMovement.field_1351 * 3) * -particleOverride.getParticleVelocityMultiplier(),
                (deltaMovement.field_1350 * 3) * -particleOverride.getParticleVelocityMultiplier()
            );
        }
    }

    public static void spawnFallingBlockLandParticles(class_638 level, class_2680 blockState, double x, double y, double z, class_243 deltaMovement) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) return;
        if (!ConfigHandler.fallingBlockEffect_enabled) return;

        int overrideOrigin = BlockParticleOverride.ORIGIN_FALLING_BLOCK_LANDED;
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);

        if (particleOverride == BlockParticleOverride.NONE) return;

        class_2338 blockPos = class_2338.method_49637(x, y, z);
        double movementSpeed = deltaMovement.method_1033();

        double particleY = Math.round((y + (deltaMovement.field_1351 / 2)) - 0.1) + 0.0625;

        SpawnParticlesUtil.spawnParticleInCircle(
            particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin),
            level,
            new class_243(x, particleY, z),
            16,
            0.4f,
            0.9f,
            1.7f * (float) (movementSpeed * 2) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()),
            0.035f,
            0
        );

        SpawnParticlesUtil.spawnParticleInCircle(
            particleOverride == BlockParticleOverride.VANILLA ? TintedParticleOption.BRUSH_OPTION : particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin),
            level,
            new class_243(x, particleY + 0.7f, z),
            16,
            0.3f,
            0.95f,
            0.2f,
            -0.4f * (float) (movementSpeed * 2) * (particleOverride == BlockParticleOverride.VANILLA ? 0.1f : particleOverride.getParticleVelocityMultiplier()),
            0
        );
    }

    public static void spawnSparksAtMinecartWheels(double minecartX, double minecartY, double minecartZ, double minecartHorizontalRot, double minecartVerticalRot, boolean isOnRails, boolean hasPassenger, boolean hasBlock, class_243 deltaMovement, double maxSpeed, class_1937 level) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, minecartX, minecartY, minecartZ)) return;
        if (!ConfigHandler.minecart_enabled) return;
        if (!isOnRails) return;
        if (!(hasBlock || hasPassenger) && ConfigHandler.minecart_onlyWithPassenger) return;

        double speed = MathHelpers.maxVec3(deltaMovement.method_46409(), true);
        if (speed < 0.05) return;

        float sparksChancePerWheel = (float) (Math.clamp(speed, 0, maxSpeed) / maxSpeed) - 0.75f;
        sparksChancePerWheel *= ConfigHandler.minecart_spawnChance / 50f;

        float rotX = (float) ((minecartHorizontalRot) * (Math.PI / 180));
        float rotY = (float) ((minecartVerticalRot) * (Math.PI / 180));
        float sparkDeltaX = (float) Math.clamp(-deltaMovement.field_1352 / 3, -0.7, 0.7);
        float sparkDeltaZ = (float) Math.clamp(-deltaMovement.field_1350 / 3, -0.7, 0.7);

        minecartY += 0.0425;
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos1 = minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, 0.45f);
            level.method_8406(ModParticleTypes.FLYING_SPARK, wheelPos1.x + minecartX, wheelPos1.y + minecartY, wheelPos1.z + minecartZ, sparkDeltaX, 0.17, sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos2 = minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, 0.45f);
            level.method_8406(ModParticleTypes.FLYING_SPARK, wheelPos2.x + minecartX, wheelPos2.y + minecartY, wheelPos2.z + minecartZ, sparkDeltaX, 0.17, sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos3 = minecartWheelPoint(rotX, rotY, 0.45f, 0.35f, -0.45f);
            level.method_8406(ModParticleTypes.FLYING_SPARK, wheelPos3.x + minecartX, wheelPos3.y + minecartY, wheelPos3.z + minecartZ, sparkDeltaX, 0.17, sparkDeltaZ);
        }
        if (level.field_9229.method_43057() < sparksChancePerWheel) {
            Vector3f wheelPos4 = minecartWheelPoint(rotX, rotY, -0.45f, -0.35f, -0.45f);
            level.method_8406(ModParticleTypes.FLYING_SPARK, wheelPos4.x + minecartX, wheelPos4.y + minecartY, wheelPos4.z + minecartZ, sparkDeltaX, 0.17, sparkDeltaZ);
        }
    }

    private static Vector3f minecartWheelPoint(float rotationX, float rotationY, float pointX, float pointY, float pointZ) {
        return new Vector3f((float) (pointX * Math.cos(rotationX) - pointZ * Math.sin(rotationX)), pointY * rotationY, (float) (pointZ * Math.cos(rotationX) + pointX * Math.sin(rotationX)));
    }

    public static void spawnFlintAndSteelSparkParticle(class_1937 level, class_2338 particlePos) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) return;
        if (!ConfigHandler.flintAndSteelSpark_onUse) return;
        class_2680 fireOrLitBlock = level.method_8320(particlePos);
        boolean isSoulBlock = level.method_8320(particlePos.method_10074()).method_26164(class_3481.field_23119) || fireOrLitBlock.method_27852(class_2246.field_23860);
        double sparkIntensity = ConfigHandler.flintAndSteelSpark_intensity / 12.;
        for (int i = 0; i < ConfigHandler.maxFlintAndSteelSpark_onUse; i++) {
            double x = particlePos.method_10263() + 0.25 + (level.field_9229.method_43058() / 2);
            double y = particlePos.method_10264() + 0.25 + (level.field_9229.method_43058() / 2);
            double z = particlePos.method_10260() + 0.25 + (level.field_9229.method_43058() / 2);
            level.method_8406(isSoulBlock ? ModParticleTypes.FLYING_SOUL_SPARK : ModParticleTypes.FLYING_SPARK, x, y, z, (level.field_9229.method_43058() - 0.5) * sparkIntensity, (level.field_9229.method_43058() + 0.5) * sparkIntensity, (level.field_9229.method_43058() - 0.5) * sparkIntensity);
        }
    }

    public static void spawnAmbientCampfireSparks(class_1937 level, class_2338 particlePos, class_2680 campfireState) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) return;
        if (ConfigHandler.campfireSpark_enabled) {
            double sparkIntensity = 5 / 12.;
            if (level.field_9229.method_43057() * 101 <= ConfigHandler.campfireSpark_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; i++) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(
                        level,
                        campfireState.method_27852(class_2246.field_23860) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK,
                        (double) particlePos.method_10263() + 0.5,
                        (double) particlePos.method_10264() + 0.5,
                        (double) particlePos.method_10260() + 0.5,
                        sparkIntensity
                    );
                }
            }
        }
        if (ConfigHandler.campfireEmber_enabled) {
            if (level.field_9229.method_43057() * 101 <= ConfigHandler.campfireEmber_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 4); i++) {
                    level.method_8406(
                        campfireState.method_27852(class_2246.field_23860) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER,
                        (double) particlePos.method_10263() + (level.field_9229.method_43057() * 0.75) + 0.125f,
                        (double) particlePos.method_10264() + (level.field_9229.method_43057() * 0.75) + 0.125f,
                        (double) particlePos.method_10260() + (level.field_9229.method_43057() * 0.75) + 0.125f,
                        0,
                        0,
                        0
                    );
                }
            }
        }
    }

    public static void spawnAmbientFireSparks(class_1937 level, class_2680 fireState, class_2338 particlePos, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, particlePos)) return;
        double width = Math.abs(minX - maxX);
        double height = Math.abs(minY - maxY);
        double depth = Math.abs(minZ - maxZ);
        if (ConfigHandler.fireSpark_enabled) {
            double sparkIntensity = 5 / 12.;
            if (level.field_9229.method_43057() * 101 <= ConfigHandler.fireSpark_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 3) + 1; i++) {
                    SpawnParticlesUtil.spawnMostlyUpwardsMotionParticleOption(
                        level,
                        fireState.method_27852(class_2246.field_22089) ? ModParticleTypes.FLOATING_SOUL_SPARK : ModParticleTypes.FLOATING_SPARK,
                        particlePos.method_10263() + minX + (level.field_9229.method_43057() * width),
                        particlePos.method_10264() + minY + (level.field_9229.method_43057() * height),
                        particlePos.method_10260() + minZ + (level.field_9229.method_43057() * depth),
                        sparkIntensity
                    );
                }
            }
        }
        if (ConfigHandler.fireEmber_enabled) {
            if (level.field_9229.method_43057() * 101 <= ConfigHandler.fireEmber_spawnChance) {
                for (int i = 0; i < level.field_9229.method_39332(1, 4); i++) {
                    level.method_8406(
                        fireState.method_27852(class_2246.field_22089) ? ModParticleTypes.FLOATING_SOUL_EMBER : ModParticleTypes.FLOATING_EMBER,
                        particlePos.method_10263() + minX + (level.field_9229.method_43057() * width),
                        particlePos.method_10264() + minY + (level.field_9229.method_43057() * height),
                        particlePos.method_10260() + minZ + (level.field_9229.method_43057() * depth),
                        0,
                        0,
                        0
                    );
                }
            }
        }
    }

    public static void spawnFireChargeSmokeParticle(class_1937 level, class_2338 particlePos) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos)) return;
        if (!ConfigHandler.fireCharge_onUse) return;
        double lavaIntensity = ConfigHandler.fireCharge_intensity / 24.;
        double smokeIntensity = ConfigHandler.fireCharge_intensity / 58.;
        for (int i = 0; i < ConfigHandler.maxFireCharge_onUse; i++) {
            double x = particlePos.method_10263() + 0.25 + (level.field_9229.method_43058() / 2);
            double y = particlePos.method_10264() + 0.25 + (level.field_9229.method_43058() / 2);
            double z = particlePos.method_10260() + 0.25 + (level.field_9229.method_43058() / 2);
            if (level.field_9229.method_43057() > 0.2) {
                level.method_8406(level.field_9229.method_43057() > 0.3 ? class_2398.field_11251 : class_2398.field_11237, x, y, z, (level.field_9229.method_43058() - 0.5) * smokeIntensity, (level.field_9229.method_43058() + 0.5) * smokeIntensity, (level.field_9229.method_43058() - 0.5) * smokeIntensity);
                continue;
            }
            level.method_8406(class_2398.field_11239, x, y, z, (level.field_9229.method_43058() - 0.5) * lavaIntensity, (level.field_9229.method_43058() + 0.5) * lavaIntensity, (level.field_9229.method_43058() - 0.5) * lavaIntensity);
        }
    }

    public static void spawnHoeTillParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        if (!ConfigHandler.hoeTill_onUse) return;
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxHoeTill_onUse; i++) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10165());
            class_2394 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406(
                blockParticle,
                clickedPosition.field_1352 + x,
                clickedPosition.field_1351 + y,
                clickedPosition.field_1350 + z,
                clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5)
            );
        }
    }

    public static void spawnShovelFlattenParticle(class_1937 level, class_2338 blockPos, class_1838 context) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        if (!ConfigHandler.shovelFlatten_onUse) return;
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxShovelFlatten_onUse; i++) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10165());
            class_2394 blockParticle = new class_2388(class_2398.field_11217, level.method_8320(blockPos));
            level.method_8406(
                blockParticle,
                clickedPosition.field_1352 + x,
                clickedPosition.field_1351 + y,
                clickedPosition.field_1350 + z,
                clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5)
            );
        }
    }

    public static void spawnAxeStripParticle(class_1937 level, class_2338 blockPos, class_2680 unstrippedBlockState, class_2680 strippedBlockState, class_1838 context) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        if (!ConfigHandler.axeStrip_onUse) return;
        class_243 clickedPosition = context.method_17698();
        class_2350 clickDirection = context.method_8038();
        for (int i = 0; i < ConfigHandler.maxAxeStrip_onUse; i++) {
            double x = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10148());
            double y = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10164());
            double z = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 - clickDirection.method_10165());
            class_2394 blockParticle = level.field_9229.method_43057() > 0.9 ? new class_2388(class_2398.field_11217, strippedBlockState) : new class_2388(class_2398.field_11217, unstrippedBlockState);
            level.method_8406(
                blockParticle,
                clickedPosition.field_1352 + x,
                clickedPosition.field_1351 + y,
                clickedPosition.field_1350 + z,
                clickDirection.method_10148() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10164() + (level.field_9229.method_43058() - 0.5),
                clickDirection.method_10165() + (level.field_9229.method_43058() - 0.5)
            );
        }
    }

    public static void spawnFluidPlacedParticle(class_1936 levelAccessor, class_2338 particlePos, class_3611 placedFluid) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.BLOCK_PLACE_OR_BREAK, particlePos)) return;
        if (placedFluid.method_15780(class_3612.field_15906)) {
            return;
        }

        FluidPlacementParticle particleOverride = FluidPlacementParticle.getParticleForFluid(placedFluid);

        class_2394 particleOption;
        if (particleOverride == FluidPlacementParticle.NONE) {
            return;
        } else if (particleOverride.isBlockStateParticle()) {
            particleOption = particleOverride.getBlockParticleOption(placedFluid.method_15785().method_15759());
        } else {
            particleOption = particleOverride.getParticleOption();
        }

        if (particleOption == null) return;

        int maxParticles = FluidPlacementParticle.getParticleMultiplier(particleOverride, true);

        for (int i = 0; i < maxParticles; i++) {
            double x = particlePos.method_10263() + levelAccessor.method_8409().method_43058();
            double y = particlePos.method_10264() + (levelAccessor.method_8409().method_43058() / 1.5) + 0.6;
            double z = particlePos.method_10260() + levelAccessor.method_8409().method_43058();
            levelAccessor.method_8406(particleOption, x, y, z, 0.0, 0.21, 0.0);
        }
    }

    public static void spawnAnvilUseSparkParticles(class_638 level, class_2338 blockPos) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        if (!ConfigHandler.anvilUseSparks_enabled) return;
        double x = blockPos.method_10263() + 0.5f;
        double y = blockPos.method_10264() + 1. + (level.field_9229.method_43058() / 16f);
        double z = blockPos.method_10260() + 0.5f;
        RandomDistributionEmitterOptions emitter = new RandomDistributionEmitterOptions(
            ModParticleTypes.FLYING_SPARK_EMITTER,
            3,
            7,
            1,
            new Vector3f(0.25f, 0, 0.25f)
        );
        SpawnParticlesUtil.spawnParticleInCircle(
            emitter,
            level,
            new class_243(x, y, z),
            ConfigHandler.maxAnvilUseSparks_onUse,
            0.32f,
            0.16f,
            2f,
            0.2f,
            2f
        );
    }

    public static void spawnGrindstoneUseSparkParticles(class_638 level, class_2338 blockPos) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        if (!ConfigHandler.grindstoneUseSparks_enabled) return;
        class_2680 grindstoneState = level.method_8320(blockPos);
        if (!(grindstoneState.method_26204() instanceof class_3713)) return;
        class_2350 facing = grindstoneState.method_11654(class_3713.field_11177);
        class_2738 attachFace = grindstoneState.method_11654(class_3713.field_11007);

        double x;
        double y;
        double z;
        if (attachFace == class_2738.field_12471) {
            x = blockPos.method_10263() + 0.5f + (facing.method_10148() / 1.9);
            y = blockPos.method_10264() + 0.5f;
            z = blockPos.method_10260() + 0.5f + (facing.method_10165() / 1.9);
        } else {
            x = blockPos.method_10263() + 0.5f;
            y = blockPos.method_10264() + (attachFace == class_2738.field_12473 ? 0 : 1.05f);
            z = blockPos.method_10260() + 0.5f;
        }

        RandomDistributionEmitterOptions emitter = getGrindstoneSparkEmitter(attachFace, facing);
        final float HORIZONTAL_MIN_SPEED = 0.05f;
        final float HORIZONTAL_MAX_SPEED = 0.3f;
        final float UPWARDS_SPEED = 0.5f;
        final float DOWNWARDS_SPEED = 0.1f;
        level.method_8406(
            emitter,
            x,
            y,
            z,
            facing.method_10148() * (attachFace == class_2738.field_12471 ? HORIZONTAL_MIN_SPEED : HORIZONTAL_MAX_SPEED),
            attachFace == class_2738.field_12471 ? UPWARDS_SPEED : 0,
            facing.method_10165() * (attachFace == class_2738.field_12471 ? HORIZONTAL_MIN_SPEED : HORIZONTAL_MAX_SPEED)
        );
        level.method_8406(
            emitter,
            x,
            y,
            z,
            facing.method_10148() * (attachFace == class_2738.field_12471 ? -HORIZONTAL_MIN_SPEED : -HORIZONTAL_MAX_SPEED),
            attachFace == class_2738.field_12471 ? -DOWNWARDS_SPEED : 0,
            facing.method_10165() * (attachFace == class_2738.field_12471 ? -HORIZONTAL_MIN_SPEED : -HORIZONTAL_MAX_SPEED)
        );
    }

    private static @NotNull RandomDistributionEmitterOptions getGrindstoneSparkEmitter(class_2738 attachFace, class_2350 facing) {
        final float EMITTER_BOUND_WIDTH = 0.1f;
        final float EMITTER_BOUND_LENGTH = 0.8f;

        float width = attachFace == class_2738.field_12471 ? 0 : EMITTER_BOUND_WIDTH;
        float height = attachFace == class_2738.field_12471 ? EMITTER_BOUND_LENGTH : 0;
        float depth = attachFace == class_2738.field_12471 ? 0 : EMITTER_BOUND_WIDTH;

        if (facing == class_2350.field_11043 || facing == class_2350.field_11035) {
            width = EMITTER_BOUND_WIDTH;
            depth = attachFace == class_2738.field_12471 ? depth : EMITTER_BOUND_LENGTH;
        } else if (facing == class_2350.field_11034 || facing == class_2350.field_11039) {
            width = attachFace == class_2738.field_12471 ? width : EMITTER_BOUND_LENGTH;
            depth = EMITTER_BOUND_WIDTH;
        }

        return new RandomDistributionEmitterOptions(
            ModParticleTypes.FLYING_SPARK_EMITTER,
            ConfigHandler.maxGrindstoneUseSparks_onUse < 6 ? ConfigHandler.maxGrindstoneUseSparks_onUse : 6,
            1,
            (int) Math.ceil((double) ConfigHandler.maxGrindstoneUseSparks_onUse / 6),
            new Vector3f(width, height, depth)
        );
    }

    public static void spawnBrushingParticles(class_638 level, BlockParticleOverride override, class_2680 blockState, class_2350 brushDirection, class_243 particlePos, int armDirection, int amountOfParticles, double baseDeltaX, double baseDeltaY, double baseDeltaZ) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215())) return;
        final double outwardVelocity = 0.05;

        for (int i = 0; i < amountOfParticles; i++) {
            class_2394 particleOption;
            float velocityMultiplier;

            // use dust particles if brush particle behaviour is "block override + dust" and particle override is none or vanilla,
            // otherwise spawn block override particles
            if (
                ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_VANILLA ||
                    (ConfigHandler.brushParticleBehaviour == BrushParticleBehaviour.BLOCK_OVERRIDE_OR_DUST && !(override == BlockParticleOverride.VANILLA || override == BlockParticleOverride.NONE))
            ) {
                particleOption = override.getParticleOptionForState(blockState, level, class_2338.method_49638(particlePos), BlockParticleOverride.ORIGIN_BLOCK_BRUSHED);
                velocityMultiplier = override.getParticleVelocityMultiplier();
            } else {
                particleOption = TintedParticleOption.BRUSH_OPTION;
                velocityMultiplier = 0.1f;
            }

            if (particleOption == null) continue;

            level.method_8406(
                particleOption,
                particlePos.field_1352 + (brushDirection.method_10148() * 0.05),
                particlePos.field_1351 + (brushDirection.method_10164() * 0.05),
                particlePos.field_1350 + (brushDirection.method_10165() * 0.05),
                (baseDeltaX * (double) armDirection * level.method_8409().method_43058() * velocityMultiplier) + (brushDirection.method_10148() * outwardVelocity),
                (baseDeltaY + 1) * level.method_8409().method_43058() * velocityMultiplier * brushDirection.method_10164(),
                (baseDeltaZ * (double) armDirection * level.method_8409().method_43058() * velocityMultiplier) + (brushDirection.method_10165() * outwardVelocity)
            );
        }
    }

    public static void spawnBlazeAmbientParticles(class_638 level, double x, double y, double z) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) return;
        if (level.field_9229.method_43057() < (float) ConfigHandler.blaze_spawnChance / 100) {
            float xVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            float yVel = MathHelpers.randomBetween(0.3f, 0.6f);
            float zVel = MathHelpers.randomBetween(-0.2f, 0.2f);
            level.method_8406(ModParticleTypes.FLOATING_SPARK, x, y, z, xVel, yVel, zVel);
        }
    }

    public static void spawnBlazeHurtParticles(class_638 level, double x, double y, double z) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) return;
        if (!ConfigHandler.blaze_spawnOnHurt) return;
        for (int i = 0; i < level.field_9229.method_39332(
            ConfigHandler.blaze_amountToSpawnOnHurt <= 1 ? 1 : ConfigHandler.blaze_amountToSpawnOnHurt - 1,
            ConfigHandler.blaze_amountToSpawnOnHurt + 2
        ); i++) {
            float xVel = (float) MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            float yVel = MathHelpers.randomBetween(0.4f, 0.6f);
            float zVel = (float) MathHelpers.clampOutside(MathHelpers.randomBetween(-0.5f, 0.5f), -0.2, 0.2);
            level.method_8406(ModParticleTypes.FLYING_SPARK, x, y, z, xVel, yVel, zVel);
        }
    }

    public static void spawnRedstoneInteractionParticles(class_638 level, class_2680 blockState, double interactionX, double interactionY, double interactionZ, float spreadX, float spreadY, float spreadZ) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, interactionX, interactionY, interactionZ)) return;
        if(!ConfigHandler.redstoneInteractionDust_enabled) return;
        class_2338 pos = class_2338.method_49637(interactionX, interactionY, interactionZ);
        for (int i = 0; i < ConfigHandler.redstoneInteractionDust_amount; i++) {
            double particleX = interactionX + MathHelpers.randomBetween(-spreadX / 2, spreadX / 2);
            double particleY = interactionY + MathHelpers.randomBetween(-spreadY / 2, spreadY / 2);
            double particleZ = interactionZ + MathHelpers.randomBetween(-spreadZ / 2, spreadZ / 2);
            class_2394 particleOptions = BlockParticleOverrides.REDSTONE_DUST.getParticleOptionForState(blockState, level, pos, BlockParticleOverride.ORIGIN_BLOCK_INTERACTED_WITH);
            if (particleOptions == null) continue;
            level.method_8406(
                particleOptions,
                particleX,
                particleY,
                particleZ,
                MathHelpers.randomBetween(-0.05f, 0.05f),
                0.2f,
                MathHelpers.randomBetween(-0.05f, 0.05f)
            );
        }
    }

    public static void spawnLavaBubblePopParticles(class_638 level, class_2338 fluidPos, class_3610 fluidState) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, fluidPos)) return;
        if (!ConfigHandler.lavaBubblePop_enabled) return;
        if (level.field_9229.method_43057() < (float) ConfigHandler.lavaBubblePop_spawnChance / 2500) {
            double d0 = (double) fluidPos.method_10263() + level.field_9229.method_43058();
            double d1 = (double) fluidPos.method_10264() + 0.95;
            double d2 = (double) fluidPos.method_10260() + level.field_9229.method_43058();
            level.method_8406(ModParticleTypes.LAVA_POP, d0, d1, d2, 0.0f, 0.0f, 0.0f);
        }
    }

    public static void spawnRandomUnderwaterBubbleStreams(class_638 level, class_2338 blockPos, class_2680 blockState) {
        if (!ConfigHandler.underwaterBubbleStreams_enabled) return;
        if (SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) return;
        if (!FluidHelpers.probablyPlacedUnderwater(level, blockPos)) return;

        class_2960 blockLocation = RegistryHelpers.getLocationFromBlock(blockState.method_26204());
        if(!TagUtil.doesListContainBlock(ConfigHandler.underwaterBubbleStreams_blocks, blockLocation)) return;

        if (level.field_9229.method_43057() < (float) ConfigHandler.underwaterBubbleStreams_spawnChance / 2500) {
            double x = (double) blockPos.method_10263() + level.field_9229.method_43058();
            double y = (double) blockPos.method_10264() + (blockState.method_51367() ? 1.05 : level.field_9229.method_43058());
            double z = (double) blockPos.method_10260() + level.field_9229.method_43058();
            RandomDistributionEmitterOptions emitter = new RandomDistributionEmitterOptions(
                ModParticleTypes.UNDERWATER_RISING_BUBBLE_SMALL_EMITTER,
                MathHelpers.randomBetween(9, 30),
                MathHelpers.randomBetween(2, 4),
                1
            );
            level.method_8406(emitter, x, y, z, 0.0f, 0.0f, 0.0f);
        }
    }

    public static void spawnBlockDisturbanceParticles(class_638 level, class_2338 blockPos, class_2680 blockState, double entityX, double entityY, double entityZ, class_243 deltaMovement, boolean isSprinting) {
        if(!ConfigHandler.blockRustle_enabled) return;
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, blockPos)) return;
        double speed = deltaMovement.method_1033();
        if(speed <= 0.1 && !isSprinting) return;

        class_2960 blockLocation = RegistryHelpers.getLocationFromBlock(blockState.method_26204());
        if(!TagUtil.doesListContainBlock(ConfigHandler.blockRustle_Blocks, blockLocation)) return;

        int overrideOrigin = BlockParticleOverride.ORIGIN_BLOCK_WALKED_THROUGH;

        int particlesAmount =  (speed > 0.25 || isSprinting ? 3 : 1);

        for (int i = 0; i < particlesAmount; i++) {
            double particleX = entityX + ((level.field_9229.method_43057() * 0.5) - 0.25);
            double particleY = entityY + 0.35 + ((level.field_9229.method_43057() * 0.5) - 0.25);
            double particleZ = entityZ + ((level.field_9229.method_43057() * 0.5) - 0.25);

            // skip spawning if the particle is out of the block bounds
            class_2338 entityBlockPos = class_2338.method_49637(particleX, blockPos.method_10264(), particleZ);
            if(level.method_8320(entityBlockPos).method_26215()) continue;

            BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(blockState, overrideOrigin);
            if (particleOverride == BlockParticleOverride.NONE) continue;

            class_2394 particleToSpawn = particleOverride.getParticleOptionForState(blockState, level, blockPos, overrideOrigin);
            if(particleToSpawn == null) continue;

            level.method_8406(
                particleToSpawn,
                particleX,
                particleY,
                particleZ,
                deltaMovement.field_1352 * 3 * particleOverride.getParticleVelocityMultiplier(),
                Math.min(deltaMovement.field_1351, 0.1) * 3 * particleOverride.getParticleVelocityMultiplier() + 0.1,
                deltaMovement.field_1350 * 3 * particleOverride.getParticleVelocityMultiplier()
            );
        }
    }

    public static void spawnItemFrameInteractionParticles(class_638 level, double x, double y, double z, class_238 boundingBox, class_2350 itemFrameDirection, ItemFrameParticleOrigin particleOrigin, boolean glowingItemFrame) {
        if(!ConfigHandler.itemFrame_enabled) return;
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.INTERACTION, x, y, z)) return;

        double particleSpeed = 0.2;

        class_2394 particleOptionToSpawn;
        if(particleOrigin == ItemFrameParticleOrigin.FRAME_KILLED) {
            return;
        } else {
            particleOptionToSpawn = glowingItemFrame ? TintedParticleOption.GLOW_ITEM_FRAME_DUST_OPTION : TintedParticleOption.ITEM_FRAME_DUST_OPTION;
        }

        for (int i = 0; i < ConfigHandler.itemFrame_amount; i++) {
            double randomX = boundingBox.field_1323 + (boundingBox.method_17939() * level.field_9229.method_43058());
            double randomY = boundingBox.field_1322 + (boundingBox.method_17940() * level.field_9229.method_43058());
            double randomZ = boundingBox.field_1321 + (boundingBox.method_17941() * level.field_9229.method_43058());

            level.method_8406(
                particleOptionToSpawn,
                (itemFrameDirection.method_10148() * 0.15) + x,
                (itemFrameDirection.method_10164() * 0.15) + y,
                (itemFrameDirection.method_10165() * 0.15) + z,
                (itemFrameDirection.method_10148() * 0.03) + (randomX - x) * 2 * particleSpeed,
                (itemFrameDirection.method_10164() * 0.03) + (randomY - y) * 2 * particleSpeed,
                (itemFrameDirection.method_10165() * 0.03) + (randomZ - z) * 2 * particleSpeed
            );
        }
    }

    public enum ItemFrameParticleOrigin {
        FRAME_KILLED(),
        HELD_ITEM_REMOVED(),
        ITEM_ROTATED(),
        ITEM_PLACED(),
    }

    public static void spawnSmokerSmokeParticles(class_638 level, class_2338 blockPos) {
        if(!ConfigHandler.smokerSmoke_enabled) return;
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) return;

        if(level.field_9229.method_43057() > 0.3) {
            class_243 centerPos = blockPos.method_46558();
            level.method_8406(class_2398.field_17430, centerPos.field_1352, blockPos.method_10264() + .8, centerPos.field_1350, 0, 0.07f, 0);
        }
    }

    public static void spawnAdditionalFurnaceParticles(class_638 level, class_2338 blockPos, class_2680 furnaceState) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) return;
        if(!ConfigHandler.furnaceEmbers_enabled) return;

        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if( level.method_8320(class_2338.method_49637(positions[0], positions[1], positions[2])).method_26228(level, blockPos) ) return;

        class_2350 furnaceDirection = furnaceState.method_11654(class_3865.field_11104);
        final boolean spawnSpark = level.field_9229.method_43057() < 0.7;
        final float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (spawnSpark ? 1 : 5);
        level.method_8406(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK, positions[0], positions[1], positions[2], furnaceDirection.method_10148() * outwardVelocity, 0.05f, furnaceDirection.method_10165() * outwardVelocity);
    }

    public static void spawnAdditionalBlastFurnaceParticles(class_638 level, class_2338 blockPos, class_2680 furnaceState) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, blockPos)) return;
        if(!ConfigHandler.blastFurnaceSparks_enabled) return;

        double[] positions = ParticlePositionHelpers.getRandomFurnaceParticlePosition(blockPos, furnaceState);
        if( level.method_8320(class_2338.method_49637(positions[0], positions[1], positions[2])).method_26228(level, blockPos) ) return;

        class_2350 furnaceDirection = furnaceState.method_11654(class_3865.field_11104);
        final boolean spawnSpark = level.field_9229.method_43057() < 0.2;
        final float outwardVelocity = MathHelpers.randomBetween(0.01f, 0.03f) * (spawnSpark ? 1 : 5);
        level.method_8406(spawnSpark ? ModParticleTypes.FLOATING_EMBER : ModParticleTypes.FLOATING_SPARK, positions[0], positions[1] + 0.125, positions[2], furnaceDirection.method_10148() * outwardVelocity, 0.05f, furnaceDirection.method_10165() * outwardVelocity);
    }

    public static void spawnLightningImpactSparks(class_638 level, double x, double y, double z) {
        if(SpawnParticlesUtil.isParticleOutsideRenderDistance(ParticleCategory.AMBIENT, x, y, z)) return;
        if(!ConfigHandler.lightningStrike_enabled) return;

        SpawnParticlesUtil.spawnParticleInCircle(
            () -> new ArcEmitterOptions(
                ModParticleTypes.ARC_EMITTER,
                MathHelpers.randomBetween(7, 14),
                MathHelpers.randomBetween(3, 5),
                40,
                MathHelpers.randomBetween(4, 6),
                ArcEmitterOptions.TICK_INTERVAL_DEFAULT,
                MathHelpers.randomBetween(160, 380),
                null
            ),
            level,
            new class_243(x, y + 0.5, z),
            ConfigHandler.lightningStrike_amountOfArcs,
            0.2f,
            0.8f,
            3f,
            0.3f,
            1.0f
        );
        SpawnParticlesUtil.spawnParticleInCircle(
            ModParticleTypes.FLYING_SPARK,
            level,
            new class_243(x, y + 0.01, z),
            MathHelpers.randomBetween(Math.max(0, ConfigHandler.lightningStrike_amountOfSparks - 4), ConfigHandler.lightningStrike_amountOfSparks),
            0.3f,
            0.8f,
            0.25f,
            0.25f,
            1.1f
        );
    }

    public static void spawnHoneyCollectionParticles(class_638 level, double x, double y, double z, class_2350 faceDirection) {
        for (int i = 0; i < level.field_9229.method_39332(Math.max(ConfigHandler.maxHoneyCollection_onUse - 2, 0), Math.max(ConfigHandler.maxHoneyCollection_onUse, 1)); i++) {
            double xOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 + Math.abs(faceDirection.method_10148()));
            double yOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 + Math.abs(faceDirection.method_10164()));
            double zOffset = (level.field_9229.method_43058() - 0.5) * 0.5 * (1 + Math.abs(faceDirection.method_10165()));
            level.method_8406(
                DripParticleOption.FALLING_HONEY_DROP,
                x + xOffset,
                y + yOffset,
                z + zOffset,
                0,
                0,
                0
            );
        }
    }
    public static void spawnHoneyCollectionParticlesOnPlayer(class_638 level, class_1657 player) {
        for (int i = 0; i < level.field_9229.method_39332(Math.max(ConfigHandler.maxHoneyCollection_onUse / 2, 0), Math.max(ConfigHandler.maxHoneyCollection_onUse / 2, 1)); i++) {
            level.method_8406(
                DripParticleOption.FALLING_HONEY_DROP,
                player.method_23317() - 0.25 + (level.field_9229.method_43058() / 2),
                player.method_23318() + 0.85 + (level.field_9229.method_43058() / 5),
                player.method_23321() - 0.25 + (level.field_9229.method_43058() / 2),
                0,
                0,
                0
            );
        }
    }
}