package games.enchanted.eg_particle_interactions.common.rendering.state;

//? if minecraft: > 1.21.8 {
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1060;
import net.minecraft.class_11659;
import net.minecraft.class_11942;
import net.minecraft.class_11944;
import net.minecraft.class_11977;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_3940;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;

public class CustomParticleGeometryRenderState implements class_11659.class_11947, class_11942 {
    private static final int INITIAL_CAPACITY = 1024;
    private static final int VERTS_PER_QUAD = 4;
    private static final int INTS_PER_QUAD = 2;
    private static final int FLOATS_PER_QUAD = 5;
    private final Map<class_3940.class_11941, QuadStorage> quadStoragePerLayer = new HashMap<>();
    private int vertexAmount = 0;

    @Override
    public void method_74316() {
        this.quadStoragePerLayer.values().forEach(QuadStorage::clear);
        this.vertexAmount = 0;
    }

    @Override
    public @Nullable class_11944.class_12041 method_74755(class_11977.class_12051 particleBufferCache) {
        try (class_9799 byteBufferBuilder = class_9799.method_72201(this.vertexAmount * class_290.field_1584.getVertexSize())){
            class_287 vertexBuffer = new class_287(byteBufferBuilder, VertexFormat.class_5596.field_27382, class_290.field_1584);

            HashMap<class_3940.class_11941, class_11944.class_12042> layerToPreparedMap = prepareLayers(vertexBuffer);

            class_9801 meshData = vertexBuffer.method_60794();

            if (meshData != null) {
                particleBufferCache.method_74835(meshData.method_60818());
                RenderSystem.getSequentialBuffer(VertexFormat.class_5596.field_27382).method_68274(meshData.method_60822().comp_751());
                GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().method_71106(
                    RenderSystem.getModelViewMatrix(),
                    new Vector4f(1.0f, 1.0f, 1.0f, 1.0f),
                    new Vector3f(),
                    RenderSystem.getTextureMatrix(),
                    RenderSystem.getShaderLineWidth()
                );
                return new class_11944.class_12041(meshData.method_60822().comp_751(), dynamicTransforms, layerToPreparedMap);
            }

            return null;
        }
    }

    private @NotNull HashMap<class_3940.class_11941, class_11944.class_12042> prepareLayers(class_287 vertexBuffer) {
        HashMap<class_3940.class_11941, class_11944.class_12042> layerToPreparedMap = new HashMap<>();
        int vertexOffset = 0;

        for (Map.Entry<class_3940.class_11941, QuadStorage> entry : this.quadStoragePerLayer.entrySet()) {
            QuadStorage storage = entry.getValue();

            storage.forEachVertex((x, y, z, u, v, packedLight, argb) -> vertexBuffer.method_22912(x, y, z).method_22913(u, v).method_39415(argb).method_60803(packedLight));

            if (storage.vertexAmount() > 0) {
                layerToPreparedMap.put(entry.getKey(), new class_11944.class_12042(vertexOffset, (int) (storage.vertexAmount() * 1.5)));
            }
            vertexOffset += storage.vertexAmount();
        }
        return layerToPreparedMap;
    }

    @Override
    public void method_74324(class_11944.class_12041 preparedBuffers, class_11977.class_12051 particleBufferCache, RenderPass renderPass, class_1060 textureManager, boolean translucentOnly) {
        RenderSystem.class_5590 quadIndexBuffer = RenderSystem.getSequentialBuffer(VertexFormat.class_5596.field_27382);
        renderPass.setVertexBuffer(0, particleBufferCache.method_74834());
        renderPass.setIndexBuffer(quadIndexBuffer.method_68274(preparedBuffers.comp_4897()), quadIndexBuffer.method_31924());
        renderPass.setUniform("DynamicTransforms", preparedBuffers.comp_4898());

        for (Map.Entry<class_3940.class_11941, class_11944.class_12042> entry : preparedBuffers.comp_4899().entrySet()) {
            if (translucentOnly != entry.getKey().comp_4894()) continue;
            renderPass.setPipeline(entry.getKey().comp_4896());
            renderPass.bindSampler("Sampler0", textureManager.method_4619(entry.getKey().comp_4895()).method_71659());
            renderPass.drawIndexed(entry.getValue().comp_4900(), 0, entry.getValue().comp_4901(), 1);
        }
    }

    @Override
    public void submit(class_11659 submitNodeCollector, class_12075 cameraRenderState) {
        if (this.vertexAmount > 0) {
            submitNodeCollector.method_74315(this);
        }
    }

    public void startQuad(class_3940.class_11941 layer) {
        this.quadStoragePerLayer.computeIfAbsent(layer, (l) -> new QuadStorage()).startQuad();
    }
    public void finishQuad(class_3940.class_11941 layer) {
        this.quadStoragePerLayer.computeIfAbsent(layer, (l) -> new QuadStorage()).finishQuad();
    }

    public void addVertex(class_3940.class_11941 layer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight) {
        this.addVertex(
            layer,
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight,
            1.0f,
            1.0f,
            1.0f,
            1.0f
        );
    }
    public void addVertex(class_3940.class_11941 layer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
        this.quadStoragePerLayer.computeIfAbsent(layer, (l) -> new QuadStorage()).addVertex(
            quaternion,
            x,
            y,
            z,
            xOffset,
            yOffset,
            scale,
            u,
            v,
            packedLight,
            rCol,
            gCol,
            bCol,
            alpha
        );
        this.vertexAmount++;
    }

    static class QuadStorage {
        private int capacity = INITIAL_CAPACITY * VERTS_PER_QUAD;
        private float[] floats = new float[capacity * FLOATS_PER_QUAD];
        private int[] ints = new int[capacity * INTS_PER_QUAD];

        private int currentVertexIndex = 0;
        private int currentQuadVertCount = -1;

        public void startQuad() {
            if(this.currentQuadVertCount != -1) {
                throw new IllegalStateException("Cannot start new quad before previous quad has 4 vertices");
            }
            this.currentQuadVertCount = 0;
        }

        public void finishQuad() {
            if(this.currentQuadVertCount != 4) {
                throw new IllegalStateException("Cannot finish quad without 4 vertices");
            }
            this.currentQuadVertCount = -1;
        }

        public boolean validStateForAddingVertex() {
            return this.currentQuadVertCount >= 0 && this.currentQuadVertCount < 4;
        }

        public void addVertex(Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight, float rCol, float gCol, float bCol, float alpha) {
            if(!validStateForAddingVertex()) {
                throw new IllegalStateException("Cannot add vertex, make sure to finish the previous quad or start a new quad");
            }
            Vector3f vertexPos = (new Vector3f(xOffset, yOffset, 0.0F)).rotate(quaternion).mul(scale).add(x, y, z);
            this.putData(vertexPos.x(), vertexPos.y(), vertexPos.z(), u, v, packedLight, class_9848.method_61318(alpha, rCol, gCol, bCol));
        }

        private void putData(float x, float y, float z, float u, float v, int packedLight, int argb) {
            this.currentQuadVertCount++;
            int i = this.currentVertexIndex * FLOATS_PER_QUAD;
            this.floats[i++] = x;
            this.floats[i++] = y;
            this.floats[i++] = z;
            this.floats[i++] = u;
            this.floats[i] = v;
            i = this.currentVertexIndex * INTS_PER_QUAD;
            this.ints[i++] = packedLight;
            this.ints[i] = argb;
            this.currentVertexIndex++;
        }

        public void forEachVertex(QuadConsumer consumer) {
            for (int i = 0; i < this.currentVertexIndex; i++) {
                int floatsIndex = i * FLOATS_PER_QUAD;
                int intsIndex = i * INTS_PER_QUAD;
                consumer.consume(
                    this.floats[floatsIndex++],
                    this.floats[floatsIndex++],
                    this.floats[floatsIndex++],
                    this.floats[floatsIndex++],
                    this.floats[floatsIndex],
                    this.ints[intsIndex++],
                    this.ints[intsIndex]
                );
            }
        }

        public int vertexAmount() {
            return this.currentVertexIndex;
        }

        public void clear() {
            this.currentQuadVertCount = -1;
            this.currentVertexIndex = 0;
        }
    }

    interface QuadConsumer {
        void consume(float x, float y, float z, float u, float v, int packedLight, int argb);
    }
}
//?}