package games.enchanted.eg_particle_interactions.common.config;

import dev.isxander.yacl3.api.*;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import games.enchanted.eg_particle_interactions.common.localisation.ConfigTranslation;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import net.minecraft.class_2561;

public class ConfigScreenHelper {
    public static ConfigCategory.Builder createBlockParticleOverrideConfigWidgets(ConfigCategory.Builder configCategoryBuilder) {
        for (BlockParticleOverride override : BlockParticleOverride.getBlockParticleOverrides()) {
            if(override == BlockParticleOverride.NONE || override == BlockParticleOverride.VANILLA) continue;
            configCategoryBuilder.group(
                ConfigScreen.createSeparator()
            );
            configCategoryBuilder.group(
                createOptionsForBlockOverride(override)
            );
            configCategoryBuilder.group(createBlockListForBlockOverride(override));
        }

        return configCategoryBuilder;
    }

    public static OptionGroup createOptionsForBlockOverride(BlockParticleOverride override) {
        String particleTypeKey = override.getName();

        Option<Boolean> overrideEnabled = Option.<Boolean>createBuilder()
            .name( ConfigTranslation.getGlobalOption(ConfigTranslation.IS_OVERRIDE_ENABLED).toComponent() )
            .description(OptionDescription.of( ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption(ConfigTranslation.IS_OVERRIDE_ENABLED)), class_2561.method_43471(ConfigTranslation.getParticleType(particleTypeKey).toString()).getString() ) ))
            .binding(Binding.generic(override.getOverrideEnabled_default(), override.getOverrideEnabled_getter(), override.getOverrideEnabled_setter()))
            .controller(opt -> BooleanControllerBuilder.create(opt).yesNoFormatter().coloured(true))
        .build();

        Option<Integer> maxParticlesOnPlaceOption = ConfigScreen.maxParticlesOnPlaceOption(ConfigTranslation.MAX_PARTICLES_ON_BLOCK_PLACE_ALONG_EDGES, override.getMaxParticlesOnPlace_default(), override.getMaxParticlesOnPlace_getter(), override.getMaxParticlesOnPlace_setter());
        Option<Integer> maxParticlesOnBreakOption = ConfigScreen.maxParticlesOnBreakOption(ConfigTranslation.MAX_PARTICLES_ON_BLOCK_BREAK_ALONG_AXIS, override.getMaxParticlesOnBreak_default(), override.getMaxParticlesOnBreak_getter(), override.getMaxParticlesOnBreak_setter());

        return ConfigScreen.createMultipleOptionsConfigGroup(override.getName(), override.getGroupName(), ConfigTranslation.BLOCKS_CONFIG_CATEGORY, overrideEnabled, maxParticlesOnPlaceOption, maxParticlesOnBreakOption);
    }
    public static ListOption<BlockOrTagLocation> createBlockListForBlockOverride(BlockParticleOverride override) {
        return ConfigScreen.createBlockLocationListOption(
            override.getName(),
            override.getGroupName() + "_blocks",
            ConfigTranslation.BLOCKS_CONFIG_CATEGORY,
            override.getSupportedBlockResourceLocations_default(),
            override.getSupportedBlockResourceLocations_getter(),
            override.getSupportedBlockResourceLocations_setter()
        );
    }
}
