package games.enchanted.eg_particle_interactions.common.config.adapters;

import com.google.gson.*;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import java.lang.reflect.Type;
import net.minecraft.class_2960;

public class BlockLocationTypeAdapter implements JsonSerializer<BlockOrTagLocation>, JsonDeserializer<BlockOrTagLocation> {
    @Override
    public BlockOrTagLocation deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String rawString = jsonElement.getAsString();
        class_2960 parsedLocation = class_2960.method_60654(rawString.replace("#", ""));
        return new BlockOrTagLocation(parsedLocation, rawString.startsWith("#"));
    }

    @Override
    public JsonElement serialize(BlockOrTagLocation resourceLocation, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(resourceLocation.toString());
    }
}
