package games.enchanted.eg_particle_interactions.common.config.controller;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.AbstractFixedDropdownController;
import games.enchanted.eg_particle_interactions.common.config.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class FluidLocationController extends AbstractFixedDropdownController<class_2960> {
    public FluidLocationController(Option<class_2960> option) {
        super(option);
    }

    @Override
    public String getString() {
        return option().pendingValue().toString();
    }

    @Override
    public void setFromStringIndex(String value, int index) {
        String valueFromDropdown = getValueFromDropdown(index);
        if(valueFromDropdown == null) {
            valueFromDropdown = value;
        }
        class_2960 validatedValue = RegistryHelpers.validateFluidLocationWithFallback(
            valueFromDropdown,
            null
        );
        if(isValueValid(valueFromDropdown) && validatedValue != null) {
            option.requestSet(
                validatedValue
            );
        }
    };

    @Override
    public boolean isValueValid(String value) {
        class_2960 blockLocFromValue = RegistryHelpers.validateFluidLocationWithFallback(value, null);
        return blockLocFromValue != null;
    }

    @Override
    protected String getValidValue(String value, int offset) {
        return RegistryHelpers.getMatchingLocations(value, class_7923.field_41173)
            .filter((class_2960 location) -> !RegistryHelpers.getFluidFromLocation(location).method_15785().method_15759().method_26215())
            .skip(offset)
            .findFirst()
            .map(class_2960::toString)
            .orElseGet(this::getString);
    }

    @Override
    public GenericListControllerElement<class_2960, ?> createWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new FluidLocationControllerElement(this, screen, widgetDimension);
    }
}