package games.enchanted.eg_particle_interactions.common.mixin.blocks;

import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2312;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import games.enchanted.eg_particle_interactions.common.particle_spawning.ParticlePositionHelpers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(net.minecraft.class_2286.class)
public abstract class ComparatorBlock extends class_2312 implements class_2343 {
    protected ComparatorBlock(class_2251 properties) {
        super(properties);
    }

    @Inject(
        at = @At(shift = At.Shift.AFTER, value = "INVOKE", target = "Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"),
        method = "useWithoutItem"
    )
    protected void spawnDustParticlesOnInteraction(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        if(!(level instanceof class_638)) return;
        float[] interactionPos = ParticlePositionHelpers.getRedstoneComparatorInteractionPos(level.method_8320(pos));
        SpawnParticles.spawnRedstoneInteractionParticles(
            (class_638) level,
            level.method_8320(pos),
            pos.method_10263() + interactionPos[0],
            pos.method_10264() + interactionPos[1],
            pos.method_10260() + interactionPos[2],
            0.15f,
            0.15f,
            0.15f
        );
    }
}
