package games.enchanted.eg_particle_interactions.common.mixin.entity;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(net.minecraft.class_1540.class)
public abstract class FallingBlockEntity extends class_1297 {
    @Shadow public abstract class_2680 getBlockState();

    public FallingBlockEntity(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(
        at = @At("HEAD"),
        method = "tick()V"
    )
    public void tick(CallbackInfo ci) {
        if(!(this.method_73183() instanceof class_638 clientLevel)) return;

        float particleChance = Math.clamp((float) this.method_18798().method_1033(), 0f, 0.98f);
        if(clientLevel.field_9229.method_43057() < particleChance) {
            SpawnParticles.spawnFallingBlockRandomFallParticles(clientLevel, this.getBlockState(), this.method_23317(), this.method_23318(), this.method_23321(), this.method_18798());
        }

    }
}
