package games.enchanted.eg_particle_interactions.common.mixin.particles;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import games.enchanted.eg_particle_interactions.common.rendering.particle.ModParticleRenderTypes;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

//? if minecraft: > 1.21.8 {
import com.google.common.collect.Maps;
import games.enchanted.eg_particle_interactions.common.particle.group.CustomGeometryParticleGroup;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
//?} else {
/*import com.llamalad7.mixinextras.sugar.Local;
import games.enchanted.eg_particle_interactions.common.particle_spawning.SpawnParticles;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
*///?}

import java.util.Map;
import java.util.Queue;
import net.minecraft.class_11938;
import net.minecraft.class_11943;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3302;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;

@Mixin(value = class_702.class, priority = 3000)
public abstract class ParticleEngineMixin implements class_3302 {
    @Shadow
    protected class_638 level;

    // block cracking and breaking particles (moved to ClientLevel in 1.21.9)
    //? if minecraft: <= 1.21.8 {
    /*@Inject(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/state/BlockState;getShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"),
        method = "destroy"
    )
    public void useParticleInteractionsDestroyParticleLogic(BlockPos brokenBlockPos, BlockState brokenBlockState, CallbackInfo ci) {
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(brokenBlockState, BlockParticleOverride.ORIGIN_BLOCK_BROKEN);
        SpawnParticles.spawnBlockBreakParticle(this.level, brokenBlockState, brokenBlockPos, particleOverride);
    }

    @WrapOperation(
        method = "destroy",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/world/phys/shapes/VoxelShape;forAllBoxes(Lnet/minecraft/world/phys/shapes/Shapes$DoubleLineConsumer;)V")
    )
    public void skipSpawningVanillaDestroyParticles(VoxelShape instance, Shapes.DoubleLineConsumer doublelist, Operation<Void> original) {
    }

    @Inject(
        method = "crack(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/ParticleEngine;add(Lnet/minecraft/client/particle/Particle;)V"),
        locals = LocalCapture.CAPTURE_FAILSOFT,
        cancellable = true
    )
    public void replaceCrackingParticlesConditionally(BlockPos blockPos, Direction side, CallbackInfo ci, @Local(ordinal = 0) double xPos, @Local(ordinal = 1) double yPos, @Local(ordinal = 2) double zPos) {
        BlockState blockstate = this.level.getBlockState(blockPos);

        int overrideOrigin = BlockParticleOverride.ORIGIN_BLOCK_CRACK;
        BlockParticleOverride override = BlockParticleOverride.getOverrideForBlockState(blockstate, overrideOrigin);

        if(override == BlockParticleOverride.VANILLA) return;

        if(override != BlockParticleOverride.NONE) {
            ParticleOptions newParticleOption = override.getParticleOptionForState(blockstate, level, blockPos, overrideOrigin);
            if (newParticleOption == null) return;
            this.level.addParticle(
                newParticleOption,
                xPos,
                yPos,
                zPos,
                0,
                0,
                0
            );
        }
        ci.cancel();
    }
    *///?}

    // override item and block particles if they have a particle override
    @WrapOperation(
        method = "createParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)Lnet/minecraft/client/particle/Particle;",
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/particle/ParticleEngine;makeParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)Lnet/minecraft/client/particle/Particle;")
    )
    private <T extends class_2394> class_703 overrideParticleTypeConditionally(class_702 instance, T originalParticleOption, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Operation<class_703> original) {
        // Override item particles if the item is a BlockItem
        if(
            originalParticleOption.method_10295() == class_2398.field_11218
        ) {
            if(!(originalParticleOption instanceof class_2392)) {
                return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
            }

            class_1792 originalParticleItem = ((class_2392) originalParticleOption).method_10289().method_7909();

            if(!(originalParticleItem instanceof class_1747)) {
                return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
            }

            int overrideOrigin = BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN;

            class_2680 originalParticleBlockState = ((class_1747) originalParticleItem).method_7711().method_9564();
            BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(originalParticleBlockState, overrideOrigin);

            if(particleOverride == BlockParticleOverride.VANILLA || particleOverride == BlockParticleOverride.NONE) {
                return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
            }

            class_2394 newParticleOption = particleOverride.getParticleOptionForState(originalParticleBlockState, level, class_2338.method_49637(x, y, z), overrideOrigin);
            return (original).call(
                instance,
                newParticleOption,
                x,
                y,
                z,
                xSpeed * (Math.random() * 0.75 + 0.6) * particleOverride.getParticleVelocityMultiplier(),
                (ySpeed + 0.6) * (Math.random() * 0.75 + 0.6) * particleOverride.getParticleVelocityMultiplier(),
                zSpeed * (Math.random() * 0.75 + 0.6) * particleOverride.getParticleVelocityMultiplier()
            );
        }

        // Override block particles
        if(
            originalParticleOption.method_10295() != class_2398.field_11217 &&
            originalParticleOption.method_10295() != class_2398.field_50248 &&
            originalParticleOption.method_10295() != class_2398.field_54870
        ) {
            return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
        }

        if(!(originalParticleOption instanceof class_2388)) {
            return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
        }

        int overrideOrigin = BlockParticleOverride.ORIGIN_BLOCK_PARTICLE_OVERRIDDEN;

        class_2680 originalParticleBlockState = ((class_2388) originalParticleOption).method_10278();
        BlockParticleOverride particleOverride = BlockParticleOverride.getOverrideForBlockState(originalParticleBlockState, overrideOrigin);

        if(particleOverride == BlockParticleOverride.VANILLA || particleOverride == BlockParticleOverride.NONE) {
            return (original).call(instance, originalParticleOption, x, y, z, xSpeed, ySpeed, zSpeed);
        }

        class_2394 newParticleOption = particleOverride.getParticleOptionForState(originalParticleBlockState, level, class_2338.method_49637(x, y, z), overrideOrigin);
        boolean isDustPillarParticle = originalParticleOption.method_10295() == class_2398.field_50248;
        double newYSpeed = (ySpeed * particleOverride.getParticleVelocityMultiplier() * 0.5) + (ySpeed < 0.02 ? 0.08 : 0.);
        return (original).call(
            instance,
            newParticleOption,
            x,
            y,
            z,
            xSpeed * (Math.random() * 0.75 + 0.6) * particleOverride.getParticleVelocityMultiplier(),
            isDustPillarParticle ? (ySpeed * 2) + 0.45 : newYSpeed,
            zSpeed * (Math.random() * 0.75 + 0.6) * particleOverride.getParticleVelocityMultiplier()
        );
    }

    //? if minecraft: > 1.21.8 {
    @Shadow @Final private Map<class_3999, class_11938<?>> particles = Maps.newIdentityHashMap();;

    @Inject(
        at = @At("HEAD"),
        method = "createParticleGroup",
        cancellable = true
    )
    private void block_place_particle$createCustomParticleGroup(class_3999 particleRenderType, CallbackInfoReturnable<class_11938<?>> cir) {
        if(particleRenderType == ModParticleRenderTypes.CUSTOM_GEOMETRY) {
            cir.setReturnValue(new CustomGeometryParticleGroup((class_702) (Object) this));
        }
    }

    @Inject(
        at = @At("TAIL"),
        method = "extract"
    )
    private void block_place_particle$extractCustomParticles(class_11943 state, class_4604 frustum, class_4184 camera, float f, CallbackInfo ci) {
        class_11938<?> group = this.particles.get(ModParticleRenderTypes.CUSTOM_GEOMETRY);
        if (group != null && !group.method_74284()) {
            state.method_74318(group.method_74276(frustum, camera, f));
        }
    }
    //?}

    //? if minecraft: <= 1.21.8 && fabric {
    /*@Shadow @Final private Map<ParticleRenderType, Queue<Particle>> particles;
    @Shadow private static void renderParticleType(Camera p_382847_, float p_383032_, MultiBufferSource.BufferSource p_383105_, ParticleRenderType p_383179_, Queue<Particle> p_383046_) {}

    @Inject(
        at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;endBatch()V"),
        method = "render(Lnet/minecraft/client/Camera;FLnet/minecraft/client/renderer/MultiBufferSource$BufferSource;)V"
    )
    public void render(Camera camera, float f, MultiBufferSource.BufferSource bufferSource, CallbackInfo ci) {
        Queue<Particle> queue = this.particles.get(ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE);
        if (queue != null && !queue.isEmpty()) {
            renderParticleType(camera, f, bufferSource, ModParticleRenderTypes.BACKFACE_TERRAIN_PARTICLE, queue);
        }
    }
    *///?}
}