package games.enchanted.eg_particle_interactions.common.particle.dust;

import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingColouredDust extends AbstractDust {
    protected final class_2680 dustBlockState;

    protected FloatingColouredDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_2338 blockPos, class_2680 blockState, class_4002 spriteSet, float gravityMultiplier, boolean spawnSpecks) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks);

        this.dustBlockState = blockState;

        int tintColour = class_310.method_1551().method_1505().method_1697(blockState, level, blockPos, 0);
        int[] tintColourARGB = ColourUtil.RGBint_to_ARGB(tintColour);
        int[] averageTextureColourARGB = ColourUtil.getRandomBlockColour(blockState, tintColourARGB);
        this.rCol = (float)averageTextureColourARGB[1] / 255f;
        this.gCol = (float)averageTextureColourARGB[2] / 255f;
        this.bCol = (float)averageTextureColourARGB[3] / 255f;
        this.alpha = (float)averageTextureColourARGB[0] / 255f;
    }

    @Override
    public @NotNull class_2394 getSpeckParticle() {
        return new class_2388(ModParticleTypes.TINTED_DUST_SPECK, this.dustBlockState);
    }

    @Override
    protected ParticleLayer getParticleLayer() {
        if(this.alpha < 0.99) return ParticleLayer.TRANSLUCENT;
        return super.getParticleLayer();
    }

    public static class TintedDustProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public TintedDustProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), this.spriteSet, 0.7f, true);
        }
    }

    public static class TintedDustSpeckProvider implements class_707<class_2388>  {
        private final class_4002 spriteSet;

        public TintedDustSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Override
        public @Nullable class_703 createParticle(
            class_2388 type,
            class_638 level,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed
            //? if minecraft: > 1.21.8 {
            , class_5819 random
            //?}
        ) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), this.spriteSet, 0.35f, false);
        }
    }
}
