package games.enchanted.eg_particle_interactions.common.particle.option;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class DripParticleOption implements class_2394 {
    public static final int DEFAULT_START_FALLING_TICKS = 5;
    public static final float DEFAULT_GRAVITY = 0.05F;
    public static final float DEFAULT_GRAVITY_RANDOMNESS = 0.0F;

    public static final DripParticleOption FALLING_HONEY_DROP = new DripParticleOption(ModParticleTypes.HONEY_DROP, 0, 0.02f, 0.03f);
    public static final DripParticleOption HANGING_HONEY_DROP = new DripParticleOption(ModParticleTypes.HONEY_DROP, 30, 0.02f, 0.03f);

    private final class_2396<DripParticleOption> type;
    private final int startFallingTicks;
    private final float gravity;
    private final float gravityRandomness;

    public DripParticleOption(class_2396<DripParticleOption> type, int fallTicks, float gravity, float gravityRandomness) {
        this.type = type;
        this.startFallingTicks = fallTicks;
        this.gravity = gravity;
        this.gravityRandomness = gravityRandomness;
    }

    private static Codec<DripParticleOption> createCodec(class_2396<DripParticleOption> type) {
        return RecordCodecBuilder.create((RecordCodecBuilder.Instance<DripParticleOption> instance) ->
            instance.group(
                class_5699.field_33442.optionalFieldOf("start_falling_ticks", DEFAULT_START_FALLING_TICKS).forGetter(DripParticleOption::getStartFallingTicks),
                Codec.FLOAT.optionalFieldOf("gravity", DEFAULT_GRAVITY).forGetter(DripParticleOption::getGravity),
                Codec.FLOAT.optionalFieldOf("gravity_randomess", DEFAULT_GRAVITY_RANDOMNESS).forGetter(DripParticleOption::getGravity)
            ).apply(
                instance,
                (
                    Integer fallTicks,
                    Float gravity,
                    Float gravityRandomness
                ) -> new DripParticleOption(
                    type,
                    fallTicks,
                    gravity,
                    gravityRandomness
                )
            )
        );
    }

    public static MapCodec<DripParticleOption> codec(class_2396<DripParticleOption> type) {
        return createCodec(type).fieldOf("drip_options");
    }

    public static class_9139<? super class_9129, DripParticleOption> streamCodec(class_2396<DripParticleOption> type) {
        return class_9135.method_56368(createCodec(type));
    }

    @Override
    public @NotNull class_2396<?> method_10295() {
        return type;
    }

    public int getStartFallingTicks() {
        return startFallingTicks;
    }

    public float getGravity() {
        return gravity;
    }

    public float getGravityRandomness() {
        return gravityRandomness;
    }
}
