package games.enchanted.eg_particle_interactions.common.particle_override;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.particle.option.TintedParticleOption;
import games.enchanted.eg_particle_interactions.common.util.BiomeHelpers;
import net.minecraft.class_2246;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_2457;
import net.minecraft.class_2459;
import net.minecraft.class_2462;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_638;
import net.minecraft.world.level.block.*;

public abstract class BlockParticleOverrides {
    public static final BlockParticleOverride SNOW_POWDER = new BlockParticleOverride(
        "snowflake",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            if(BiomeHelpers.isWarmBiomeOrDimension(level, blockPos)) {
                return level.field_9229.method_43048(5) == 0 ? class_2398.field_11203 : ModParticleTypes.SNOWFLAKE;
            }
            return ModParticleTypes.SNOWFLAKE;
        },
        () -> ConfigHandler.snowflake_Blocks,
        (val) -> ConfigHandler.snowflake_Blocks = val,
        ConfigHandler.snowflake_Blocks_DEFAULT,
        () -> ConfigHandler.snowflake_enabled,
        (val) -> ConfigHandler.snowflake_enabled = val,
        ConfigHandler.snowflake_enabled_DEFAULT,
        () -> ConfigHandler.maxSnowflakes_onPlace,
        (val) -> ConfigHandler.maxSnowflakes_onPlace = val,
        ConfigHandler.maxSnowflakes_onPlace_DEFAULT,
        () -> ConfigHandler.maxSnowflakes_onBreak,
        (val) -> ConfigHandler.maxSnowflakes_onBreak = val,
        ConfigHandler.maxSnowflakes_onBreak_DEFAULT,
        0.15f
    );
    public static final BlockParticleOverride CHERRY_LEAF = new BlockParticleOverride(
        "cherry_petal",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_CHERRY_PETAL,
        () -> ConfigHandler.cherryPetal_Blocks,
        (val) -> ConfigHandler.cherryPetal_Blocks = val,
        ConfigHandler.cherryPetal_Blocks_DEFAULT,
        () -> ConfigHandler.cherryPetal_enabled,
        (val) -> ConfigHandler.cherryPetal_enabled = val,
        ConfigHandler.cherryPetal_enabled_DEFAULT,
        () -> ConfigHandler.maxCherryPetals_onPlace,
        (val) -> ConfigHandler.maxCherryPetals_onPlace = val,
        ConfigHandler.maxCherryPetals_onPlace_DEFAULT,
        () -> ConfigHandler.maxCherryPetals_onBreak,
        (val) -> ConfigHandler.maxCherryPetals_onBreak = val,
        ConfigHandler.maxCherryPetals_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride AZALEA_LEAF = new BlockParticleOverride(
        "azalea_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_AZALEA_LEAF,
        () -> ConfigHandler.azaleaLeaf_Blocks,
        (val) -> ConfigHandler.azaleaLeaf_Blocks = val,
        ConfigHandler.azaleaLeaf_Blocks_DEFAULT,
        () -> ConfigHandler.azaleaLeaf_enabled,
        (val) -> ConfigHandler.azaleaLeaf_enabled = val,
        ConfigHandler.azaleaLeaf_enabled_DEFAULT,
        () -> ConfigHandler.maxAzaleaLeaves_onPlace,
        (val) -> ConfigHandler.maxAzaleaLeaves_onPlace = val,
        ConfigHandler.maxAzaleaLeaves_onPlace_DEFAULT,
        () -> ConfigHandler.maxAzaleaLeaves_onBreak,
        (val) -> ConfigHandler.maxAzaleaLeaves_onBreak = val,
        ConfigHandler.maxAzaleaLeaves_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride FLOWERING_AZALEA_LEAF = new BlockParticleOverride(
        "flowering_azalea_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_FLOWERING_AZALEA_LEAF,
        () -> ConfigHandler.floweringAzaleaLeaf_Blocks,
        (val) -> ConfigHandler.floweringAzaleaLeaf_Blocks = val,
        ConfigHandler.floweringAzaleaLeaf_Blocks_DEFAULT,
        () -> ConfigHandler.floweringAzaleaLeaf_enabled,
        (val) -> ConfigHandler.floweringAzaleaLeaf_enabled = val,
        ConfigHandler.floweringAzaleaLeaf_enabled_DEFAULT,
        () -> ConfigHandler.maxFloweringAzaleaLeaves_onPlace,
        (val) -> ConfigHandler.maxFloweringAzaleaLeaves_onPlace = val,
        ConfigHandler.maxFloweringAzaleaLeaves_onPlace_DEFAULT,
        () -> ConfigHandler.maxFloweringAzaleaLeaves_onBreak,
        (val) -> ConfigHandler.maxFloweringAzaleaLeaves_onBreak = val,
        ConfigHandler.maxFloweringAzaleaLeaves_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride PALE_LEAF = new BlockParticleOverride(
        "pale_leaf",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.FALLING_PALE_OAK_LEAF,
        () -> ConfigHandler.paleLeaf_Blocks,
        (val) -> ConfigHandler.paleLeaf_Blocks = val,
        ConfigHandler.paleLeaf_Blocks_DEFAULT,
        () -> ConfigHandler.paleLeaf_enabled,
        (val) -> ConfigHandler.paleLeaf_enabled = val,
        ConfigHandler.paleLeaf_enabled_DEFAULT,
        () -> ConfigHandler.maxPaleLeaves_onPlace,
        (val) -> ConfigHandler.maxPaleLeaves_onPlace = val,
        ConfigHandler.maxPaleLeaves_onPlace_DEFAULT,
        () -> ConfigHandler.maxPaleLeaves_onBreak,
        (val) -> ConfigHandler.maxPaleLeaves_onBreak = val,
        ConfigHandler.maxPaleLeaves_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride TINTED_PINE_LEAF = new BlockParticleOverride(
        "biome_pine_leaf",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FALLING_TINTED_PINE_LEAF, blockState),
        () -> ConfigHandler.tintedPineLeaves_Blocks,
        (val) -> ConfigHandler.tintedPineLeaves_Blocks = val,
        ConfigHandler.tintedPineLeaves_Blocks_DEFAULT,
        () -> ConfigHandler.tintedPineLeaves_enabled,
        (val) -> ConfigHandler.tintedPineLeaves_enabled = val,
        ConfigHandler.tintedPineLeaves_enabled_DEFAULT,
        () -> ConfigHandler.maxTintedPineLeaves_onPlace,
        (val) -> ConfigHandler.maxTintedPineLeaves_onPlace = val,
        ConfigHandler.maxTintedPineLeaves_onPlace_DEFAULT,
        () -> ConfigHandler.maxTintedPineLeaves_onBreak,
        (val) -> ConfigHandler.maxTintedPineLeaves_onBreak = val,
        ConfigHandler.maxTintedPineLeaves_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride TINTED_LEAF = new BlockParticleOverride(
        "biome_leaf",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FALLING_TINTED_LEAF, blockState),
        () -> ConfigHandler.tintedLeaves_Blocks,
        (val) -> ConfigHandler.tintedLeaves_Blocks = val,
        ConfigHandler.tintedLeaves_Blocks_DEFAULT,
        () -> ConfigHandler.tintedLeaves_enabled,
        (val) -> ConfigHandler.tintedLeaves_enabled = val,
        ConfigHandler.tintedLeaves_enabled_DEFAULT,
        () -> ConfigHandler.maxTintedLeaves_onPlace,
        (val) -> ConfigHandler.maxTintedLeaves_onPlace = val,
        ConfigHandler.maxTintedLeaves_onPlace_DEFAULT,
        () -> ConfigHandler.maxTintedLeaves_onBreak,
        (val) -> ConfigHandler.maxTintedLeaves_onBreak = val,
        ConfigHandler.maxTintedLeaves_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride FLOWER_PETAL = new BlockParticleOverride(
        "flower_petal",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.FLOWER_PETAL, blockState),
        () -> ConfigHandler.flowerPetals_Blocks,
        (val) -> ConfigHandler.flowerPetals_Blocks = val,
        ConfigHandler.flowerPetals_Blocks_DEFAULT,
        () -> ConfigHandler.flowerPetals_enabled,
        (val) -> ConfigHandler.flowerPetals_enabled = val,
        ConfigHandler.flowerPetals_enabled_DEFAULT,
        () -> ConfigHandler.maxFlowerPetals_onPlace,
        (val) -> ConfigHandler.maxFlowerPetals_onPlace = val,
        ConfigHandler.maxFlowerPetals_onPlace_DEFAULT,
        () -> ConfigHandler.maxFlowerPetals_onBreak,
        (val) -> ConfigHandler.maxFlowerPetals_onBreak = val,
        ConfigHandler.maxFlowerPetals_onBreak_DEFAULT,
        0.18f
    );
    public static final BlockParticleOverride GRASS_BLADE = new BlockParticleOverride(
        "grass_blade",
        "tinted_or_random_pixel",
        (int overrideOrigin) -> overrideOrigin != BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN,
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            boolean spawnDirt = false;
            boolean spawnFirefly =
                level.method_22339(blockPos) <= 13 &&
                    BiomeHelpers.isSwampyBiome(level, blockPos) &&
                    level.field_9229.method_43057() > (overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_PLACED ? 0.9f : 0.6f);

            if(
                (blockState.method_26204() == class_2246.field_10219 || blockState.method_26204() == class_2246.field_10194) &&
                (overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_PLACED || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN)
            ) {
                // occasionally spawn dirt particles if a grass block is placed or broken
                spawnDirt = level.field_9229.method_43057() > 0.7;
            }

            if(spawnDirt) {
                return new class_2388(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK ? ModParticleTypes.BLOCK_CRACK : ModParticleTypes.BLOCK_HIGH_VELOCITY, class_2246.field_10566.method_9564());
            }
            if(spawnFirefly) {
                return class_2398.field_56509;
            }
            return new class_2388(ModParticleTypes.GRASS_BLADE, blockState);
        },
        () -> ConfigHandler.grassBlade_Blocks,
        (val) -> ConfigHandler.grassBlade_Blocks = val,
        ConfigHandler.grassBlade_Blocks_DEFAULT,
        () -> ConfigHandler.grassBlade_enabled,
        (val) -> ConfigHandler.grassBlade_enabled = val,
        ConfigHandler.grassBlade_enabled_DEFAULT,
        () -> ConfigHandler.maxGrassBlade_onPlace,
        (val) -> ConfigHandler.maxGrassBlade_onPlace = val,
        ConfigHandler.maxGrassBlade_onPlace_DEFAULT,
        () -> ConfigHandler.maxGrassBlade_onBreak,
        (val) -> ConfigHandler.maxGrassBlade_onBreak = val,
        ConfigHandler.maxGrassBlade_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride HEAVY_GRASS_BLADE = new BlockParticleOverride(
        "heavy_grass_blade",
        "tinted_or_random_pixel",
        (int overrideOrigin) -> overrideOrigin != BlockParticleOverride.ORIGIN_ITEM_PARTICLE_OVERRIDDEN,
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.HEAVY_GRASS_BLADE, blockState),
        () -> ConfigHandler.heavyGrassBlade_Blocks,
        (val) -> ConfigHandler.heavyGrassBlade_Blocks = val,
        ConfigHandler.heavyGrassBlade_Blocks_DEFAULT,
        () -> ConfigHandler.heavyGrassBlade_enabled,
        (val) -> ConfigHandler.heavyGrassBlade_enabled = val,
        ConfigHandler.heavyGrassBlade_enabled_DEFAULT,
        () -> ConfigHandler.maxHeavyGrassBlade_onPlace,
        (val) -> ConfigHandler.maxHeavyGrassBlade_onPlace = val,
        ConfigHandler.maxHeavyGrassBlade_onPlace_DEFAULT,
        () -> ConfigHandler.maxHeavyGrassBlade_onBreak,
        (val) -> ConfigHandler.maxHeavyGrassBlade_onBreak = val,
        ConfigHandler.maxHeavyGrassBlade_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride FIREFLY = new BlockParticleOverride(
        "firefly",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            boolean firefly = level.field_9229.method_43057() > 0.6;
            if(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_WALKED_THROUGH) {
                firefly = true;
            }
            return firefly ? class_2398.field_56509 : GRASS_BLADE.getParticleOptionForState(blockState, level, blockPos, overrideOrigin);
        },
        () -> ConfigHandler.firefly_Blocks,
        (val) -> ConfigHandler.firefly_Blocks = val,
        ConfigHandler.firefly_Blocks_DEFAULT,
        () -> ConfigHandler.firefly_enabled,
        (val) -> ConfigHandler.firefly_enabled = val,
        ConfigHandler.firefly_enabled_DEFAULT,
        () -> ConfigHandler.maxFirefly_onPlace,
        (val) -> ConfigHandler.maxFirefly_onPlace = val,
        ConfigHandler.maxFirefly_onPlace_DEFAULT,
        () -> ConfigHandler.maxFirefly_onBreak,
        (val) -> ConfigHandler.maxFirefly_onBreak = val,
        ConfigHandler.maxFirefly_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride MOSS_CLUMP = new BlockParticleOverride(
        "moss_clump",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.MOSS_CLUMP,
        () -> ConfigHandler.mossClump_Blocks,
        (val) -> ConfigHandler.mossClump_Blocks = val,
        ConfigHandler.mossClump_Blocks_DEFAULT,
        () -> ConfigHandler.mossClump_enabled,
        (val) -> ConfigHandler.mossClump_enabled = val,
        ConfigHandler.mossClump_enabled_DEFAULT,
        () -> ConfigHandler.maxMossClump_onPlace,
        (val) -> ConfigHandler.maxMossClump_onPlace = val,
        ConfigHandler.maxMossClump_onPlace_DEFAULT,
        () -> ConfigHandler.maxMossClump_onBreak,
        (val) -> ConfigHandler.maxMossClump_onBreak = val,
        ConfigHandler.maxMossClump_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride PALE_MOSS_CLUMP = new BlockParticleOverride(
        "pale_moss_clump",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> ModParticleTypes.PALE_MOSS_CLUMP,
        () -> ConfigHandler.paleMossClump_Blocks,
        (val) -> ConfigHandler.paleMossClump_Blocks = val,
        ConfigHandler.paleMossClump_Blocks_DEFAULT,
        () -> ConfigHandler.paleMossClump_enabled,
        (val) -> ConfigHandler.paleMossClump_enabled = val,
        ConfigHandler.paleMossClump_enabled_DEFAULT,
        () -> ConfigHandler.maxPaleMossClump_onPlace,
        (val) -> ConfigHandler.maxPaleMossClump_onPlace = val,
        ConfigHandler.maxPaleMossClump_onPlace_DEFAULT,
        () -> ConfigHandler.maxPaleMossClump_onBreak,
        (val) -> ConfigHandler.maxPaleMossClump_onBreak = val,
        ConfigHandler.maxPaleMossClump_onBreak_DEFAULT,
        0.13f
    );
    public static final BlockParticleOverride DUST = new BlockParticleOverride(
        "dust",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.TINTED_DUST, blockState),
        () -> ConfigHandler.dust_Blocks,
        (val) -> ConfigHandler.dust_Blocks = val,
        ConfigHandler.dust_Blocks_DEFAULT,
        () -> ConfigHandler.dust_enabled,
        (val) -> ConfigHandler.dust_enabled = val,
        ConfigHandler.dust_enabled_DEFAULT,
        () -> ConfigHandler.maxDust_onPlace,
        (val) -> ConfigHandler.maxDust_onPlace = val,
        ConfigHandler.maxDust_onPlace_DEFAULT,
        () -> ConfigHandler.maxDust_onBreak,
        (val) -> ConfigHandler.maxDust_onBreak = val,
        ConfigHandler.maxDust_onBreak_DEFAULT,
        0.1f
    );
    public static final BlockParticleOverride REDSTONE_DUST = new BlockParticleOverride(
        "redstone_dust",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            if(blockState.method_28498(class_2459.field_11446)) {
                return blockState.method_11654(class_2459.field_11446) ? TintedParticleOption.REDSTONE_DUST_OPTION : TintedParticleOption.REDSTONE_DUST_UNPOWERED_OPTION;
            }
            else if (blockState.method_28498(class_2286.field_10789)) {
                return blockState.method_11654(class_2286.field_10789) == class_2747.field_12578 ? TintedParticleOption.REDSTONE_DUST_OPTION : TintedParticleOption.REDSTONE_DUST_UNPOWERED_OPTION;
            }
            else if (blockState.method_28498(class_2457.field_11432)) {
                return blockState.method_11654(class_2457.field_11432) > 6 ? TintedParticleOption.REDSTONE_DUST_OPTION : TintedParticleOption.REDSTONE_DUST_UNPOWERED_OPTION;
            }
            else if (blockState.method_28498(class_2462.field_10911)) {
                return blockState.method_11654(class_2462.field_10911) ? TintedParticleOption.REDSTONE_DUST_OPTION : TintedParticleOption.REDSTONE_DUST_UNPOWERED_OPTION;
            }
            return TintedParticleOption.REDSTONE_DUST_OPTION;
        },
        () -> ConfigHandler.redstoneDust_Blocks,
        (val) -> ConfigHandler.redstoneDust_Blocks = val,
        ConfigHandler.redstoneDust_Blocks_DEFAULT,
        () -> ConfigHandler.redstoneDust_enabled,
        (val) -> ConfigHandler.redstoneDust_enabled = val,
        ConfigHandler.redstoneDust_enabled_DEFAULT,
        () -> ConfigHandler.maxRedstoneDust_onPlace,
        (val) -> ConfigHandler.maxRedstoneDust_onPlace = val,
        ConfigHandler.maxRedstoneDust_onPlace_DEFAULT,
        () -> ConfigHandler.maxRedstoneDust_onBreak,
        (val) -> ConfigHandler.maxRedstoneDust_onBreak = val,
        ConfigHandler.maxRedstoneDust_onBreak_DEFAULT,
        0.06f
    );
    public static final BlockParticleOverride NETHER_PORTAL_SHATTER = new BlockParticleOverride(
        "nether_portal_shatter",
        "generic_block_override",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.BLOCK_SHATTER, blockState),
        () -> ConfigHandler.blockShatter_Blocks,
        (val) -> ConfigHandler.blockShatter_Blocks = val,
        ConfigHandler.blockShatter_Blocks_DEFAULT,
        () -> ConfigHandler.blockShatter_enabled,
        (val) -> ConfigHandler.blockShatter_enabled = val,
        ConfigHandler.blockShatter_enabled_DEFAULT,
        () -> ConfigHandler.maxBlockShatter_onPlace,
        (val) -> ConfigHandler.maxBlockShatter_onPlace = val,
        ConfigHandler.maxBlockShatter_onPlace_DEFAULT,
        () -> ConfigHandler.maxBlockShatter_onBreak,
        (val) -> ConfigHandler.maxBlockShatter_onBreak = val,
        ConfigHandler.maxBlockShatter_onBreak_DEFAULT,
        0.2f
    );
    public static final BlockParticleOverride CHAIN_SNAP = new BlockParticleOverride(
        "chain_snap",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> {
            if(overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_BROKEN || overrideOrigin == BlockParticleOverride.ORIGIN_BLOCK_CRACK) {
                return level.field_9229.method_43057() > 0.9 ? ModParticleTypes.SPARK_FLASH : new class_2388(ModParticleTypes.CHAIN_SNAP, blockState);
            }
            return new class_2388(ModParticleTypes.CHAIN_SNAP, blockState);
        },
        () -> ConfigHandler.chainSnap_Blocks,
        (val) -> ConfigHandler.chainSnap_Blocks = val,
        ConfigHandler.chainSnap_Blocks_DEFAULT,
        () -> ConfigHandler.chainSnap_enabled,
        (val) -> ConfigHandler.chainSnap_enabled = val,
        ConfigHandler.chainSnap_enabled_DEFAULT,
        () -> ConfigHandler.maxChainSnap_onPlace,
        (val) -> ConfigHandler.maxChainSnap_onPlace = val,
        ConfigHandler.maxChainSnap_onPlace_DEFAULT,
        () -> ConfigHandler.maxChainSnap_onBreak,
        (val) -> ConfigHandler.maxChainSnap_onBreak = val,
        ConfigHandler.maxChainSnap_onBreak_DEFAULT,
        0.22f
    );
    public static final BlockParticleOverride SUGAR_CANE = new BlockParticleOverride(
        "sugar_cane",
        "tinted_or_random_pixel",
        (class_2680 blockState, class_638 level, class_2338 blockPos, int overrideOrigin) -> new class_2388(ModParticleTypes.SUGAR_CANE, blockState),
        () -> ConfigHandler.sugarCane_Blocks,
        (val) -> ConfigHandler.sugarCane_Blocks = val,
        ConfigHandler.sugarCane_Blocks_DEFAULT,
        () -> ConfigHandler.sugarCane_enabled,
        (val) -> ConfigHandler.sugarCane_enabled = val,
        ConfigHandler.sugarCane_enabled_DEFAULT,
        () -> ConfigHandler.maxSugarCane_onPlace,
        (val) -> ConfigHandler.maxSugarCane_onPlace = val,
        ConfigHandler.maxSugarCane_onPlace_DEFAULT,
        () -> ConfigHandler.maxSugarCane_onBreak,
        (val) -> ConfigHandler.maxSugarCane_onBreak = val,
        ConfigHandler.maxSugarCane_onBreak_DEFAULT,
        0.19f
    );

    public static void registerOverrides() {
        BlockParticleOverride.addBlockParticleOverride(SNOW_POWDER);
        BlockParticleOverride.addBlockParticleOverride(FIREFLY);
        BlockParticleOverride.addBlockParticleOverride(CHERRY_LEAF);
        BlockParticleOverride.addBlockParticleOverride(AZALEA_LEAF);
        BlockParticleOverride.addBlockParticleOverride(FLOWERING_AZALEA_LEAF);
        BlockParticleOverride.addBlockParticleOverride(PALE_LEAF);
        BlockParticleOverride.addBlockParticleOverride(TINTED_PINE_LEAF);
        BlockParticleOverride.addBlockParticleOverride(TINTED_LEAF);
        BlockParticleOverride.addBlockParticleOverride(FLOWER_PETAL);
        BlockParticleOverride.addBlockParticleOverride(GRASS_BLADE);
        BlockParticleOverride.addBlockParticleOverride(HEAVY_GRASS_BLADE);
        BlockParticleOverride.addBlockParticleOverride(MOSS_CLUMP);
        BlockParticleOverride.addBlockParticleOverride(PALE_MOSS_CLUMP);
        BlockParticleOverride.addBlockParticleOverride(DUST);
        BlockParticleOverride.addBlockParticleOverride(REDSTONE_DUST);
        BlockParticleOverride.addBlockParticleOverride(NETHER_PORTAL_SHATTER);
        BlockParticleOverride.addBlockParticleOverride(CHAIN_SNAP);
        BlockParticleOverride.addBlockParticleOverride(SUGAR_CANE);
    }
}
