package games.enchanted.eg_particle_interactions.common.util;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3486;

public class FluidHelpers {
    public static boolean isSurroundedByWater(class_1937 level, class_2338 blockPos, int minWaterBlocks) {
        return trueBooleans(
            minWaterBlocks,
            level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517),
            level.method_8316(blockPos.method_10074()).method_15767(class_3486.field_15517),
            level.method_8316(blockPos.method_10095()).method_15767(class_3486.field_15517),
            level.method_8316(blockPos.method_10078()).method_15767(class_3486.field_15517),
            level.method_8316(blockPos.method_10072()).method_15767(class_3486.field_15517),
            level.method_8316(blockPos.method_10067()).method_15767(class_3486.field_15517)
        );
    }

    public static boolean probablyPlacedUnderwater(class_1937 level, class_2338 blockPos) {
        boolean isWaterAtNorth = level.method_8316(blockPos.method_10095()).method_15767(class_3486.field_15517);
        boolean isWaterAtEast = level.method_8316(blockPos.method_10078()).method_15767(class_3486.field_15517);
        boolean isWaterAtSouth = level.method_8316(blockPos.method_10072()).method_15767(class_3486.field_15517);
        boolean isWaterAtWest = level.method_8316(blockPos.method_10067()).method_15767(class_3486.field_15517);
        boolean isWaterAbove = level.method_8316(blockPos.method_10084()).method_15767(class_3486.field_15517);
        boolean isWaterBelow = level.method_8316(blockPos.method_10074()).method_15767(class_3486.field_15517);

        boolean oneOrMoreWaterSurrounding = trueBooleans(
            1,
            isWaterAtNorth,
            isWaterAtEast,
            isWaterAtSouth,
            isWaterAtWest
        );
        boolean threeOrMoreWaterSurrounding = trueBooleans(
            3,
            isWaterAtNorth,
            isWaterAtEast,
            isWaterAtSouth,
            isWaterAtWest
        );
        return ((isWaterAbove || isWaterBelow) && oneOrMoreWaterSurrounding) || (!isWaterAbove && threeOrMoreWaterSurrounding);
    }

    static boolean trueBooleans(int howMany, boolean ... bools) {
        int total = 0;

        for (boolean bool : bools) {
            if (bool && (++total == howMany)) {
                return true;
            }
        }
        return false;
    }
}
