/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import games.enchanted.eg_particle_interactions.common.config.ConfigScreen;
import games.enchanted.eg_particle_interactions.common.localisation.ConfigTranslation;
import games.enchanted.eg_particle_interactions.common.particle_override.BlockParticleOverride;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import net.minecraft.class_2561;

public class ConfigScreenHelper {
    public static ConfigCategory.Builder createBlockParticleOverrideConfigWidgets(ConfigCategory.Builder configCategoryBuilder) {
        for (BlockParticleOverride override : BlockParticleOverride.getBlockParticleOverrides()) {
            if (override == BlockParticleOverride.NONE || override == BlockParticleOverride.VANILLA) continue;
            configCategoryBuilder.group(ConfigScreen.createSeparator());
            configCategoryBuilder.group(ConfigScreenHelper.createOptionsForBlockOverride(override));
            configCategoryBuilder.group(ConfigScreenHelper.createBlockListForBlockOverride(override));
        }
        return configCategoryBuilder;
    }

    public static OptionGroup createOptionsForBlockOverride(BlockParticleOverride override) {
        String particleTypeKey = override.getName();
        Option overrideEnabled = Option.createBuilder().name(ConfigTranslation.getGlobalOption("is_override_enabled").toComponent()).description(OptionDescription.of((class_2561[])new class_2561[]{ConfigTranslation.createPlaceholder(ConfigTranslation.createDesc(ConfigTranslation.getGlobalOption("is_override_enabled")), class_2561.method_43471((String)ConfigTranslation.getParticleType(particleTypeKey).toString()).getString())})).binding(Binding.generic((Object)override.getOverrideEnabled_default(), override.getOverrideEnabled_getter(), override.getOverrideEnabled_setter())).controller(opt -> BooleanControllerBuilder.create((Option)opt).yesNoFormatter().coloured(true)).build();
        Option<Integer> maxParticlesOnPlaceOption = ConfigScreen.maxParticlesOnPlaceOption("max_particles_block_place_along_edges", override.getMaxParticlesOnPlace_default(), override.getMaxParticlesOnPlace_getter(), override.getMaxParticlesOnPlace_setter());
        Option<Integer> maxParticlesOnBreakOption = ConfigScreen.maxParticlesOnBreakOption("max_particles_block_break_along_axis", override.getMaxParticlesOnBreak_default(), override.getMaxParticlesOnBreak_getter(), override.getMaxParticlesOnBreak_setter());
        return ConfigScreen.createMultipleOptionsConfigGroup(override.getName(), override.getGroupName(), "blocks", overrideEnabled, maxParticlesOnPlaceOption, maxParticlesOnBreakOption);
    }

    public static ListOption<BlockOrTagLocation> createBlockListForBlockOverride(BlockParticleOverride override) {
        return ConfigScreen.createBlockLocationListOption(override.getName(), override.getGroupName() + "_blocks", "blocks", override.getSupportedBlockResourceLocations_default(), override.getSupportedBlockResourceLocations_getter(), override.getSupportedBlockResourceLocations_setter());
    }
}

