/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.particle.compat;

import games.enchanted.eg_particle_interactions.common.rendering.ModRenderPipelines;
import games.enchanted.eg_particle_interactions.common.rendering.particle.ModParticleRenderTypes;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.StateQuadConsumer;
import games.enchanted.eg_particle_interactions.common.rendering.particle.state.CustomParticleGeometryRenderState;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class CustomGeometryParticle
extends class_703 {
    protected float scale;
    protected float roll;
    protected float oRoll;
    protected class_1058 sprite;
    protected float rCol = 1.0f;
    protected float gCol = 1.0f;
    protected float bCol = 1.0f;
    protected float alpha = 1.0f;
    public static final class_3940.class_11941 BACKFACE_TERRAIN_LAYER = new class_3940.class_11941(true, class_1059.field_5275, ModRenderPipelines.BACKFACE_TRANSLUCENT_PARTICLE);

    protected CustomGeometryParticle(class_638 clientLevel, double x, double y, double z, class_1058 textureAtlasSprite) {
        this(clientLevel, x, y, z, 0.0, 0.0, 0.0, textureAtlasSprite);
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
    }

    protected CustomGeometryParticle(class_638 clientLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_1058 textureAtlasSprite) {
        super(clientLevel, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprite = textureAtlasSprite;
        this.scale = 0.1f * (this.field_3840.method_43057() * 0.5f + 0.5f) * 2.0f;
    }

    @NotNull
    protected class_3940.class_11941 getLayer() {
        ParticleLayer layer = this.getParticleLayer();
        if (layer == null) {
            return class_3940.class_11941.field_62640;
        }
        return layer.layer;
    }

    @NotNull
    public class_3999 method_74274() {
        return ModParticleRenderTypes.CUSTOM_GEOMETRY;
    }

    public void extract(CustomParticleGeometryRenderState state, class_4184 camera, float partialTicks) {
        this.renderTick(partialTicks);
        Quaternionf quaternionf = new Quaternionf();
        this.getBillboardMode().rotate(quaternionf, camera, partialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(class_3532.method_16439((float)partialTicks, (float)this.oRoll, (float)this.roll));
        }
        StateQuadConsumer consumer = new StateQuadConsumer(state, this.getLayer());
        this.adjustPositionBeforeExtraction(consumer, camera, quaternionf, partialTicks);
    }

    protected void adjustPositionBeforeExtraction(QuadConsumer consumer, class_4184 camera, Quaternionf quaternionf, float partialTicks) {
        class_243 cameraPosition = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - cameraPosition.method_10216());
        float y = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - cameraPosition.method_10214());
        float z = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - cameraPosition.method_10215());
        this.extractGeometry(consumer, quaternionf, x, y, z, partialTicks);
    }

    protected void extractGeometry(QuadConsumer consumer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        int light = this.method_3068(partialTicks);
        consumer.startQuad();
        consumer.addVertex(quaternion, x, y, z, 1.0f, -1.0f, this.getScale(), this.getU1(), this.getV1(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, 1.0f, 1.0f, this.getScale(), this.getU1(), this.getV0(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, -1.0f, 1.0f, this.getScale(), this.getU0(), this.getV0(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.addVertex(quaternion, x, y, z, -1.0f, -1.0f, this.getScale(), this.getU0(), this.getV1(), light, this.rCol, this.gCol, this.bCol, this.alpha);
        consumer.finishQuad();
    }

    public BillboardMode getBillboardMode() {
        return BillboardMode.XYZ;
    }

    protected void renderTick(float partialTicks) {
    }

    public void setSpriteFromAge(class_4002 sprites) {
        if (this.field_3843) {
            return;
        }
        this.setSprite(sprites.method_18138(this.field_3866, this.field_3847));
    }

    public void setSprite(class_1058 sprite) {
        this.sprite = sprite;
    }

    public class_238 getCullingBox(float partialTicks) {
        return this.method_3064();
    }

    protected float getU0() {
        return this.sprite.method_4594();
    }

    protected float getU1() {
        return this.sprite.method_4577();
    }

    protected float getV0() {
        return this.sprite.method_4593();
    }

    protected float getV1() {
        return this.sprite.method_4575();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    protected abstract ParticleLayer getParticleLayer();

    public static enum ParticleLayer {
        OPAQUE(class_3940.class_11941.field_62640),
        TERRAIN(class_3940.class_11941.field_62639),
        TRANSLUCENT(class_3940.class_11941.field_62641),
        BACKFACE_TERRAIN(BACKFACE_TERRAIN_LAYER);

        public final class_3940.class_11941 layer;

        private ParticleLayer(class_3940.class_11941 layer) {
            this.layer = layer;
        }
    }

    public static interface BillboardMode {
        public static final BillboardMode FIXED = (quaternion, camera, partialTicks) -> quaternion.set(0.0f, 0.0f, 0.0f, camera.method_23767().w);
        public static final BillboardMode XYZ = (quaternion, camera, partialTicks) -> quaternion.set((Quaternionfc)camera.method_23767());

        public void rotate(Quaternionf var1, class_4184 var2, float var3);
    }
}

