/*
 * Decompiled with CFR 0.152.
 */
package games.enchanted.eg_particle_interactions.common.shapes;

import games.enchanted.eg_particle_interactions.common.rendering.particle.geometry.QuadConsumer;
import games.enchanted.eg_particle_interactions.common.util.MathHelpers;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class QuadFaceShape {
    protected final Vector3dc[] vertices;

    public QuadFaceShape(Vector3dc[] shapeVertices) {
        if (shapeVertices.length % 4 != 0) {
            throw new IllegalArgumentException("VertexShape must be initialised with a multiple of 4 vertices");
        }
        this.vertices = shapeVertices;
    }

    public Vector3dc[] getVertices() {
        return this.vertices;
    }

    public void extractShape(QuadConsumer consumer, Vector2f[] uvCoordinates, Vector3f pos, Vector3f scale, Vector3f rotation, float size, int lightColour, int[] argb) {
        if (uvCoordinates.length > 2) {
            throw new IllegalArgumentException("VertexShape#renderShape requires exactly 2 elements in uvCoordinates specifying the top left and top right uv coordinates");
        }
        float pitchRad = (float)Math.toRadians(rotation.x);
        float yawRad = (float)Math.toRadians(rotation.y);
        float rollRad = (float)Math.toRadians(rotation.z);
        float rCol = (float)argb[1] / 255.0f;
        float gCol = (float)argb[2] / 255.0f;
        float bCol = (float)argb[3] / 255.0f;
        float alpha = (float)argb[0] / 255.0f;
        for (int i = 0; i < this.vertices.length; i += 4) {
            consumer.startQuad();
            Vector3d vertex1 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            consumer.addVertex(new Quaternionf(), (float)vertex1.x(), (float)vertex1.y(), (float)vertex1.z(), 0.0f, 0.0f, 1.0f, uvCoordinates[0].x, uvCoordinates[1].y, lightColour, rCol, gCol, bCol, alpha);
            Vector3d vertex2 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 1]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            consumer.addVertex(new Quaternionf(), (float)vertex2.x(), (float)vertex2.y(), (float)vertex2.z(), 0.0f, 0.0f, 1.0f, uvCoordinates[0].x, uvCoordinates[0].y, lightColour, rCol, gCol, bCol, alpha);
            Vector3d vertex3 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 2]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            consumer.addVertex(new Quaternionf(), (float)vertex3.x(), (float)vertex3.y(), (float)vertex3.z(), 0.0f, 0.0f, 1.0f, uvCoordinates[1].x, uvCoordinates[0].y, lightColour, rCol, gCol, bCol, alpha);
            Vector3d vertex4 = MathHelpers.rotate3DPoint(new Vector3d(this.vertices[i + 3]).mul((Vector3fc)scale), pitchRad, yawRad, rollRad).mul((double)size).add((double)pos.x, (double)pos.y, (double)pos.z);
            consumer.addVertex(new Quaternionf(), (float)vertex4.x(), (float)vertex4.y(), (float)vertex4.z(), 0.0f, 0.0f, 1.0f, uvCoordinates[1].x, uvCoordinates[1].y, lightColour, rCol, gCol, bCol, alpha);
            consumer.finishQuad();
        }
    }

    public void extractShape(QuadConsumer consumer, Vector2f[] uvCoordinates, Vector3f pos, Vector3f scale, float size, int lightColour, int[] argb) {
        this.extractShape(consumer, uvCoordinates, pos, scale, new Vector3f(0.0f), size, lightColour, argb);
    }

    public static QuadFaceShape copyShape(QuadFaceShape shapeToCopy) {
        Vector3d[] copiedVerts = new Vector3d[shapeToCopy.getVertices().length];
        for (int i = 0; i < shapeToCopy.getVertices().length; ++i) {
            copiedVerts[i] = new Vector3d(shapeToCopy.getVertices()[i]);
        }
        return new QuadFaceShape((Vector3dc[])copiedVerts);
    }
}

