package games.enchanted.eg_particle_interactions.common.particle;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4003;
import net.minecraft.class_638;

public abstract class BouncyParticle extends class_4003 {
    protected boolean physics_canBounce = true;
    /**
     * How bouncy this particle is. 0 is no bouncing at all, 1 is full bouncing
     */
    protected float physics_bounciness = 0.85f;
    /**
     * How much the particle speed should be affected when travelling through a fluid
     */
    protected float physics_passThroughFluidSpeed = 1f;
    protected boolean isInWater = false;
    protected boolean hasEnteredWater = false;

    /**
     * A single quad particle has simple bouncing physics.
     * Set {@link #physics_bounciness} or {@link #physics_passThroughFluidSpeed} in your particle constructor to adjust the particle physics
     *
     * @param level  level
     * @param x      x pos
     * @param y      y pos
     * @param z      z pos
     * @param xSpeed x velocity
     * @param ySpeed y velocity
     * @param zSpeed z velocity
     */
    protected BouncyParticle(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    protected float getTotalVelocity() {
        return (float) Math.abs(this.field_3852 + this.field_3869 + this.field_3850);
    }

    @Override
    public void method_3070() {
        this.isInWater = this.field_3851.method_8316(class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871)).method_15767(class_3486.field_15517);
        if(this.isInWater) {
            this.hasEnteredWater = true;
        }

        if(field_3866 > 0 && physics_canBounce && this.physics_bounciness > 0 && this.field_3862) {
            if(this.isInWater) {
                this.field_3852 *= this.physics_passThroughFluidSpeed;
                this.field_3869 *= this.physics_passThroughFluidSpeed;
                this.field_3850 *= this.physics_passThroughFluidSpeed;
            }
            if(ConfigHandler.general_extraParticlePhysicsEnabled) {
                double xVel = this.field_3852;
                double yVel = this.field_3869;
                double zVel = this.field_3850;
                if (xVel * xVel + yVel * yVel + zVel * zVel < class_3532.method_34954(100)) {
                    class_243 collisionVector = class_1297.method_20736(null, new class_243(xVel, yVel, zVel), this.method_3064(), this.field_3851, List.of());
                    this.field_3852 = collisionVector.field_1352 == 0.0 ? -this.field_3852 * physics_bounciness : collisionVector.field_1352;
                    this.field_3869 = collisionVector.field_1351 == 0.0 ? -this.field_3869 * physics_bounciness : collisionVector.field_1351;
                    this.field_3850 = collisionVector.field_1350 == 0.0 ? -this.field_3850 * physics_bounciness : collisionVector.field_1350;
                }
            }
        }

        super.method_3070();
    }
}
