package games.enchanted.eg_particle_interactions.common.particle.drip;

import games.enchanted.eg_particle_interactions.common.duck.ParticleAccess;
import games.enchanted.eg_particle_interactions.common.particle.option.DripParticleOption;
import games.enchanted.eg_particle_interactions.common.util.RenderingUtil;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.client.particle.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class DripAndLandParticle extends class_4003 {
    protected boolean hasLanded = false;
    protected final int startFallingAtTicks;
    protected final boolean translucent;

    protected float uo;
    protected float u1;
    protected float v0;
    protected float v1;

    DripAndLandParticle(class_638 level, double x, double y, double z, class_4002 sprites, DripParticleOption dripParticleOption, boolean translucent) {
        super(level, x, y, z);
        this.method_18140(sprites);
        this.translucent = translucent;

        this.method_3080(0.01F, 0.01F);
        this.field_17867 = 0.15f;
        this.field_3844 = dripParticleOption.getGravity() + (level.field_9229.method_43057() * dripParticleOption.getGravityRandomness());

        this.startFallingAtTicks = dripParticleOption.getStartFallingTicks();

        this.uo = this.method_18133();
        this.u1 = this.method_18134();
        this.v0 = this.method_18135();
        float v1 = this.method_18136();
        float halfHeight = Math.abs(this.v0 - v1) / 2;
        this.v1 = v1 - halfHeight;

        this.field_3847 = level.field_9229.method_39332(350, 500);
    }

    @Override
    public void method_3070() {
        if (this.field_3843) return;

        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;

        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }

        if(this.startFallingAtTicks - this.field_3866 > 30) return;

        if(this.field_3866 < this.startFallingAtTicks) {
            this.field_3869 -= 0.004 / this.startFallingAtTicks;
            this.method_3069(this.field_3852, this.field_3869, this.field_3850);
            return;
        }

        this.field_3869 -= this.field_3844;
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);

        if(this.field_3845) {
            land();
        }

        this.field_3852 *= 0.98F;
        this.field_3869 *= 0.98F;
        this.field_3850 *= 0.98F;
    }

    protected void land() {
        if(this.hasLanded) return;
        this.hasLanded = true;

        float v0 = this.method_18135();
        this.v1 = this.method_18136();
        float halfHeight = Math.abs(v0 - this.v1) / 2;
        this.v0 = v0 + halfHeight;

        this.field_3847 = this.field_3866 + field_3851.field_9229.method_43051(30, 60);

        ((ParticleAccess) this).eg_particle_interactions$moveUpBecauseParticleLanded();
    }

    @Override
    public @NotNull class_3999 method_18122() {
        return this.translucent ? class_3999.field_17829 : class_3999.field_17828;
    }

    @Override
    protected void method_60374(@NotNull class_4588 buffer, @NotNull Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float scale = this.method_18132(partialTicks);
        int packedLight = this.method_3068(partialTicks);
        this.method_60375(buffer, quaternion, x, y, z, 1.0F, -1.0F, scale, this.u1, this.v1, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, 1.0F, 1.0F, scale, this.u1, this.v0, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, -1.0F, 1.0F, scale, this.uo, this.v0, packedLight);
        this.method_60375(buffer, quaternion, x, y, z, -1.0F, -1.0F, scale, this.uo, this.v1, packedLight);
    }

    private void method_60375(class_4588 buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float scale, float u, float v, int packedLight) {
        yOffset += hasLanded ? 1f : 0f;
        RenderingUtil.addVertexToConsumer(buffer, quaternion, x, y, z, xOffset, yOffset, scale, u, v, packedLight, this.field_3861, this.field_3842, this.field_3859, this.field_3841);
    }

    public static class UntintedDropProvider implements class_707<DripParticleOption> {
        class_4002 sprites;

        public UntintedDropProvider(class_4002 sprites) {
            this.sprites = sprites;
        }

        @Override
        public @Nullable class_703 createParticle(DripParticleOption options, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new DripAndLandParticle(level, x, y, z, sprites, options, true);
        }
    }
}
