package games.enchanted.eg_particle_interactions.common.particle.dust;

import games.enchanted.eg_particle_interactions.common.particle.ModParticleTypes;
import games.enchanted.eg_particle_interactions.common.util.ColourUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatingColouredDust extends AbstractDust {
    protected final class_2680 dustBlockState;

    protected FloatingColouredDust(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, class_2338 blockPos, class_2680 blockState, class_4002 spriteSet, float gravityMultiplier, boolean spawnSpecks) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, spriteSet, gravityMultiplier, spawnSpecks);

        this.dustBlockState = blockState;

        int tintColour = class_310.method_1551().method_1505().method_1697(blockState, level, blockPos, 0);
        int[] tintColourARGB = ColourUtil.RGBint_to_ARGB(tintColour);
        int[] averageTextureColourARGB = ColourUtil.getRandomBlockColour(blockState, tintColourARGB);
        this.field_3861 = (float)averageTextureColourARGB[1] / 255f;
        this.field_3842 = (float)averageTextureColourARGB[2] / 255f;
        this.field_3859 = (float)averageTextureColourARGB[3] / 255f;
        this.field_3841 = (float)averageTextureColourARGB[0] / 255f;
    }

    @Override
    public @NotNull class_2394 getSpeckParticle() {
        return new class_2388(ModParticleTypes.TINTED_DUST_SPECK, this.dustBlockState);
    }

    @Override
    public @NotNull class_3999 method_18122() {
        if(this.field_3841 < 0.99) {
            return class_3999.field_17829;
        }
        return super.method_18122();
    }

    public static class TintedDustProvider implements class_707<class_2388> {
        private final class_4002 spriteSet;

        public TintedDustProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        @Override
        public class_703 createParticle(@NotNull class_2388 type, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), this.spriteSet, 0.7f, true);
        }
    }

    public static class TintedDustSpeckProvider implements class_707<class_2388>  {
        private final class_4002 spriteSet;

        public TintedDustSpeckProvider(class_4002 spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        @Override
        public class_703 createParticle(@NotNull class_2388 type, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new FloatingColouredDust(level, x, y, z, xSpeed, ySpeed, zSpeed, class_2338.method_49637(x, y, z), type.method_10278(), this.spriteSet, 0.35f, false);
        }
    }
}
