package games.enchanted.eg_particle_interactions.common.particle.emitter;

import games.enchanted.eg_particle_interactions.common.config.ConfigHandler;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEmitterParticle extends class_703 {
    protected float emitterWidth;
    protected float emitterHeight;
    protected float emitterDepth;

    public AbstractEmitterParticle(class_638 level, double x, double y, double z, float width, float height, float depth) {
        super(level, x, y, z);
        this.emitterWidth = width;
        this.emitterHeight = height;
        this.emitterDepth = depth;
    }

    @Override
    public void method_3070() {
        if(this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        if(ConfigHandler.debug_showEmitterBounds) {
            field_3851.method_8406(new class_2390(0xFFFF0000, 0.5f), field_3874, field_3854, field_3871, 0, 0, 0);
            field_3851.method_8406(new class_2390(0xFF00FF00, 0.5f), field_3874 + this.emitterWidth, field_3854 + this.emitterHeight, field_3871 + this.emitterDepth, 0, 0, 0);
        }
        emitterTick();
    }

    protected abstract void emitterTick();

    /**
     * Called every time before spawning the next particle
     *
     * @param level the level
     * @param x     the x
     * @param y     the y
     * @param z     the z
     * @return the particle to emit
     */
    protected abstract @Nullable class_2394 getParticleToEmit(class_638 level, double x, double y, double z);

    @Override
    public void method_3074(@NotNull class_4588 vertexConsumer, @NotNull class_4184 camera, float v) {}

    @Override
    public @NotNull class_3999 method_18122() {
        return class_3999.field_17832;
    }
}
