package games.enchanted.eg_particle_interactions.common.resource;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import games.enchanted.eg_particle_interactions.common.Constants;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_4075;
import net.minecraft.class_7677;

public class ParticlePaletteAtlasManager extends class_4075 {
    public static final String ATLAS_ID = "particle_palettes";
    public static final class_2960 ATLAS_LOCATION = class_2960.method_60655(Constants.MOD_ID, "textures/atlas/" + ATLAS_ID);

    public ParticlePaletteAtlasManager(class_1060 textureManager) {
        super(
            textureManager,
            class_2960.method_60655(Constants.MOD_ID, "textures/atlas/" + ATLAS_ID),
            class_2960.method_60655(Constants.MOD_ID, ATLAS_ID),
            Set.of(ParticlePaletteSettingsMetadataSection.TYPE)
        );
    }

    public class_1058 get(class_2960 location) {
        return this.method_18667(location);
    }

    public ParticlePaletteSettingsMetadataSection getMetadata(class_2960 location) {
        return getMetadataFromSprite(this.get(location));
    }

    public static ParticlePaletteSettingsMetadataSection getMetadataFromSprite(class_1058 sprite) {
        return sprite.method_45851().method_52848().method_43041(ParticlePaletteSettingsMetadataSection.TYPE).orElse(ParticlePaletteSettingsMetadataSection.DEFAULT);
    }

    public record ParticlePaletteSettingsMetadataSection(boolean useBiomeTint) {
        private static final boolean BIOME_TINT_DEFAULT = true;

        public static final ParticlePaletteSettingsMetadataSection DEFAULT = new ParticlePaletteSettingsMetadataSection(BIOME_TINT_DEFAULT);

        public static final Codec<ParticlePaletteSettingsMetadataSection> CODEC = RecordCodecBuilder.create(
            instance -> instance
                .group(
                    Codec.BOOL.optionalFieldOf("use_biome_tint", BIOME_TINT_DEFAULT).forGetter(ParticlePaletteSettingsMetadataSection::useBiomeTint)
                )
                .apply(
                    instance, ParticlePaletteSettingsMetadataSection::new
                )
        );

        public static final class_7677<ParticlePaletteSettingsMetadataSection> TYPE = new class_7677<>(Constants.MOD_ID + ":particle_palette_settings", CODEC);
    }
}
