package games.enchanted.eg_particle_interactions.common.config.categories;

import games.enchanted.eg_particle_interactions.common.config.ConfigCategory;
import games.enchanted.eg_particle_interactions.common.config.ConfigOptions;
import games.enchanted.eg_particle_interactions.common.config.option.BlockOrTagLocationListOption;
import games.enchanted.eg_particle_interactions.common.config.option.BoolOption;
import games.enchanted.eg_particle_interactions.common.config.option.ConfigOption;
import games.enchanted.eg_particle_interactions.common.config.option.IntOption;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_3481;

public class BlockInteractionOptions {
    public static final ConfigOption<Boolean> UNDERWATER_BUBBLES_ON_PLACE_ENABLED = registerOption(
        new BoolOption(true, "underwater_bubbles_on_place_enabled")
    );
    public static final ConfigOption<Integer> UNDERWATER_BUBBLES_MAX_ON_PLACE = registerOption(
        new IntOption(12, "underwater_bubbles_max_on_place")
    );
    public static final ConfigOption<Boolean> UNDERWATER_BUBBLES_ON_BREAK_ENABLED = registerOption(
        new BoolOption(true, "underwater_bubbles_on_break_enabled")
    );
    public static final ConfigOption<Integer> UNDERWATER_BUBBLES_MAX_ON_BREAK = registerOption(
        new IntOption(6, "underwater_bubbles_max_on_break")
    );

    public static final ConfigOption<Boolean> CAMPFIRE_SPARK_ENABLED = registerOption(
        new BoolOption(true, "campfire_spark_enabled")
    );
    public static final ConfigOption<Integer> CAMPFIRE_SPARK_SPAWN_CHANCE = registerOption(
        new IntOption(20, "campfire_spark_spawn_chance")
    );
    public static final ConfigOption<Boolean> CAMPFIRE_EMBER_ENABLED = registerOption(
        new BoolOption(true, "campfire_ember_enabled")
    );
    public static final ConfigOption<Integer> CAMPFIRE_EMBER_SPAWN_CHANCE = registerOption(
        new IntOption(45, "campfire_ember_spawn_chance")
    );

    public static final ConfigOption<Boolean> FIRE_SPARK_ENABLED = registerOption(
        new BoolOption(true, "fire_spark_enabled")
    );
    public static final ConfigOption<Integer> FIRE_SPARK_SPAWN_CHANCE = registerOption(
        new IntOption(25, "fire_spark_spawn_chance")
    );
    public static final ConfigOption<Boolean> FIRE_EMBER_ENABLED = registerOption(
        new BoolOption(true, "fire_ember_enabled")
    );
    public static final ConfigOption<Integer> FIRE_EMBER_SPAWN_CHANCE = registerOption(
        new IntOption(45, "fire_ember_spawn_chance")
    );

    public static final ConfigOption<Boolean> BLOCK_RUSTLE_ENABLED = registerOption(
        new BoolOption(true, "block_rustle_enabled")
    );
    public static final ConfigOption<List<BlockOrTagLocation>> BLOCK_RUSTLE_BLOCKS = registerOption(
        new BlockOrTagLocationListOption(
            List.of(
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10424),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56455),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56454),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56562),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_56563),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_55742),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10597),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_54733),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10479),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10214),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10112),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10313),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_16999),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10428),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10376),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10238),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22116),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23078),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_23079),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22117),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22125),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22123),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_22124),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_28686),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10343),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10477),
                RegistryHelpers.getBlockLocationFromBlock(class_2246.field_10091),
                new BlockOrTagLocation(class_3481.field_28621.comp_327(), true),
                new BlockOrTagLocation(class_3481.field_20339.comp_327(), true),
                new BlockOrTagLocation(class_2960.method_60655("c", "flowers"), true),
                new BlockOrTagLocation(class_2960.method_60655("c", "flowers/small"), true),
                new BlockOrTagLocation(class_2960.method_60655("c", "flowers/tall"), true),
                new BlockOrTagLocation(class_3481.field_20341.comp_327(), true)
            ),
            "block_rustle_blocks"
        )
    );

    public static final ConfigOption<Boolean> ANVIL_USE_SPARKS_ENABLED = registerOption(
        new BoolOption(true, "anvil_use_sparks_enabled")
    );
    public static final ConfigOption<Integer> ANVIL_USE_SPARKS_MAX_ON_USE = registerOption(
        new IntOption(18, "anvil_use_sparks_max_on_use")
    );

    public static final ConfigOption<Boolean> GRINDSTONE_USE_SPARKS_ENABLED = registerOption(
        new BoolOption(true, "grindstone_use_sparks_enabled")
    );
    public static final ConfigOption<Integer> GRINDSTONE_USE_SPARKS_MAX_ON_USE = registerOption(
        new IntOption(12, "grindstone_use_sparks_max_on_use")
    );

    public static final ConfigOption<Boolean> BLOCK_FALLING_EFFECT_ENABLED = registerOption(
        new BoolOption(true, "block_falling_effect_enabled")
    );
    public static final ConfigOption<Integer> BLOCK_FALLING_EFFECT_RENDER_DISTANCE = registerOption(
        new IntOption(64, "block_falling_effect_render_distance")
    );

    public static final ConfigOption<Boolean> REDSTONE_INTERACTION_DUST_ENABLED = registerOption(
        new BoolOption(true, "redstone_interaction_dust_enabled")
    );
    public static final ConfigOption<Integer> REDSTONE_INTERACTION_DUST_AMOUNT = registerOption(
        new IntOption(6, "redstone_interaction_dust_amount")
    );

    public static final ConfigOption<Boolean> SMOKER_SMOKE_ENABLED = registerOption(
        new BoolOption(true, "smoker_smoke_enabled")
    );

    public static final ConfigOption<Boolean> FURNACE_EMBERS_ENABLED = registerOption(
        new BoolOption(true, "furnace_embers_enabled")
    );
    public static final ConfigOption<Boolean> VANILLA_FURNACE_PARTICLES_ENABLED = registerOption(
        new BoolOption(false, "vanilla_furnace_particles_enabled")
    );

    public static final ConfigOption<Boolean> BLAST_FURNACE_SPARKS_ENABLED = registerOption(
        new BoolOption(true, "blast_furnace_sparks_enabled")
    );


    private static <T> ConfigOption<T> registerOption(ConfigOption<T> option) {
        return ConfigOptions.registerOption(ConfigCategory.BLOCK_INTERACTIONS, option);
    }

    public static void init() {}
}
