package games.enchanted.eg_particle_interactions.common.config.option;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import games.enchanted.eg_particle_interactions.common.Logging;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_2960;

public class ResourceLocationListOption extends ConfigOption<List<class_2960>> {
    public static final Codec<List<class_2960>> CODEC = class_2960.field_25139.listOf();

    public ResourceLocationListOption(List<class_2960> initialAndDefaultValue, String jsonKey) {
        super(initialAndDefaultValue, jsonKey);
    }

    @Override
    public @Nullable JsonElement toJson() {
        DataResult<JsonElement> encodedResult = CODEC.encodeStart(JsonOps.INSTANCE, this.getValue());
        if(encodedResult.isError()) {
            Logging.error("Failed to encode config option {}", this.getJsonKey(), encodedResult.error().orElseThrow().message());
            return null;
        }
        return encodedResult.getOrThrow();
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonElement jsonElement = json.getAsJsonArray(this.getJsonKey());
        DataResult<List<class_2960>> parsedResult = CODEC.parse(JsonOps.INSTANCE, jsonElement);
        if(parsedResult.isError()) {
            this.resetToDefault(false);
            return;
        }
        this.setPendingValue(parsedResult.getOrThrow());
    }
}
