package games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.generic.AbstractFixedDropdownController;
import games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.BlockOrTagLocation;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlockLocationController extends AbstractFixedDropdownController<BlockOrTagLocation> {
    public BlockLocationController(Option<BlockOrTagLocation> option) {
        super(option);
    }

    @Override
    public String getString() {
        return option().pendingValue().toString();
    }

    @Override
    public void setFromStringIndex(String value, int index) {
        String valueFromDropdown = getValueFromDropdown(index);
        if(valueFromDropdown == null) {
            valueFromDropdown = value;
        }
        BlockOrTagLocation validatedValue = RegistryHelpers.validateBlockOrTagLocationWithFallback(
            valueFromDropdown,
            null
        );
        if(isValueValid(valueFromDropdown) && validatedValue != null) {
            option.requestSet(
                validatedValue
            );
        }
    };

    @Override
    public boolean isValueValid(String value) {
        BlockOrTagLocation blockLocFromValue = RegistryHelpers.validateBlockOrTagLocationWithFallback(value, null);
        return blockLocFromValue != null;
    }

    @Override
    protected String getValidValue(String value, int offset) {
        if(value.startsWith("#")) {
            value = value.replace("#", "");
            return RegistryHelpers.getMatchingTagLocations(value, class_7923.field_41175)
                .skip(offset)
                .findFirst()
                .map(class_2960::toString)
                .orElseGet(this::getString);
        }

        return RegistryHelpers.getMatchingLocations(value, class_7923.field_41175)
            .filter((class_2960 location) -> !RegistryHelpers.getBlockFromLocation(location).method_9564().method_26215())
            .skip(offset)
            .findFirst()
            .map(class_2960::toString)
            .orElseGet(this::getString);
    }

    @Override
    public GenericListControllerElement<BlockOrTagLocation, ?> createWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BlockLocationControllerElement(this, screen, widgetDimension);
    }
}