package games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller;

import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import games.enchanted.eg_particle_interactions.common.config.screen.yacl.controller.generic.GenericListControllerElement;
import games.enchanted.eg_particle_interactions.common.registry.RegistryHelpers;
import games.enchanted.eg_particle_interactions.common.util.TextUtil;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_7923;

public class FluidLocationControllerElement extends GenericListControllerElement<class_2960, FluidLocationController> {
    public FluidLocationControllerElement(FluidLocationController control, YACLScreen screen, Dimension<Integer> dim) {
        super(control, screen, dim);
    }

    @Override
    public List<class_2960> computeMatchingValues() {
        List<class_2960> resourceLocations = RegistryHelpers.getMatchingLocations(inputField, class_7923.field_41173).toList();
        ArrayList<class_2960> fluidLocations = new ArrayList<>();
        currentItem = RegistryHelpers.validateFluidLocationWithFallback(inputField, null);
        for (class_2960 resourceLocation : resourceLocations) {
            class_3611 blockFromLocation = RegistryHelpers.getFluidFromLocation(resourceLocation);
            if (blockFromLocation.method_15785().method_15759().method_26215()) continue;
            matchingItems.put(resourceLocation, RegistryHelpers.getLocationFromFluid(blockFromLocation));
            fluidLocations.add(resourceLocation);
        }
        return fluidLocations;
    }

    @Override
    protected void renderDropdownEntry(class_332 graphics, Dimension<Integer> entryDimension, class_2960 identifier) {
        class_2960 item = matchingItems.get(identifier);
        if(item == null) return;
        super.renderDropdownEntry(graphics, entryDimension, identifier);
        this.renderItemIcon(graphics, getItemToRender(item), entryDimension.xLimit() - 2, entryDimension.y() + 1);
    }

    @Override
    public @Nullable class_2561 getHoverTooltipText() {
        return TextUtil.formatIdentifierToChatComponent(this.getController().option().pendingValue());
    }

    @Override
    public class_1792 getItemToRender(class_2960 value) {
        return RegistryHelpers.getFluidFromLocation(value).method_15774();
    }

    @Override
    public class_2561 getRenderedValueText() {
        return class_2561.method_43471( RegistryHelpers.getFluidFromLocation(getController().option().pendingValue()).method_15785().method_15759().method_26204().method_63499() );
    }
}
